/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.duo.web.flow.action;

import java.util.Objects;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityAuthenticationService;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityCredential;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityMultifactorAuthenticationProvider;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.apereo.cas.web.flow.actions.AbstractMultifactorAuthenticationAction;
import org.apereo.cas.web.support.WebUtils;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class DuoSecurityPrepareWebLoginFormAction
extends AbstractMultifactorAuthenticationAction<DuoSecurityMultifactorAuthenticationProvider> {
    protected Event doExecute(RequestContext requestContext) {
        Principal principal = this.resolvePrincipal(WebUtils.getAuthentication((RequestContext)requestContext).getPrincipal());
        DuoSecurityCredential credential = (DuoSecurityCredential)requestContext.getFlowScope().get("credential", DuoSecurityCredential.class);
        Objects.requireNonNull(credential).setUsername(principal.getId());
        credential.setProviderId(((DuoSecurityMultifactorAuthenticationProvider)this.provider).getId());
        SpringExpressionLanguageValueResolver resolver = SpringExpressionLanguageValueResolver.getInstance();
        DuoSecurityAuthenticationService duoAuthenticationService = ((DuoSecurityMultifactorAuthenticationProvider)this.provider).getDuoAuthenticationService();
        MutableAttributeMap viewScope = requestContext.getViewScope();
        duoAuthenticationService.signRequestToken(principal.getId()).ifPresent(value -> viewScope.put("sigRequest", value));
        viewScope.put("apiHost", (Object)resolver.resolve(duoAuthenticationService.getProperties().getDuoApiHost()));
        viewScope.put("principal", (Object)principal);
        return this.success();
    }
}

