/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.variable.service.impl.types;

import javax.persistence.EntityManagerFactory;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.Session;
import org.flowable.common.engine.impl.interceptor.SessionFactory;
import org.flowable.variable.service.impl.types.EntityManagerSession;
import org.flowable.variable.service.impl.types.EntityManagerSessionImpl;

public class EntityManagerSessionFactory
implements SessionFactory {
    protected EntityManagerFactory entityManagerFactory;
    protected boolean handleTransactions;
    protected boolean closeEntityManager;

    public EntityManagerSessionFactory(Object entityManagerFactory, boolean handleTransactions, boolean closeEntityManager) {
        if (entityManagerFactory == null) {
            throw new FlowableIllegalArgumentException("entityManagerFactory is null");
        }
        if (!(entityManagerFactory instanceof EntityManagerFactory)) {
            throw new FlowableIllegalArgumentException("EntityManagerFactory must implement 'javax.persistence.EntityManagerFactory'");
        }
        this.entityManagerFactory = (EntityManagerFactory)entityManagerFactory;
        this.handleTransactions = handleTransactions;
        this.closeEntityManager = closeEntityManager;
    }

    public Class<?> getSessionType() {
        return EntityManagerSession.class;
    }

    public Session openSession(CommandContext commandContext) {
        return new EntityManagerSessionImpl(this.entityManagerFactory, this.handleTransactions, this.closeEntityManager);
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }
}

