/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.variable.service.impl.types;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.variable.api.types.ValueFields;
import org.flowable.variable.api.types.VariableType;
import org.flowable.variable.service.impl.types.CacheableVariable;
import org.flowable.variable.service.impl.types.EntityManagerSession;
import org.flowable.variable.service.impl.types.JPAEntityMappings;

public class JPAEntityListVariableType
implements VariableType,
CacheableVariable {
    public static final String TYPE_NAME = "jpa-entity-list";
    protected JPAEntityMappings mappings = new JPAEntityMappings();
    protected boolean forceCachedValue;

    @Override
    public void setForceCacheable(boolean forceCachedValue) {
        this.forceCachedValue = forceCachedValue;
    }

    public String getTypeName() {
        return TYPE_NAME;
    }

    public boolean isCachable() {
        return this.forceCachedValue;
    }

    public boolean isAbleToStore(Object value) {
        boolean canStore;
        block1: {
            Object entity;
            List list;
            canStore = false;
            if (!(value instanceof List) || (list = (List)value).size() <= 0) break block1;
            canStore = true;
            Class<?> entityClass = this.mappings.getEntityMetaData(list.get(0).getClass()).getEntityClass();
            Iterator iterator = list.iterator();
            while (iterator.hasNext() && (canStore = (entity = iterator.next()) != null && this.mappings.isJPAEntity(entity) && this.mappings.getEntityMetaData(entity.getClass()).getEntityClass().equals(entityClass))) {
            }
        }
        return canStore;
    }

    public void setValue(Object value, ValueFields valueFields) {
        EntityManagerSession entityManagerSession = (EntityManagerSession)Context.getCommandContext().getSession(EntityManagerSession.class);
        if (entityManagerSession == null) {
            throw new FlowableException("Cannot set JPA variable: " + EntityManagerSession.class + " not configured");
        }
        entityManagerSession.flush();
        if (value instanceof List && ((List)value).size() > 0) {
            List list = (List)value;
            ArrayList<String> ids = new ArrayList<String>();
            String type = this.mappings.getJPAClassString(list.get(0));
            for (Object entry : list) {
                ids.add(this.mappings.getJPAIdString(entry));
            }
            valueFields.setBytes(this.serializeIds(ids));
            valueFields.setTextValue(type);
        } else if (value == null) {
            valueFields.setBytes(null);
            valueFields.setTextValue(null);
        } else {
            throw new FlowableIllegalArgumentException("Value is not a list of JPA entities: " + value);
        }
    }

    public Object getValue(ValueFields valueFields) {
        byte[] bytes = valueFields.getBytes();
        if (valueFields.getTextValue() != null && bytes != null) {
            String[] ids;
            String entityClass = valueFields.getTextValue();
            ArrayList<Object> result = new ArrayList<Object>();
            for (String id : ids = this.deserializeIds(bytes)) {
                result.add(this.mappings.getJPAEntity(entityClass, id));
            }
            return result;
        }
        return null;
    }

    protected byte[] serializeIds(List<String> ids) {
        try {
            String[] toStore = ids.toArray(new String[0]);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(baos);
            out.writeObject(toStore);
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new FlowableException("Unexpected exception when serializing JPA id's", (Throwable)ioe);
        }
    }

    protected String[] deserializeIds(byte[] bytes) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ObjectInputStream in = new ObjectInputStream(bais);
            Object read = in.readObject();
            if (!(read instanceof String[])) {
                throw new FlowableIllegalArgumentException("Deserialized value is not an array of ID's: " + read);
            }
            return (String[])read;
        }
        catch (IOException | ClassNotFoundException ioe) {
            throw new FlowableException("Unexpected exception when deserializing JPA id's", (Throwable)ioe);
        }
    }
}

