/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.mgmt;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import java.util.Collection;
import java.util.Comparator;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.support.oauth.profile.OAuth20ProfileScopeToAttributesFilter;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20JwtAccessTokenEncoder;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.ticket.refreshtoken.OAuth20RefreshToken;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.token.JwtBuilder;
import org.apereo.cas.web.BaseCasActuatorEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.endpoint.annotation.DeleteOperation;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;

@Endpoint(id="oauthTokens", enableByDefault=false)
public class OAuth20TokenManagementEndpoint
extends BaseCasActuatorEndpoint {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20TokenManagementEndpoint.class);
    private final TicketRegistry ticketRegistry;
    private final JwtBuilder accessTokenJwtBuilder;
    private final OAuth20ProfileScopeToAttributesFilter profileScopeToAttributesFilter;

    public OAuth20TokenManagementEndpoint(CasConfigurationProperties casProperties, TicketRegistry ticketRegistry, JwtBuilder accessTokenJwtBuilder, OAuth20ProfileScopeToAttributesFilter profileScopeToAttributesFilter) {
        super(casProperties);
        this.ticketRegistry = ticketRegistry;
        this.accessTokenJwtBuilder = accessTokenJwtBuilder;
        this.profileScopeToAttributesFilter = profileScopeToAttributesFilter;
    }

    @ReadOperation
    @Operation(summary="Get access and/or refresh tokens")
    public Collection<Ticket> getTokens() {
        return this.ticketRegistry.getTickets(ticket -> (ticket instanceof OAuth20AccessToken || ticket instanceof OAuth20RefreshToken) && !ticket.isExpired()).sorted(Comparator.comparing(Ticket::getId)).collect(Collectors.toList());
    }

    @ReadOperation
    @Operation(summary="Get single token by id", parameters={@Parameter(name="token", required=true)})
    public Ticket getToken(@Selector String token) {
        try {
            String ticketId = this.extractAccessTokenFrom(token);
            return this.ticketRegistry.getTicket(ticketId, Ticket.class);
        }
        catch (Exception e) {
            LOGGER.debug("Ticket [{}] is has expired or cannot be found", (Object)token);
            return null;
        }
    }

    @DeleteOperation
    @Operation(summary="Delete token by id", parameters={@Parameter(name="ticketId", required=true)})
    public void deleteToken(@Selector String ticketId) throws Exception {
        Ticket ticket = this.getToken(ticketId);
        if (ticket != null) {
            this.ticketRegistry.deleteTicket(ticket.getId());
        }
    }

    private String extractAccessTokenFrom(String token) {
        return (String)((OAuth20JwtAccessTokenEncoder.OAuth20JwtAccessTokenEncoderBuilder)((OAuth20JwtAccessTokenEncoder.OAuth20JwtAccessTokenEncoderBuilder)OAuth20JwtAccessTokenEncoder.builder().accessTokenJwtBuilder(this.accessTokenJwtBuilder)).profileScopeToAttributesFilter(this.profileScopeToAttributesFilter)).build().decode((Object)token);
    }
}

