/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.security;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.access.vote.AbstractAccessDecisionManager;
import org.springframework.security.access.vote.AffirmativeBased;
import org.springframework.security.access.vote.RoleVoter;
import org.springframework.security.access.vote.UnanimousBased;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.ClassUtils;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.definition.StateDefinition;
import org.springframework.webflow.definition.TransitionDefinition;
import org.springframework.webflow.execution.EnterStateVetoException;
import org.springframework.webflow.execution.FlowExecutionListener;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.security.SecurityRule;

public class SecurityFlowExecutionListener
implements FlowExecutionListener {
    private static final boolean SPRING_SECURITY_3_PRESENT = ClassUtils.hasConstructor(AffirmativeBased.class, (Class[])new Class[0]);
    private AccessDecisionManager accessDecisionManager;

    public AccessDecisionManager getAccessDecisionManager() {
        return this.accessDecisionManager;
    }

    public void setAccessDecisionManager(AccessDecisionManager accessDecisionManager) {
        this.accessDecisionManager = accessDecisionManager;
    }

    @Override
    public void sessionCreating(RequestContext context, FlowDefinition definition) {
        SecurityRule rule = (SecurityRule)definition.getAttributes().get("secured");
        if (rule != null) {
            this.decide(rule, definition);
        }
    }

    @Override
    public void stateEntering(RequestContext context, StateDefinition state) throws EnterStateVetoException {
        SecurityRule rule = (SecurityRule)state.getAttributes().get("secured");
        if (rule != null) {
            this.decide(rule, state);
        }
    }

    @Override
    public void transitionExecuting(RequestContext context, TransitionDefinition transition) {
        SecurityRule rule = (SecurityRule)transition.getAttributes().get("secured");
        if (rule != null) {
            this.decide(rule, transition);
        }
    }

    protected void decide(SecurityRule rule, Object object) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        Collection<ConfigAttribute> configAttributes = this.getConfigAttributes(rule);
        if (this.accessDecisionManager != null) {
            this.accessDecisionManager.decide(authentication, object, configAttributes);
        } else {
            AbstractAccessDecisionManager manager = SPRING_SECURITY_3_PRESENT ? this.createManagerWithSpringSecurity3(rule) : this.createManager(rule);
            manager.decide(authentication, object, configAttributes);
        }
    }

    private AbstractAccessDecisionManager createManager(SecurityRule rule) {
        ArrayList<RoleVoter> voters = new ArrayList<RoleVoter>();
        voters.add(new RoleVoter());
        if (rule.getComparisonType() == 1) {
            return new AffirmativeBased(voters);
        }
        if (rule.getComparisonType() == 2) {
            return new UnanimousBased(voters);
        }
        throw new IllegalStateException("Unknown SecurityRule match type: " + rule.getComparisonType());
    }

    private AbstractAccessDecisionManager createManagerWithSpringSecurity3(SecurityRule rule) {
        Class<AffirmativeBased> managerType;
        ArrayList<RoleVoter> voters = new ArrayList<RoleVoter>();
        voters.add(new RoleVoter());
        if (rule.getComparisonType() == 1) {
            managerType = AffirmativeBased.class;
        } else if (rule.getComparisonType() == 2) {
            managerType = UnanimousBased.class;
        } else {
            throw new IllegalStateException("Unknown SecurityRule match type: " + rule.getComparisonType());
        }
        try {
            Constructor constructor = managerType.getConstructor(new Class[0]);
            AbstractAccessDecisionManager manager = (AbstractAccessDecisionManager)constructor.newInstance(new Object[0]);
            new DirectFieldAccessor((Object)manager).setPropertyValue("decisionVoters", voters);
            return manager;
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Failed to initialize AccessDecisionManager", ex);
        }
    }

    protected Collection<ConfigAttribute> getConfigAttributes(SecurityRule rule) {
        ArrayList<ConfigAttribute> configAttributes = new ArrayList<ConfigAttribute>();
        for (String attribute : rule.getAttributes()) {
            configAttributes.add((ConfigAttribute)new SecurityConfig(attribute));
        }
        return configAttributes;
    }
}

