/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.profile.action.impl;

import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;
import org.opensaml.profile.action.AbstractHandlerDelegatingProfileAction;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.opensaml.xmlsec.SecurityConfigurationSupport;
import org.opensaml.xmlsec.SignatureValidationConfiguration;
import org.opensaml.xmlsec.SignatureValidationParametersResolver;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.opensaml.xmlsec.messaging.impl.PopulateSignatureValidationParametersHandler;

public class PopulateSignatureValidationParameters
extends AbstractHandlerDelegatingProfileAction<PopulateSignatureValidationParametersHandler> {
    @Nonnull
    private Function<ProfileRequestContext, SecurityParametersContext> securityParametersContextLookupStrategy = new ChildContextLookup(SecurityParametersContext.class, true).compose((Function)new InboundMessageContextLookup());
    @NonnullAfterInit
    private Function<ProfileRequestContext, List<SignatureValidationConfiguration>> configurationLookupStrategy;
    @NonnullAfterInit
    private SignatureValidationParametersResolver resolver;

    public PopulateSignatureValidationParameters() {
        super(PopulateSignatureValidationParametersHandler.class, (ContextDataLookupFunction)new InboundMessageContextLookup());
    }

    public void setSecurityParametersContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SecurityParametersContext> strategy) {
        this.checkSetterPreconditions();
        this.securityParametersContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SecurityParametersContext lookup strategy cannot be null");
    }

    public void setConfigurationLookupStrategy(@Nonnull Function<ProfileRequestContext, List<SignatureValidationConfiguration>> strategy) {
        this.checkSetterPreconditions();
        this.configurationLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SignatureValidationConfiguration lookup strategy cannot be null");
    }

    public void setSignatureValidationParametersResolver(@Nonnull SignatureValidationParametersResolver newResolver) {
        this.checkSetterPreconditions();
        this.resolver = (SignatureValidationParametersResolver)Constraint.isNotNull((Object)newResolver, (String)"SignatureValidationParametersResolver cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.resolver == null) {
            throw new ComponentInitializationException("SignatureValidationParametersResolver cannot be null");
        }
        if (this.configurationLookupStrategy == null) {
            this.configurationLookupStrategy = new Function<ProfileRequestContext, List<SignatureValidationConfiguration>>(){

                @Override
                public List<SignatureValidationConfiguration> apply(ProfileRequestContext input) {
                    return CollectionSupport.singletonList((Object)SecurityConfigurationSupport.ensureGlobalSignatureValidationConfiguration());
                }
            };
        }
        PopulateSignatureValidationParametersHandler delegate = (PopulateSignatureValidationParametersHandler)this.getDelegate();
        assert (this.resolver != null);
        delegate.setSignatureValidationParametersResolver(this.resolver);
        assert (this.configurationLookupStrategy != null);
        delegate.setConfigurationLookupStrategy(this.adaptRequired(this.configurationLookupStrategy));
        delegate.setSecurityParametersContextLookupStrategy(this.adaptRequired(this.securityParametersContextLookupStrategy));
        delegate.initialize();
    }
}

