/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.engine.test;

import java.lang.reflect.AnnotatedElement;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.test.EnsureCleanDb;
import org.flowable.common.engine.impl.test.EnsureCleanDbUtils;
import org.flowable.idm.engine.IdmEngine;
import org.flowable.idm.engine.IdmEngineConfiguration;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.support.AnnotationSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InternalFlowableIdmExtension
implements AfterEachCallback,
BeforeEachCallback,
AfterAllCallback,
ParameterResolver {
    protected static final String EMPTY_LINE = "\n";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void beforeEach(ExtensionContext context) {
    }

    public void afterEach(ExtensionContext context) throws Exception {
        this.doFinally(context, TestInstance.Lifecycle.PER_METHOD);
    }

    public void afterAll(ExtensionContext context) throws Exception {
        this.doFinally(context, TestInstance.Lifecycle.PER_CLASS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFinally(ExtensionContext context, TestInstance.Lifecycle lifecycleForClean) {
        IdmEngine idmEngine = this.getIdmEngine(context);
        IdmEngineConfiguration idmEngineConfiguration = idmEngine.getIdmEngineConfiguration();
        try {
            if (context.getTestInstanceLifecycle().orElse(TestInstance.Lifecycle.PER_METHOD) == lifecycleForClean) {
                this.cleanTestAndAssertAndEnsureCleanDb(context, idmEngine);
            }
        }
        finally {
            idmEngineConfiguration.getClock().reset();
        }
    }

    protected void cleanTestAndAssertAndEnsureCleanDb(ExtensionContext context, IdmEngine idmEngine) {
        AnnotationSupport.findAnnotation((AnnotatedElement)context.getRequiredTestClass(), EnsureCleanDb.class).ifPresent(ensureCleanDb -> this.assertAndEnsureCleanDb(idmEngine, context, (EnsureCleanDb)ensureCleanDb));
    }

    protected void assertAndEnsureCleanDb(IdmEngine idmEngine, ExtensionContext context, EnsureCleanDb ensureCleanDb) {
        EnsureCleanDbUtils.assertAndEnsureCleanDb((String)context.getDisplayName(), (Logger)this.logger, (AbstractEngineConfiguration)idmEngine.getIdmEngineConfiguration(), (EnsureCleanDb)ensureCleanDb, (!context.getExecutionException().isPresent() ? 1 : 0) != 0, (Command)idmEngine.getIdmEngineConfiguration().getSchemaManagementCmd());
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext context) {
        Class<?> parameterType = parameterContext.getParameter().getType();
        return IdmEngine.class.equals(parameterType);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext context) {
        return this.getIdmEngine(context);
    }

    protected abstract IdmEngine getIdmEngine(ExtensionContext var1);

    protected abstract ExtensionContext.Store getStore(ExtensionContext var1);
}

