/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.context;

import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.opensaml.messaging.context.BaseContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.saml.config.SAML2Configuration;

public class SAML2ConfigurationContext
extends BaseContext {
    public static final String REQUEST_ATTR_AUTHN_REQUEST_BINDING_TYPE = "AuthnRequestBindingType";
    public static final String REQUEST_ATTR_ASSERTION_CONSUMER_SERVICE_INDEX = "AssertionConsumerServiceIndex";
    public static final String REQUEST_ATTR_ATTRIBUTE_CONSUMING_SERVICE_INDEX = "AttributeConsumingServiceIndex";
    public static final String REQUEST_ATTR_COMPARISON_TYPE = "ComparisonType";
    public static final String REQUEST_ATTR_NAME_ID_POLICY_FORMAT = "NameIdPolicyFormat";
    public static final String REQUEST_ATTR_NAME_ID_POLICY_ALLOW_CREATE = "NameIdPolicyAllowCreate";
    public static final String REQUEST_ATTR_PROVIDER_NAME = "ProviderName";
    public static final String REQUEST_ATTR_ISSUER_FORMAT = "IssuerFormat";
    public static final String REQUEST_ATTR_USE_NAME_QUALIFIER = "UseNameQualifier";
    public static final String REQUEST_ATTR_AUTHN_CONTEXT_CLASS_REFS = "AuthnContextClassRefs";
    public static final String REQUEST_ATTR_NAME_ID_ATTRIBUTE = "NameIdAttribute";
    public static final String REQUEST_ATTR_WANTS_ASSERTIONS_SIGNED = "WantsAssertionsSigned";
    public static final String REQUEST_ATTR_WANTS_RESPONSES_SIGNED = "WantsResponsesSigned";
    public static final String REQUEST_ATTR_MAXIMUM_AUTHENTICATION_LIFETIME = "MaximumAuthenticationLifetime";
    private final WebContext webContext;
    private final SAML2Configuration configuration;

    public SAML2ConfigurationContext(WebContext webContext, SAML2Configuration configuration) {
        this.webContext = webContext;
        this.configuration = configuration;
    }

    public SAML2Configuration getSAML2Configuration() {
        return this.configuration;
    }

    public String getAuthnRequestBindingType() {
        return this.webContext.getRequestAttribute(REQUEST_ATTR_AUTHN_REQUEST_BINDING_TYPE).orElse(this.configuration.getAuthnRequestBindingType());
    }

    public Integer getAssertionConsumerServiceIndex() {
        return this.webContext.getRequestAttribute(REQUEST_ATTR_ASSERTION_CONSUMER_SERVICE_INDEX).orElse(this.configuration.getAssertionConsumerServiceIndex());
    }

    public Integer getAttributeConsumingServiceIndex() {
        return this.webContext.getRequestAttribute(REQUEST_ATTR_ATTRIBUTE_CONSUMING_SERVICE_INDEX).orElse(this.configuration.getAttributeConsumingServiceIndex());
    }

    public String getComparisonType() {
        return this.webContext.getRequestAttribute(REQUEST_ATTR_COMPARISON_TYPE).orElse(this.configuration.getComparisonType());
    }

    public String getNameIdPolicyFormat() {
        return this.webContext.getRequestAttribute(REQUEST_ATTR_NAME_ID_POLICY_FORMAT).orElse(this.configuration.getNameIdPolicyFormat());
    }

    public Boolean isNameIdPolicyAllowCreate() {
        return this.webContext.getRequestAttribute(REQUEST_ATTR_NAME_ID_POLICY_ALLOW_CREATE).orElse(BooleanUtils.toBoolean((Boolean)this.configuration.getNameIdPolicyAllowCreate()));
    }

    public String getProviderName() {
        return this.webContext.getRequestAttribute(REQUEST_ATTR_PROVIDER_NAME).orElse(this.configuration.getProviderName());
    }

    public String getIssuerFormat() {
        return this.webContext.getRequestAttribute(REQUEST_ATTR_ISSUER_FORMAT).orElse(this.configuration.getIssuerFormat());
    }

    public Boolean isUseNameQualifier() {
        return this.webContext.getRequestAttribute(REQUEST_ATTR_USE_NAME_QUALIFIER).orElse(BooleanUtils.toBoolean((Boolean)this.configuration.isUseNameQualifier()));
    }

    public List<String> getAuthnContextClassRefs() {
        return this.webContext.getRequestAttribute(REQUEST_ATTR_AUTHN_CONTEXT_CLASS_REFS).orElse(this.configuration.getAuthnContextClassRefs());
    }

    public Boolean isPassive() {
        return this.webContext.getRequestAttribute("Passive").isPresent() || BooleanUtils.toBoolean((Boolean)this.configuration.isPassive());
    }

    public Boolean isForceAuth() {
        return this.webContext.getRequestAttribute("ForceAuthn").isPresent() || BooleanUtils.toBoolean((Boolean)this.configuration.isForceAuth());
    }

    public String getNameIdAttribute() {
        return this.webContext.getRequestAttribute(REQUEST_ATTR_NAME_ID_ATTRIBUTE).orElse(this.configuration.getNameIdAttribute());
    }

    public Boolean isWantsAssertionsSigned() {
        return this.webContext.getRequestAttribute(REQUEST_ATTR_WANTS_ASSERTIONS_SIGNED).orElse(BooleanUtils.toBoolean((Boolean)this.configuration.isWantsAssertionsSigned()));
    }

    public Long getMaximumAuthenticationLifetime() {
        return this.webContext.getRequestAttribute(REQUEST_ATTR_MAXIMUM_AUTHENTICATION_LIFETIME).orElse(this.configuration.getMaximumAuthenticationLifetime());
    }

    public boolean isWantsResponsesSigned() {
        return this.webContext.getRequestAttribute(REQUEST_ATTR_WANTS_RESPONSES_SIGNED).orElse(this.configuration.isWantsResponsesSigned());
    }
}

