/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket;

import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.jose4j.jwk.EllipticCurveJsonWebKey;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.PublicJsonWebKey;
import org.jose4j.jwt.JwtClaims;

public interface OAuth20TokenSigningAndEncryptionService {
    public String encode(OAuthRegisteredService var1, JwtClaims var2) throws Throwable;

    public JwtClaims decode(String var1, Optional<OAuthRegisteredService> var2);

    default public String getJsonWebKeySigningAlgorithm(OAuthRegisteredService registeredService, JsonWebKey signingKey) {
        String defaultAlgorithm = "RS256";
        if (signingKey instanceof EllipticCurveJsonWebKey) {
            defaultAlgorithm = "ES256";
        }
        return (String)StringUtils.defaultIfBlank((CharSequence)signingKey.getAlgorithm(), (CharSequence)defaultAlgorithm);
    }

    public PublicJsonWebKey getJsonWebKeySigningKey(Optional<OAuthRegisteredService> var1) throws Throwable;

    default public boolean shouldSignToken(OAuthRegisteredService registeredService) {
        return false;
    }

    default public boolean shouldEncryptToken(OAuthRegisteredService registeredService) {
        return false;
    }

    public String resolveIssuer(Optional<OAuthRegisteredService> var1);
}

