/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.gauth.credential;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.warrenstrange.googleauth.IGoogleAuthenticator;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.core5.http.HttpEntityContainer;
import org.apache.hc.core5.http.HttpResponse;
import org.apereo.cas.authentication.OneTimeTokenAccount;
import org.apereo.cas.configuration.model.support.mfa.gauth.GoogleAuthenticatorMultifactorProperties;
import org.apereo.cas.configuration.model.support.mfa.gauth.RestfulGoogleAuthenticatorMultifactorProperties;
import org.apereo.cas.gauth.credential.BaseGoogleAuthenticatorTokenCredentialRepository;
import org.apereo.cas.gauth.credential.GoogleAuthenticatorAccount;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.http.HttpExecutionRequest;
import org.apereo.cas.util.http.HttpUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.hjson.JsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;

public class RestGoogleAuthenticatorTokenCredentialRepository
extends BaseGoogleAuthenticatorTokenCredentialRepository {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RestGoogleAuthenticatorTokenCredentialRepository.class);
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(true).singleValueAsArray(true).build().toObjectMapper();
    private final GoogleAuthenticatorMultifactorProperties gauth;

    public RestGoogleAuthenticatorTokenCredentialRepository(IGoogleAuthenticator googleAuthenticator, GoogleAuthenticatorMultifactorProperties gauth, CipherExecutor<String, String> tokenCredentialCipher, CipherExecutor<Number, Number> scratchCodesCipher) {
        super(tokenCredentialCipher, scratchCodesCipher, googleAuthenticator);
        this.gauth = gauth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OneTimeTokenAccount get(long id) {
        RestfulGoogleAuthenticatorMultifactorProperties rest = this.gauth.getRest();
        HttpResponse response = null;
        try {
            HttpStatus status;
            Map headers = CollectionUtils.wrap((String)"Content-Type", (Object)"application/json", (String)"id", (Object)String.valueOf(id));
            headers.putAll(rest.getHeaders());
            HttpExecutionRequest exec = HttpExecutionRequest.builder().basicAuthPassword(rest.getBasicAuthPassword()).basicAuthUsername(rest.getBasicAuthUsername()).method(HttpMethod.GET).url(rest.getUrl()).headers(headers).build();
            response = HttpUtils.execute((HttpExecutionRequest)exec);
            if (response != null && (status = HttpStatus.valueOf((int)response.getCode())).is2xxSuccessful()) {
                try (InputStream contis = ((HttpEntityContainer)response).getEntity().getContent();){
                    String content = IOUtils.toString((InputStream)contis, (Charset)StandardCharsets.UTF_8);
                    if (content != null) {
                        TypeReference<GoogleAuthenticatorAccount> values = new TypeReference<GoogleAuthenticatorAccount>(this){};
                        GoogleAuthenticatorAccount result = (GoogleAuthenticatorAccount)MAPPER.readValue(JsonValue.readHjson((String)content).toString(), (TypeReference)values);
                        OneTimeTokenAccount oneTimeTokenAccount = this.decode((OneTimeTokenAccount)Objects.requireNonNull(result));
                        HttpUtils.close((HttpResponse)response);
                        return oneTimeTokenAccount;
                    }
                }
            }
            HttpUtils.close((HttpResponse)response);
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
        finally {
            HttpUtils.close(response);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OneTimeTokenAccount get(String username, long id) {
        HttpResponse response = null;
        try {
            HttpStatus status;
            RestfulGoogleAuthenticatorMultifactorProperties rest = this.gauth.getRest();
            Map headers = CollectionUtils.wrap((String)"Content-Type", (Object)"application/json", (String)"id", (Object)String.valueOf(id), (String)"username", (Object)username);
            headers.putAll(rest.getHeaders());
            HttpExecutionRequest exec = HttpExecutionRequest.builder().basicAuthPassword(rest.getBasicAuthPassword()).basicAuthUsername(rest.getBasicAuthUsername()).method(HttpMethod.GET).url(rest.getUrl()).headers(headers).build();
            response = HttpUtils.execute((HttpExecutionRequest)exec);
            if (response != null && (status = HttpStatus.valueOf((int)response.getCode())).is2xxSuccessful()) {
                try (InputStream contis = ((HttpEntityContainer)response).getEntity().getContent();){
                    String content = IOUtils.toString((InputStream)contis, (Charset)StandardCharsets.UTF_8);
                    if (content != null) {
                        TypeReference<GoogleAuthenticatorAccount> values = new TypeReference<GoogleAuthenticatorAccount>(this){};
                        GoogleAuthenticatorAccount result = (GoogleAuthenticatorAccount)MAPPER.readValue(JsonValue.readHjson((String)content).toString(), (TypeReference)values);
                        OneTimeTokenAccount oneTimeTokenAccount = this.decode((OneTimeTokenAccount)Objects.requireNonNull(result));
                        HttpUtils.close((HttpResponse)response);
                        return oneTimeTokenAccount;
                    }
                }
            }
            HttpUtils.close((HttpResponse)response);
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
        finally {
            HttpUtils.close(response);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<? extends OneTimeTokenAccount> get(String username) {
        RestfulGoogleAuthenticatorMultifactorProperties rest = this.gauth.getRest();
        HttpResponse response = null;
        try {
            HttpStatus status;
            Map headers = CollectionUtils.wrap((String)"Content-Type", (Object)"application/json", (String)"username", (Object)username);
            headers.putAll(rest.getHeaders());
            HttpExecutionRequest exec = HttpExecutionRequest.builder().basicAuthPassword(rest.getBasicAuthPassword()).basicAuthUsername(rest.getBasicAuthUsername()).method(HttpMethod.GET).url(rest.getUrl()).headers(headers).build();
            response = HttpUtils.execute((HttpExecutionRequest)exec);
            if (response != null && (status = HttpStatus.valueOf((int)response.getCode())).is2xxSuccessful()) {
                try (InputStream contis = ((HttpEntityContainer)response).getEntity().getContent();){
                    String content = IOUtils.toString((InputStream)contis, (Charset)StandardCharsets.UTF_8);
                    if (content != null) {
                        TypeReference<List<GoogleAuthenticatorAccount>> values = new TypeReference<List<GoogleAuthenticatorAccount>>(this){};
                        List result = (List)MAPPER.readValue(JsonValue.readHjson((String)content).toString(), (TypeReference)values);
                        Collection collection = this.decode(Objects.requireNonNull(result));
                        HttpUtils.close((HttpResponse)response);
                        return collection;
                    }
                }
            }
            HttpUtils.close((HttpResponse)response);
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
        finally {
            HttpUtils.close(response);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<? extends OneTimeTokenAccount> load() {
        RestfulGoogleAuthenticatorMultifactorProperties rest = this.gauth.getRest();
        HttpResponse response = null;
        try {
            HttpStatus status;
            Map headers = CollectionUtils.wrap((String)"Accept", (Object)"application/json");
            headers.putAll(rest.getHeaders());
            HttpExecutionRequest exec = HttpExecutionRequest.builder().basicAuthPassword(rest.getBasicAuthPassword()).basicAuthUsername(rest.getBasicAuthUsername()).method(HttpMethod.GET).url(rest.getUrl()).headers(headers).build();
            response = HttpUtils.execute((HttpExecutionRequest)exec);
            if (response != null && (status = HttpStatus.valueOf((int)response.getCode())).is2xxSuccessful()) {
                try (InputStream contents = ((HttpEntityContainer)response).getEntity().getContent();){
                    String content = IOUtils.toString((InputStream)contents, (Charset)StandardCharsets.UTF_8);
                    if (content != null) {
                        List results = (List)MAPPER.readValue(JsonValue.readHjson((String)content).toString(), (TypeReference)new TypeReference<List<GoogleAuthenticatorAccount>>(this){});
                        Collection collection = results.stream().map(x$0 -> this.decode((OneTimeTokenAccount)x$0)).collect(Collectors.toList());
                        HttpUtils.close((HttpResponse)response);
                        return collection;
                    }
                }
            }
            HttpUtils.close((HttpResponse)response);
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
        finally {
            HttpUtils.close(response);
        }
        return new ArrayList();
    }

    public OneTimeTokenAccount save(OneTimeTokenAccount account) {
        return this.update(account.assignIdIfNecessary());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OneTimeTokenAccount update(OneTimeTokenAccount accountToUpdate) {
        RestfulGoogleAuthenticatorMultifactorProperties rest = this.gauth.getRest();
        HttpResponse response = null;
        try {
            HttpStatus status;
            OneTimeTokenAccount account = this.encode(accountToUpdate);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Accept", "application/json");
            headers.put("username", account.getUsername());
            headers.put("validationCode", String.valueOf(account.getValidationCode()));
            headers.put("secretKey", account.getSecretKey());
            String codes = account.getScratchCodes().stream().map(Object::toString).collect(Collectors.joining(","));
            headers.put("scratchCodes", codes);
            headers.putAll(rest.getHeaders());
            HttpExecutionRequest exec = HttpExecutionRequest.builder().basicAuthPassword(rest.getBasicAuthPassword()).basicAuthUsername(rest.getBasicAuthUsername()).method(HttpMethod.POST).url(rest.getUrl()).headers(headers).build();
            response = HttpUtils.execute((HttpExecutionRequest)exec);
            if (response != null && (status = HttpStatus.valueOf((int)response.getCode())).is2xxSuccessful()) {
                LOGGER.debug("Posted google authenticator account successfully");
                OneTimeTokenAccount oneTimeTokenAccount = account;
                HttpUtils.close((HttpResponse)response);
                return oneTimeTokenAccount;
            }
            HttpUtils.close((HttpResponse)response);
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
        finally {
            HttpUtils.close(response);
        }
        LOGGER.warn("Failed to save google authenticator account successfully");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll() {
        RestfulGoogleAuthenticatorMultifactorProperties rest = this.gauth.getRest();
        HttpResponse response = null;
        try {
            HttpExecutionRequest exec = HttpExecutionRequest.builder().basicAuthPassword(rest.getBasicAuthPassword()).basicAuthUsername(rest.getBasicAuthUsername()).method(HttpMethod.GET).url(rest.getUrl()).headers(rest.getHeaders()).build();
            response = HttpUtils.execute((HttpExecutionRequest)exec);
        }
        catch (Throwable throwable) {
            HttpUtils.close(response);
            throw throwable;
        }
        HttpUtils.close((HttpResponse)response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String username) {
        RestfulGoogleAuthenticatorMultifactorProperties rest = this.gauth.getRest();
        HttpResponse response = null;
        try {
            Map headers = CollectionUtils.wrap((String)"Accept", (Object)"application/json", (String)"username", (Object)username);
            headers.putAll(rest.getHeaders());
            HttpExecutionRequest exec = HttpExecutionRequest.builder().basicAuthPassword(rest.getBasicAuthPassword()).basicAuthUsername(rest.getBasicAuthUsername()).method(HttpMethod.GET).url(rest.getUrl()).headers(headers).build();
            response = HttpUtils.execute((HttpExecutionRequest)exec);
        }
        catch (Throwable throwable) {
            HttpUtils.close(response);
            throw throwable;
        }
        HttpUtils.close((HttpResponse)response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(long id) {
        RestfulGoogleAuthenticatorMultifactorProperties rest = this.gauth.getRest();
        HttpResponse response = null;
        try {
            Map headers = CollectionUtils.wrap((String)"Accept", (Object)"application/json", (String)"id", (Object)id);
            headers.putAll(rest.getHeaders());
            HttpExecutionRequest exec = HttpExecutionRequest.builder().basicAuthPassword(rest.getBasicAuthPassword()).basicAuthUsername(rest.getBasicAuthUsername()).method(HttpMethod.GET).url(rest.getUrl()).headers(headers).build();
            response = HttpUtils.execute((HttpExecutionRequest)exec);
        }
        catch (Throwable throwable) {
            HttpUtils.close(response);
            throw throwable;
        }
        HttpUtils.close((HttpResponse)response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long count() {
        RestfulGoogleAuthenticatorMultifactorProperties rest = this.gauth.getRest();
        HttpResponse response = null;
        try {
            HttpStatus status;
            Map headers = CollectionUtils.wrap((String)"Accept", (Object)"application/json");
            headers.putAll(rest.getHeaders());
            String countUrl = StringUtils.appendIfMissing((String)rest.getUrl(), (CharSequence)"/", (CharSequence[])new CharSequence[0]).concat("count");
            HttpExecutionRequest exec = HttpExecutionRequest.builder().basicAuthPassword(rest.getBasicAuthPassword()).basicAuthUsername(rest.getBasicAuthUsername()).method(HttpMethod.GET).url(countUrl).headers(headers).build();
            response = HttpUtils.execute((HttpExecutionRequest)exec);
            if (response != null && (status = HttpStatus.valueOf((int)response.getCode())).is2xxSuccessful()) {
                try (InputStream contis = ((HttpEntityContainer)response).getEntity().getContent();){
                    String content = IOUtils.toString((InputStream)contis, (Charset)StandardCharsets.UTF_8);
                    if (content != null) {
                        long l = (Long)MAPPER.readValue(JsonValue.readHjson((String)content).toString(), Long.class);
                        HttpUtils.close((HttpResponse)response);
                        return l;
                    }
                }
            }
            HttpUtils.close((HttpResponse)response);
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
        finally {
            HttpUtils.close(response);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long count(String username) {
        RestfulGoogleAuthenticatorMultifactorProperties rest = this.gauth.getRest();
        HttpResponse response = null;
        try {
            HttpStatus status;
            Map headers = CollectionUtils.wrap((String)"Accept", (Object)"application/json", (String)"username", (Object)username);
            headers.putAll(rest.getHeaders());
            String countUrl = StringUtils.appendIfMissing((String)rest.getUrl(), (CharSequence)"/", (CharSequence[])new CharSequence[0]).concat("count");
            HttpExecutionRequest exec = HttpExecutionRequest.builder().basicAuthPassword(rest.getBasicAuthPassword()).basicAuthUsername(rest.getBasicAuthUsername()).method(HttpMethod.GET).url(countUrl).headers(headers).build();
            response = HttpUtils.execute((HttpExecutionRequest)exec);
            if (response != null && (status = HttpStatus.valueOf((int)response.getCode())).is2xxSuccessful()) {
                try (InputStream contis = ((HttpEntityContainer)response).getEntity().getContent();){
                    String content = IOUtils.toString((InputStream)contis, (Charset)StandardCharsets.UTF_8);
                    if (content != null) {
                        long l = (Long)MAPPER.readValue(JsonValue.readHjson((String)content).toString(), Long.class);
                        HttpUtils.close((HttpResponse)response);
                        return l;
                    }
                }
            }
            HttpUtils.close((HttpResponse)response);
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
        finally {
            HttpUtils.close(response);
        }
        return 0L;
    }

    @Generated
    public GoogleAuthenticatorMultifactorProperties getGauth() {
        return this.gauth;
    }
}

