/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.wa.starter.pac4j.saml;

import java.util.Base64;
import net.shibboleth.shared.resolver.ResolverException;
import org.apache.syncope.common.rest.api.service.wa.WASAML2SPService;
import org.apache.syncope.wa.bootstrap.WARestClient;
import org.opensaml.saml.metadata.resolver.impl.AbstractReloadingMetadataResolver;
import org.pac4j.saml.client.SAML2Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WASAML2MetadataResolver
extends AbstractReloadingMetadataResolver {
    protected static final Logger LOG = LoggerFactory.getLogger(WASAML2MetadataResolver.class);
    protected final WARestClient waRestClient;
    protected final SAML2Client saml2Client;

    public WASAML2MetadataResolver(WARestClient waRestClient, SAML2Client saml2Client) {
        this.waRestClient = waRestClient;
        this.saml2Client = saml2Client;
    }

    protected String getMetadataIdentifier() {
        return this.saml2Client.getName();
    }

    protected byte[] fetchMetadata() throws ResolverException {
        try {
            String encodedMetadata = (String)((WASAML2SPService)this.waRestClient.getService(WASAML2SPService.class)).getSAML2SPMetadata(this.saml2Client.getName()).readEntity(String.class);
            LOG.debug("Retrieved metadata {}", (Object)encodedMetadata);
            return Base64.getDecoder().decode(encodedMetadata);
        }
        catch (Exception e) {
            String message = "Unable to fetch SP metadata for SP entity " + this.saml2Client.getName();
            LOG.error(message, (Throwable)e);
            throw new ResolverException(message);
        }
    }
}

