/**
 * @add jQuery.Drag.prototype
 */

steal('jquery', 'jquery/event/drag/core', 'jquery/dom/styles', function( $ ) {


	$.Drag.prototype
	/**
	 * @function limit
	 * @plugin jquery/event/drag/limit
	 * @download  http://jmvcsite.heroku.com/pluginify?plugins[]=jquery/event/event/drag/limit/limit.js
	 * `drag.limit(container, [center])` limits a drag to a containing element.
	 * 
	 *     $("#todos").on(".todo","draginit", function( ev, drag ) {
	 *       drag.limit($("#todos").parent())
	 *     })
	 * 
	 * @param {jQuery} container the jQuery-wrapped container element you do not want the drag element to escape.
	 * @param {String} [center] can set the limit to the center of the object.  Can be 
	 *   'x', 'y' or 'both'.  By default it will keep the outer edges of the moving element within the
	 * container element.  If you provide x, it will keep the horizontal center of the moving element
	 * within the container element.  If you provide y, it will keep the vertical center of the moving
	 * element within the container element.  If you provide both, it will keep the center of the 
	 * moving element within the containing element.
	 * @return {drag} returns the drag for chaining.
	 */
	.limit = function( container, center ) {
		//on draws ... make sure this happens
		var styles = container.styles('borderTopWidth', 'paddingTop', 'borderLeftWidth', 'paddingLeft'),
			paddingBorder = new $.Vector(
			parseInt(styles.borderLeftWidth, 10) + parseInt(styles.paddingLeft, 10) || 0, parseInt(styles.borderTopWidth, 10) + parseInt(styles.paddingTop, 10) || 0);

		this._limit = {
			offset: container.offsetv().plus(paddingBorder),
			size: container.dimensionsv(),
			center : center === true ? 'both' : center
		};
		return this;
	};

	var oldPosition = $.Drag.prototype.position;
	$.Drag.prototype.position = function( offsetPositionv ) {
		//adjust required_css_position accordingly
		if ( this._limit ) {
			var limit = this._limit,
				center = limit.center && limit.center.toLowerCase(),
				movingSize = this.movingElement.dimensionsv('outer'),
				halfHeight = center && center != 'x' ? movingSize.height() / 2 : 0,
				halfWidth = center && center != 'y' ? movingSize.width() / 2 : 0,
				lot = limit.offset.top(),
				lof = limit.offset.left(),
				height = limit.size.height(),
				width = limit.size.width();

			//check if we are out of bounds ...
			//above
			if ( offsetPositionv.top()+halfHeight < lot ) {
				offsetPositionv.top(lot - halfHeight);
			}
			//below
			if ( offsetPositionv.top() + movingSize.height() - halfHeight > lot + height ) {
				offsetPositionv.top(lot + height - movingSize.height() + halfHeight);
			}
			//left
			if ( offsetPositionv.left()+halfWidth < lof ) {
				offsetPositionv.left(lof - halfWidth);
			}
			//right
			if ( offsetPositionv.left() + movingSize.width() -halfWidth > lof + width ) {
				offsetPositionv.left(lof + width - movingSize.left()+halfWidth);
			}
		}

		oldPosition.call(this, offsetPositionv);
	};

	return $;
});