/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.starter;

import java.util.HashMap;
import java.util.Map;
import org.apache.syncope.core.persistence.api.SyncopeCoreLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.scheduling.concurrent.ExecutorConfigurationSupport;

public class TaskExecutorUnloader
implements SyncopeCoreLoader {
    protected static final Logger LOG = LoggerFactory.getLogger(TaskExecutorUnloader.class);
    protected final ListableBeanFactory beanFactory;
    protected final Map<String, ExecutorConfigurationSupport> tptes = new HashMap<String, ExecutorConfigurationSupport>();

    public TaskExecutorUnloader(ListableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public void load() {
        this.tptes.putAll(this.beanFactory.getBeansOfType(ExecutorConfigurationSupport.class));
    }

    public void unload() {
        this.tptes.forEach((name, tpte) -> {
            LOG.info("Shutting down {}...", name);
            try {
                tpte.shutdown();
                LOG.info("Successfully shut down {}", name);
            }
            catch (Exception e) {
                LOG.error("While shutting down {}", name, (Object)e);
            }
        });
    }
}

