/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.smile;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.FormatFeature;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.sym.ByteQuadsCanonicalizer;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.dataformat.smile.SmileConstants;
import com.fasterxml.jackson.dataformat.smile.SmileParserBase;
import com.fasterxml.jackson.dataformat.smile.SmileUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class SmileParser
extends SmileParserBase {
    private static final boolean JDK11_OR_LATER;
    protected ObjectCodec _objectCodec;
    protected InputStream _inputStream;
    protected byte[] _inputBuffer;
    protected boolean _bufferRecyclable;
    protected int _typeAsInt;
    protected boolean _tokenIncomplete = false;

    public SmileParser(IOContext ctxt, int parserFeatures, int smileFeatures, ObjectCodec codec, ByteQuadsCanonicalizer sym, InputStream in, byte[] inputBuffer, int start, int end, boolean bufferRecyclable) {
        super(ctxt, parserFeatures, smileFeatures, sym);
        this._objectCodec = codec;
        this._inputStream = in;
        this._inputBuffer = inputBuffer;
        this._inputPtr = start;
        this._inputEnd = end;
        this._bufferRecyclable = bufferRecyclable;
    }

    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    public void setCodec(ObjectCodec c) {
        this._objectCodec = c;
    }

    protected boolean handleSignature(boolean consumeFirstByte, boolean throwException) throws IOException {
        byte b;
        if (consumeFirstByte) {
            ++this._inputPtr;
        }
        if ((b = this._nextByteGuaranteed()) != 41) {
            if (throwException) {
                this._reportError(String.format("Malformed content: signature not valid, starts with 0x3A but followed by 0x%02X, not 0x29", b & 0xFF));
            }
            return false;
        }
        b = this._nextByteGuaranteed();
        if (b != 10) {
            if (throwException) {
                this._reportError(String.format("Malformed content: signature not valid, starts with 0x3A, 0x29, but followed by 0x%02X, not 0xA", b & 0xFF));
            }
            return false;
        }
        byte ch = this._nextByteGuaranteed();
        int versionBits = ch >> 4 & 0xF;
        if (versionBits != 0) {
            this._reportError(String.format("Header version number bits (0x%X) indicate unrecognized version; only 0x0 accepted by parser", versionBits));
        }
        if ((ch & 1) == 0) {
            this._seenNames = null;
            this._seenNameCount = -1;
        }
        if ((ch & 2) != 0) {
            this._seenStringValues = NO_STRINGS;
            this._seenStringValueCount = 0;
        }
        this._mayContainRawBinary = (ch & 4) != 0;
        return true;
    }

    public int releaseBuffered(OutputStream out) throws IOException {
        int count = this._inputEnd - this._inputPtr;
        if (count < 1) {
            return 0;
        }
        int origPtr = this._inputPtr;
        out.write(this._inputBuffer, origPtr, count);
        return count;
    }

    public Object getInputSource() {
        return this._inputStream;
    }

    private final byte _nextByteGuaranteed() throws IOException {
        int ptr = this._inputPtr;
        if (ptr < this._inputEnd) {
            byte b = this._inputBuffer[ptr];
            this._inputPtr = ptr + 1;
            return b;
        }
        this._loadMoreGuaranteed();
        return this._inputBuffer[this._inputPtr++];
    }

    protected final void _loadMoreGuaranteed() throws IOException {
        if (!this._loadMore()) {
            this._reportInvalidEOF();
        }
    }

    protected final boolean _loadMore() throws IOException {
        if (this._inputStream != null) {
            int count = this._inputStream.read(this._inputBuffer, 0, this._inputBuffer.length);
            this._currInputProcessed += (long)this._inputEnd;
            this._streamReadConstraints.validateDocumentLength(this._currInputProcessed);
            this._inputPtr = 0;
            if (count > 0) {
                this._inputEnd = count;
                return true;
            }
            this._inputEnd = 0;
            this._closeInput();
            if (count == 0) {
                throw new IOException("InputStream.read() returned 0 characters when trying to read " + this._inputBuffer.length + " bytes");
            }
        }
        return false;
    }

    protected final void _loadToHaveAtLeast(int minAvailable) throws IOException {
        if (this._inputStream == null) {
            throw this._constructError(String.format("Needed to read %d bytes, reached end-of-input", minAvailable));
        }
        int missing = this._tryToLoadToHaveAtLeast(minAvailable);
        if (missing > 0) {
            throw this._constructError(String.format("Needed to read %d bytes, only got %d before end-of-input", minAvailable, minAvailable - missing));
        }
    }

    protected final int _tryToLoadToHaveAtLeast(int minAvailable) throws IOException {
        if (this._inputStream == null) {
            return minAvailable;
        }
        int amount = this._inputEnd - this._inputPtr;
        this._currInputProcessed += (long)this._inputPtr;
        this._streamReadConstraints.validateDocumentLength(this._currInputProcessed);
        if (amount > 0 && this._inputPtr > 0) {
            System.arraycopy(this._inputBuffer, this._inputPtr, this._inputBuffer, 0, amount);
            this._inputEnd = amount;
        } else {
            this._inputEnd = 0;
        }
        this._inputPtr = 0;
        while (this._inputEnd < minAvailable) {
            int toRead = this._inputBuffer.length - this._inputEnd;
            int count = this._inputStream.read(this._inputBuffer, this._inputEnd, toRead);
            if (count < 1) {
                this._closeInput();
                if (count == 0) {
                    throw new IOException("InputStream.read() returned 0 characters when trying to read " + amount + " bytes");
                }
                return minAvailable - this._inputEnd;
            }
            this._inputEnd += count;
        }
        return 0;
    }

    @Override
    protected void _closeInput() throws IOException {
        if (this._inputStream != null) {
            if (this._ioContext.isResourceManaged() || this.isEnabled(JsonParser.Feature.AUTO_CLOSE_SOURCE)) {
                this._inputStream.close();
            }
            this._inputStream = null;
        }
    }

    public boolean hasTextCharacters() {
        if (this._currToken == JsonToken.VALUE_STRING) {
            return this._textBuffer.hasTextAsCharacters();
        }
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this._nameCopied;
        }
        return false;
    }

    @Override
    protected void _releaseBuffers2() {
        byte[] buf;
        if (this._bufferRecyclable && (buf = this._inputBuffer) != null) {
            this._inputBuffer = null;
            this._ioContext.releaseReadIOBuffer(buf);
        }
    }

    public JsonToken nextToken() throws IOException {
        int ch;
        this._numTypesValid = 0;
        if (this._tokenIncomplete) {
            this._skipIncomplete();
        }
        this._tokenOffsetForTotal = this._inputPtr;
        this._binaryValue = null;
        if (this._currToken != JsonToken.FIELD_NAME && this._streamReadContext.inObject()) {
            return this._updateToken(this._handleFieldName());
        }
        if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
            return this._eofAsNextToken();
        }
        this._typeAsInt = ch = this._inputBuffer[this._inputPtr++] & 0xFF;
        switch (ch >> 5) {
            case 0: {
                if (ch == 0) break;
                return this._handleSharedString(ch - 1);
            }
            case 1: {
                int typeBits = ch & 0x1F;
                if (typeBits < 4) {
                    switch (typeBits) {
                        case 0: {
                            this._textBuffer.resetWithEmpty();
                            return this._updateToken(JsonToken.VALUE_STRING);
                        }
                        case 1: {
                            return this._updateToken(JsonToken.VALUE_NULL);
                        }
                        case 2: {
                            return this._updateToken(JsonToken.VALUE_FALSE);
                        }
                    }
                    return this._updateToken(JsonToken.VALUE_TRUE);
                }
                if (typeBits == 4) {
                    this._finishInt();
                    return this._updateToken(JsonToken.VALUE_NUMBER_INT);
                }
                if (typeBits <= 6) {
                    this._tokenIncomplete = true;
                    return this._updateToken(JsonToken.VALUE_NUMBER_INT);
                }
                if (typeBits < 11 && typeBits != 7) {
                    this._tokenIncomplete = true;
                    return this._updateToken(JsonToken.VALUE_NUMBER_FLOAT);
                }
                if (typeBits != 26) break;
                if (this.handleSignature(false, false)) {
                    if (this._currToken == null) {
                        return this._nextAfterHeader();
                    }
                    return this._updateTokenToNull();
                }
                this._reportError("Unrecognized token byte 0x3A (malformed segment header?");
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                if (this._seenStringValueCount >= 0) {
                    return this._addSeenStringValue();
                }
                this._tokenIncomplete = true;
                return this._updateToken(JsonToken.VALUE_STRING);
            }
            case 6: {
                this._numberInt = SmileUtil.zigzagDecode(ch & 0x1F);
                this._numTypesValid = 1;
                this._numberType = JsonParser.NumberType.INT;
                return this._updateToken(JsonToken.VALUE_NUMBER_INT);
            }
            case 7: {
                switch (ch & 0x1F) {
                    case 0: 
                    case 4: {
                        this._tokenIncomplete = true;
                        return this._updateToken(JsonToken.VALUE_STRING);
                    }
                    case 8: {
                        this._tokenIncomplete = true;
                        return this._updateToken(JsonToken.VALUE_EMBEDDED_OBJECT);
                    }
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        if (this._inputPtr >= this._inputEnd) {
                            this._loadMoreGuaranteed();
                        }
                        return this._handleSharedString(((ch & 3) << 8) + (this._inputBuffer[this._inputPtr++] & 0xFF));
                    }
                    case 24: {
                        this.createChildArrayContext(-1, -1);
                        return this._updateToken(JsonToken.START_ARRAY);
                    }
                    case 25: {
                        if (!this._streamReadContext.inArray()) {
                            this._reportMismatchedEndMarker(93, '}');
                        }
                        this._streamReadContext = this._streamReadContext.getParent();
                        return this._updateToken(JsonToken.END_ARRAY);
                    }
                    case 26: {
                        this.createChildObjectContext(-1, -1);
                        return this._updateToken(JsonToken.START_OBJECT);
                    }
                    case 27: {
                        this._reportError("Invalid type marker byte 0xFB in value mode (would be END_OBJECT in key mode)");
                    }
                    case 29: {
                        this._tokenIncomplete = true;
                        return this._updateToken(JsonToken.VALUE_EMBEDDED_OBJECT);
                    }
                    case 31: {
                        return this._updateTokenToNull();
                    }
                }
            }
        }
        return this._reportUnknownValueTypeToken(ch);
    }

    private JsonToken _reportUnknownValueTypeToken(int ch) throws IOException {
        throw this._constructReadException("Invalid type marker byte 0x%s for expected value token", Integer.toHexString(ch & 0xFF));
    }

    private JsonToken _nextAfterHeader() throws IOException {
        if ((this._inputPtr < this._inputEnd || this._loadMore()) && this._inputBuffer[this._inputPtr] == 58) {
            return this._updateTokenToNull();
        }
        return this.nextToken();
    }

    private final JsonToken _handleSharedString(int index) throws IOException {
        if (index >= this._seenStringValueCount) {
            this._reportInvalidSharedStringValue(index);
        }
        this._textBuffer.resetWithString(this._seenStringValues[index]);
        return this._updateToken(JsonToken.VALUE_STRING);
    }

    private final JsonToken _addSeenStringValue() throws IOException {
        this._finishToken();
        String v = this._textBuffer.contentsAsString();
        if (this._seenStringValueCount < this._seenStringValues.length) {
            this._seenStringValues[this._seenStringValueCount++] = v;
        } else {
            this._expandSeenStringValues(v);
        }
        return this._updateToken(JsonToken.VALUE_STRING);
    }

    private final void _expandSeenStringValues(String newText) {
        String[] newShared;
        String[] oldShared = this._seenStringValues;
        int len = oldShared.length;
        if (len == 0) {
            newShared = new String[64];
        } else if (len == 1024) {
            newShared = oldShared;
            this._seenStringValueCount = 0;
        } else {
            int newSize = len == 64 ? 256 : 1024;
            newShared = Arrays.copyOf(oldShared, newSize);
        }
        this._seenStringValues = newShared;
        this._seenStringValues[this._seenStringValueCount++] = newText;
    }

    public void finishToken() throws IOException {
        if (this._tokenIncomplete) {
            this._finishToken();
        }
    }

    public boolean nextFieldName(SerializableString str) throws IOException {
        if (this._currToken != JsonToken.FIELD_NAME && this._streamReadContext.inObject()) {
            this._numTypesValid = 0;
            if (this._tokenIncomplete) {
                this._skipIncomplete();
            }
            this._tokenOffsetForTotal = this._inputPtr;
            this._binaryValue = null;
            byte[] nameBytes = str.asQuotedUTF8();
            int byteLen = nameBytes.length;
            if (this._inputPtr + byteLen + 1 < this._inputEnd) {
                int ch;
                int ptr = this._inputPtr;
                this._typeAsInt = ch = this._inputBuffer[ptr++] & 0xFF;
                block0 : switch (ch >> 6) {
                    case 0: {
                        switch (ch) {
                            case 32: {
                                this._updateToken(JsonToken.FIELD_NAME);
                                this._inputPtr = ptr;
                                this._streamReadContext.setCurrentName("");
                                return byteLen == 0;
                            }
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: {
                                int index = ((ch & 3) << 8) + (this._inputBuffer[ptr++] & 0xFF);
                                if (index >= this._seenNameCount) {
                                    this._reportInvalidSharedName(index);
                                }
                                String name = this._seenNames[index];
                                this._streamReadContext.setCurrentName(name);
                                this._inputPtr = ptr;
                                this._updateToken(JsonToken.FIELD_NAME);
                                return name.equals(str.getValue());
                            }
                        }
                        break;
                    }
                    case 1: {
                        int index = ch & 0x3F;
                        if (index >= this._seenNameCount) {
                            this._reportInvalidSharedName(index);
                        }
                        String name = this._seenNames[index];
                        this._streamReadContext.setCurrentName(name);
                        this._inputPtr = ptr;
                        this._updateToken(JsonToken.FIELD_NAME);
                        return name.equals(str.getValue());
                    }
                    case 2: {
                        int len = 1 + (ch & 0x3F);
                        if (len != byteLen) break;
                        for (int i = 0; i < len; ++i) {
                            if (nameBytes[i] != this._inputBuffer[ptr + i]) break block0;
                        }
                        this._inputPtr = ptr + len;
                        String name = str.getValue();
                        if (this._seenNames != null) {
                            if (this._seenNameCount >= this._seenNames.length) {
                                this._seenNames = this._expandSeenNames(this._seenNames);
                            }
                            this._seenNames[this._seenNameCount++] = name;
                        }
                        this._streamReadContext.setCurrentName(name);
                        this._updateToken(JsonToken.FIELD_NAME);
                        return true;
                    }
                    case 3: {
                        int len = ch & 0x3F;
                        if (len > 55) {
                            if (len != 59) break;
                            this._updateToken(JsonToken.END_OBJECT);
                            this._inputPtr = ptr;
                            this._streamReadContext = this._streamReadContext.getParent();
                            return false;
                        }
                        if ((len += 2) != byteLen) break;
                        for (int i = 0; i < len; ++i) {
                            if (nameBytes[i] != this._inputBuffer[ptr + i]) break block0;
                        }
                        this._inputPtr = ptr + len;
                        String name = str.getValue();
                        if (this._seenNames != null) {
                            if (this._seenNameCount >= this._seenNames.length) {
                                this._seenNames = this._expandSeenNames(this._seenNames);
                            }
                            this._seenNames[this._seenNameCount++] = name;
                        }
                        this._streamReadContext.setCurrentName(name);
                        this._updateToken(JsonToken.FIELD_NAME);
                        return true;
                    }
                }
            }
        }
        return this.nextToken() == JsonToken.FIELD_NAME && str.getValue().equals(this.currentName());
    }

    public String nextFieldName() throws IOException {
        if (this._currToken != JsonToken.FIELD_NAME && this._streamReadContext.inObject()) {
            int ch;
            this._numTypesValid = 0;
            if (this._tokenIncomplete) {
                this._skipIncomplete();
            }
            this._tokenOffsetForTotal = this._inputPtr;
            this._binaryValue = null;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            this._typeAsInt = ch = this._inputBuffer[this._inputPtr++] & 0xFF;
            switch (ch >> 6) {
                case 0: {
                    switch (ch) {
                        case 32: {
                            this._streamReadContext.setCurrentName("");
                            this._updateToken(JsonToken.FIELD_NAME);
                            return "";
                        }
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: {
                            int index;
                            if (this._inputPtr >= this._inputEnd) {
                                this._loadMoreGuaranteed();
                            }
                            if ((index = ((ch & 3) << 8) + (this._inputBuffer[this._inputPtr++] & 0xFF)) >= this._seenNameCount) {
                                this._reportInvalidSharedName(index);
                            }
                            String name = this._seenNames[index];
                            this._streamReadContext.setCurrentName(name);
                            this._updateToken(JsonToken.FIELD_NAME);
                            return name;
                        }
                        case 52: {
                            this._updateToken(JsonToken.FIELD_NAME);
                            return this._handleLongFieldName();
                        }
                    }
                    break;
                }
                case 1: {
                    int index = ch & 0x3F;
                    if (index >= this._seenNameCount) {
                        this._reportInvalidSharedName(index);
                    }
                    String name = this._seenNames[index];
                    this._streamReadContext.setCurrentName(name);
                    this._updateToken(JsonToken.FIELD_NAME);
                    return name;
                }
                case 2: {
                    int len = 1 + (ch & 0x3F);
                    String name = this._findOrDecodeShortAsciiName(len);
                    if (this._seenNames != null) {
                        if (this._seenNameCount >= this._seenNames.length) {
                            this._seenNames = this._expandSeenNames(this._seenNames);
                        }
                        this._seenNames[this._seenNameCount++] = name;
                    }
                    this._streamReadContext.setCurrentName(name);
                    this._updateToken(JsonToken.FIELD_NAME);
                    return name;
                }
                case 3: {
                    if ((ch &= 0x3F) > 55) {
                        if (ch != 59) break;
                        this._streamReadContext = this._streamReadContext.getParent();
                        this._updateToken(JsonToken.END_OBJECT);
                        return null;
                    }
                    int len = ch + 2;
                    String name = this._findOrDecodeShortUnicodeName(len);
                    if (this._seenNames != null) {
                        if (this._seenNameCount >= this._seenNames.length) {
                            this._seenNames = this._expandSeenNames(this._seenNames);
                        }
                        this._seenNames[this._seenNameCount++] = name;
                    }
                    this._streamReadContext.setCurrentName(name);
                    this._updateToken(JsonToken.FIELD_NAME);
                    return name;
                }
            }
            return this._reportUnknownNameToken(this._typeAsInt);
        }
        return this.nextToken() == JsonToken.FIELD_NAME ? this.currentName() : null;
    }

    private String _reportUnknownNameToken(int ch) throws IOException {
        throw this._constructReadException("Invalid type marker byte 0x%s for expected field name (or END_OBJECT marker)", Integer.toHexString(ch & 0xFF));
    }

    public String nextTextValue() throws IOException {
        if (!this._streamReadContext.inObject() || this._currToken == JsonToken.FIELD_NAME) {
            int ch;
            int ptr;
            if (this._tokenIncomplete) {
                this._skipIncomplete();
            }
            if ((ptr = this._inputPtr) >= this._inputEnd) {
                if (!this._loadMore()) {
                    this._eofAsNextToken();
                    return null;
                }
                ptr = this._inputPtr;
            }
            this._tokenOffsetForTotal = ptr;
            this._typeAsInt = ch = this._inputBuffer[ptr++] & 0xFF;
            this._binaryValue = null;
            switch (ch >> 5) {
                case 0: {
                    if (ch != 0) {
                        if (--ch >= this._seenStringValueCount) {
                            this._reportInvalidSharedStringValue(ch);
                        }
                        this._inputPtr = ptr;
                        String text = this._seenStringValues[ch];
                        this._textBuffer.resetWithString(text);
                        this._updateToken(JsonToken.VALUE_STRING);
                        return text;
                    }
                    this._reportError("Invalid token byte 0x00");
                }
                case 1: {
                    int typeBits = ch & 0x1F;
                    if (typeBits != 0) break;
                    this._inputPtr = ptr;
                    this._textBuffer.resetWithEmpty();
                    this._updateToken(JsonToken.VALUE_STRING);
                    return "";
                }
                case 2: 
                case 3: {
                    this._updateToken(JsonToken.VALUE_STRING);
                    this._inputPtr = ptr;
                    String text = this._decodeShortAsciiValue(1 + (ch & 0x3F));
                    if (this._seenStringValueCount >= 0) {
                        if (this._seenStringValueCount < this._seenStringValues.length) {
                            this._seenStringValues[this._seenStringValueCount++] = text;
                        } else {
                            this._expandSeenStringValues(text);
                        }
                    }
                    return text;
                }
                case 4: 
                case 5: {
                    this._updateToken(JsonToken.VALUE_STRING);
                    this._inputPtr = ptr;
                    String text = this._decodeShortUnicodeValue(2 + (ch & 0x3F));
                    if (this._seenStringValueCount >= 0) {
                        if (this._seenStringValueCount < this._seenStringValues.length) {
                            this._seenStringValues[this._seenStringValueCount++] = text;
                        } else {
                            this._expandSeenStringValues(text);
                        }
                    }
                    return text;
                }
                case 6: {
                    break;
                }
            }
        }
        return this.nextToken() == JsonToken.VALUE_STRING ? this.getText() : null;
    }

    public int nextIntValue(int defaultValue) throws IOException {
        if (this.nextToken() == JsonToken.VALUE_NUMBER_INT) {
            return this.getIntValue();
        }
        return defaultValue;
    }

    public long nextLongValue(long defaultValue) throws IOException {
        if (this.nextToken() == JsonToken.VALUE_NUMBER_INT) {
            return this.getLongValue();
        }
        return defaultValue;
    }

    public Boolean nextBooleanValue() throws IOException {
        JsonToken t = this.nextToken();
        if (t == JsonToken.VALUE_TRUE) {
            return Boolean.TRUE;
        }
        if (t == JsonToken.VALUE_FALSE) {
            return Boolean.FALSE;
        }
        return null;
    }

    public String getText() throws IOException {
        if (this._tokenIncomplete) {
            this._tokenIncomplete = false;
            int tb = this._typeAsInt;
            int type = tb >> 5;
            if (type == 2 || type == 3) {
                return this._decodeShortAsciiValue(1 + (tb & 0x3F));
            }
            if (type == 4 || type == 5) {
                return this._decodeShortUnicodeValue(2 + (tb & 0x3F));
            }
            this._finishToken();
        }
        if (this._currToken == JsonToken.VALUE_STRING) {
            return this._textBuffer.contentsAsString();
        }
        JsonToken t = this._currToken;
        if (t == null) {
            return null;
        }
        if (t == JsonToken.FIELD_NAME) {
            return this._streamReadContext.getCurrentName();
        }
        if (t.isNumeric()) {
            return this.getNumberValue().toString();
        }
        return this._currToken.asString();
    }

    public char[] getTextCharacters() throws IOException {
        if (this._currToken != null) {
            if (this._tokenIncomplete) {
                this._finishToken();
            }
            if (this._currToken == JsonToken.VALUE_STRING) {
                return this._textBuffer.getTextBuffer();
            }
            if (this._currToken == JsonToken.FIELD_NAME) {
                if (!this._nameCopied) {
                    String name = this._streamReadContext.getCurrentName();
                    int nameLen = name.length();
                    if (this._nameCopyBuffer == null) {
                        this._nameCopyBuffer = this._ioContext.allocNameCopyBuffer(nameLen);
                    } else if (this._nameCopyBuffer.length < nameLen) {
                        this._nameCopyBuffer = new char[nameLen];
                    }
                    name.getChars(0, nameLen, this._nameCopyBuffer, 0);
                    this._nameCopied = true;
                }
                return this._nameCopyBuffer;
            }
            if (this._currToken.isNumeric()) {
                return this.getNumberValue().toString().toCharArray();
            }
            return this._currToken.asCharArray();
        }
        return null;
    }

    public int getTextLength() throws IOException {
        if (this._currToken != null) {
            if (this._tokenIncomplete) {
                this._finishToken();
            }
            if (this._currToken == JsonToken.VALUE_STRING) {
                return this._textBuffer.size();
            }
            if (this._currToken == JsonToken.FIELD_NAME) {
                return this._streamReadContext.getCurrentName().length();
            }
            if (this._currToken == JsonToken.VALUE_NUMBER_INT || this._currToken == JsonToken.VALUE_NUMBER_FLOAT) {
                return this.getNumberValue().toString().length();
            }
            char[] ch = this._currToken.asCharArray();
            if (ch != null) {
                return ch.length;
            }
        }
        return 0;
    }

    public int getTextOffset() throws IOException {
        return 0;
    }

    public String getValueAsString() throws IOException {
        if (this._tokenIncomplete) {
            this._tokenIncomplete = false;
            int tb = this._typeAsInt;
            int type = tb >> 5;
            if (type == 2 || type == 3) {
                return this._decodeShortAsciiValue(1 + (tb & 0x3F));
            }
            if (type == 4 || type == 5) {
                return this._decodeShortUnicodeValue(2 + (tb & 0x3F));
            }
            this._finishToken();
        }
        if (this._currToken == JsonToken.VALUE_STRING) {
            return this._textBuffer.contentsAsString();
        }
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this.currentName();
        }
        if (this._currToken == null || this._currToken == JsonToken.VALUE_NULL || !this._currToken.isScalarValue()) {
            return null;
        }
        return this.getText();
    }

    public String getValueAsString(String defaultValue) throws IOException {
        if (this._currToken != JsonToken.VALUE_STRING) {
            if (this._currToken == JsonToken.FIELD_NAME) {
                return this.currentName();
            }
            if (this._currToken == null || this._currToken == JsonToken.VALUE_NULL || !this._currToken.isScalarValue()) {
                return defaultValue;
            }
        }
        return this.getText();
    }

    public int getText(Writer writer) throws IOException {
        JsonToken t;
        if (this._tokenIncomplete) {
            this._finishToken();
        }
        if ((t = this._currToken) == JsonToken.VALUE_STRING) {
            return this._textBuffer.contentsToWriter(writer);
        }
        if (t == JsonToken.FIELD_NAME) {
            String n = this._streamReadContext.getCurrentName();
            writer.write(n);
            return n.length();
        }
        if (t != null) {
            if (t.isNumeric()) {
                return this._textBuffer.contentsToWriter(writer);
            }
            char[] ch = t.asCharArray();
            writer.write(ch);
            return ch.length;
        }
        return 0;
    }

    public byte[] getBinaryValue(Base64Variant b64variant) throws IOException {
        if (this._currToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
            if (this._tokenIncomplete) {
                this._finishToken();
            }
        } else {
            if (this._currToken == JsonToken.VALUE_STRING) {
                return this._getBinaryFromString(b64variant);
            }
            throw this._constructReadException("Current token (%s) not VALUE_EMBEDDED_OBJECT or VALUE_STRING, can not access as binary", this.currentToken());
        }
        return this._binaryValue;
    }

    public Object getEmbeddedObject() throws IOException {
        if (this._tokenIncomplete) {
            this._finishToken();
        }
        if (this._currToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
            return this._binaryValue;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readBinaryValue(Base64Variant b64variant, OutputStream out) throws IOException {
        if (this._currToken != JsonToken.VALUE_EMBEDDED_OBJECT) {
            if (this._currToken == JsonToken.VALUE_STRING) {
                byte[] b = this._getBinaryFromString(b64variant);
                int len = b.length;
                out.write(b, 0, len);
                return len;
            }
            throw this._constructReadException("Current token (%s) not VALUE_EMBEDDED_OBJECT or VALUE_STRING, can not access as binary", this.currentToken());
        }
        if (!this._tokenIncomplete) {
            if (this._binaryValue == null) {
                return 0;
            }
            int len = this._binaryValue.length;
            out.write(this._binaryValue, 0, len);
            return len;
        }
        if (this._typeAsInt == 253) {
            int totalCount;
            int count;
            for (int left = totalCount = this._readUnsignedVInt(); left > 0; left -= count) {
                int avail = this._inputEnd - this._inputPtr;
                if (this._inputPtr >= this._inputEnd) {
                    this._loadMoreGuaranteed();
                    avail = this._inputEnd - this._inputPtr;
                }
                count = Math.min(avail, left);
                out.write(this._inputBuffer, this._inputPtr, count);
                this._inputPtr += count;
            }
            this._tokenIncomplete = false;
            return totalCount;
        }
        if (this._typeAsInt != 232) {
            this._throwInternal();
        }
        int totalCount = this._readUnsignedVInt();
        byte[] encodingBuffer = this._ioContext.allocBase64Buffer();
        try {
            this._readBinaryEncoded(out, totalCount, encodingBuffer);
        }
        finally {
            this._ioContext.releaseBase64Buffer(encodingBuffer);
        }
        this._tokenIncomplete = false;
        return totalCount;
    }

    private void _readBinaryEncoded(OutputStream out, int length, byte[] buffer) throws IOException {
        int outPtr = 0;
        int lastSafeOut = buffer.length - 7;
        while (length > 7) {
            if (this._inputEnd - this._inputPtr < 8) {
                this._loadToHaveAtLeast(8);
            }
            int i1 = (this._inputBuffer[this._inputPtr++] << 25) + (this._inputBuffer[this._inputPtr++] << 18) + (this._inputBuffer[this._inputPtr++] << 11) + (this._inputBuffer[this._inputPtr++] << 4);
            byte x = this._inputBuffer[this._inputPtr++];
            int i2 = ((x & 7) << 21) + (this._inputBuffer[this._inputPtr++] << 14) + (this._inputBuffer[this._inputPtr++] << 7) + this._inputBuffer[this._inputPtr++];
            buffer[outPtr++] = (byte)((i1 += x >> 3) >> 24);
            buffer[outPtr++] = (byte)(i1 >> 16);
            buffer[outPtr++] = (byte)(i1 >> 8);
            buffer[outPtr++] = (byte)i1;
            buffer[outPtr++] = (byte)(i2 >> 16);
            buffer[outPtr++] = (byte)(i2 >> 8);
            buffer[outPtr++] = (byte)i2;
            length -= 7;
            if (outPtr <= lastSafeOut) continue;
            out.write(buffer, 0, outPtr);
            outPtr = 0;
        }
        if (length > 0) {
            if (this._inputEnd - this._inputPtr < length + 1) {
                this._loadToHaveAtLeast(length + 1);
            }
            int value = this._inputBuffer[this._inputPtr++];
            for (int i = 1; i < length; ++i) {
                value = (value << 7) + this._inputBuffer[this._inputPtr++];
                buffer[outPtr++] = (byte)(value >> 7 - i);
            }
            buffer[outPtr++] = (byte)((value <<= length) + this._inputBuffer[this._inputPtr++]);
        }
        if (outPtr > 0) {
            out.write(buffer, 0, outPtr);
        }
    }

    private final byte[] _getBinaryFromString(Base64Variant variant) throws IOException {
        if (this._tokenIncomplete) {
            this._finishToken();
        }
        if (this._binaryValue == null) {
            ByteArrayBuilder builder = new ByteArrayBuilder();
            this._decodeBase64(this.getText(), builder, variant);
            this._binaryValue = builder.toByteArray();
        }
        return this._binaryValue;
    }

    protected final JsonToken _handleFieldName() throws IOException {
        int ch;
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        this._typeAsInt = ch = this._inputBuffer[this._inputPtr++] & 0xFF;
        switch (ch >> 6) {
            case 0: {
                switch (ch) {
                    case 32: {
                        this._streamReadContext.setCurrentName("");
                        return JsonToken.FIELD_NAME;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: {
                        int index;
                        if (this._inputPtr >= this._inputEnd) {
                            this._loadMoreGuaranteed();
                        }
                        if ((index = ((ch & 3) << 8) + (this._inputBuffer[this._inputPtr++] & 0xFF)) >= this._seenNameCount) {
                            this._reportInvalidSharedName(index);
                        }
                        this._streamReadContext.setCurrentName(this._seenNames[index]);
                        return JsonToken.FIELD_NAME;
                    }
                    case 52: {
                        this._handleLongFieldName();
                        return JsonToken.FIELD_NAME;
                    }
                }
                break;
            }
            case 1: {
                int index = ch & 0x3F;
                if (index >= this._seenNameCount) {
                    this._reportInvalidSharedName(index);
                }
                this._streamReadContext.setCurrentName(this._seenNames[index]);
                return JsonToken.FIELD_NAME;
            }
            case 2: {
                int len = 1 + (ch & 0x3F);
                String name = this._findOrDecodeShortAsciiName(len);
                if (this._seenNames != null) {
                    if (this._seenNameCount >= this._seenNames.length) {
                        this._seenNames = this._expandSeenNames(this._seenNames);
                    }
                    this._seenNames[this._seenNameCount++] = name;
                }
                this._streamReadContext.setCurrentName(name);
                return JsonToken.FIELD_NAME;
            }
            case 3: {
                if ((ch &= 0x3F) > 55) {
                    if (ch != 59) break;
                    if (!this._streamReadContext.inObject()) {
                        this._reportMismatchedEndMarker(125, ']');
                    }
                    this._streamReadContext = this._streamReadContext.getParent();
                    return JsonToken.END_OBJECT;
                }
                int len = ch + 2;
                String name = this._findOrDecodeShortUnicodeName(len);
                if (this._seenNames != null) {
                    if (this._seenNameCount >= this._seenNames.length) {
                        this._seenNames = this._expandSeenNames(this._seenNames);
                    }
                    this._seenNames[this._seenNameCount++] = name;
                }
                this._streamReadContext.setCurrentName(name);
                return JsonToken.FIELD_NAME;
            }
        }
        throw this._constructReadException("Invalid type marker byte 0x%s for expected field name (or END_OBJECT marker)", Integer.toHexString(this._typeAsInt));
    }

    private String _findOrDecodeShortAsciiName(int len) throws IOException {
        if (this._inputEnd - this._inputPtr < len) {
            this._loadToHaveAtLeast(len);
        }
        if (this._symbolsCanonical) {
            String name = this._findDecodedFromSymbols(len);
            if (name != null) {
                this._inputPtr += len;
            } else {
                name = this._decodeShortAsciiName(len);
                name = this._addDecodedToSymbols(len, name);
            }
            return name;
        }
        return this._decodeShortAsciiName(len);
    }

    private String _findOrDecodeShortUnicodeName(int len) throws IOException {
        if (this._inputEnd - this._inputPtr < len) {
            this._loadToHaveAtLeast(len);
        }
        if (this._symbolsCanonical) {
            String name = this._findDecodedFromSymbols(len);
            if (name != null) {
                this._inputPtr += len;
            } else {
                name = this._decodeShortUnicodeName(len);
                name = this._addDecodedToSymbols(len, name);
            }
            return name;
        }
        return this._decodeShortUnicodeName(len);
    }

    private final String[] _expandSeenNames(String[] oldShared) {
        String[] newShared;
        int len = oldShared.length;
        if (len == 0) {
            newShared = new String[64];
        } else if (len == 1024) {
            newShared = oldShared;
            this._seenNameCount = 0;
        } else {
            int newSize = len == 64 ? 256 : 1024;
            newShared = Arrays.copyOf(oldShared, newSize);
        }
        return newShared;
    }

    private final String _addDecodedToSymbols(int len, String name) throws IOException {
        if (len < 5) {
            return this._symbols.addName(name, this._quad1);
        }
        if (len < 9) {
            return this._symbols.addName(name, this._quad1, this._quad2);
        }
        if (len < 13) {
            return this._symbols.addName(name, this._quad1, this._quad2, this._quad3);
        }
        int qlen = len + 3 >> 2;
        return this._symbols.addName(name, this._quadBuffer, qlen);
    }

    private final String _decodeShortAsciiName(int len) throws IOException {
        int inPtr;
        if (JDK11_OR_LATER) {
            int inPtr2 = this._inputPtr;
            this._inputPtr = inPtr2 + len;
            String str = new String(this._inputBuffer, inPtr2, len, StandardCharsets.US_ASCII);
            this._textBuffer.resetWithString(str);
            return str;
        }
        char[] outBuf = this._textBuffer.emptyAndGetCurrentSegment();
        int outPtr = 0;
        byte[] inBuf = this._inputBuffer;
        int inEnd = inPtr + len;
        for (inPtr = this._inputPtr; inPtr < inEnd; ++inPtr) {
            outBuf[outPtr++] = (char)inBuf[inPtr];
        }
        this._inputPtr = inPtr;
        return this._textBuffer.setCurrentAndReturn(len);
    }

    private final String _decodeShortUnicodeName(int len) throws IOException {
        int outPtr = 0;
        char[] outBuf = this._textBuffer.emptyAndGetCurrentSegment();
        int inPtr = this._inputPtr;
        int[] codes = SmileConstants.sUtf8UnitLengths;
        byte[] inBuf = this._inputBuffer;
        int end = inPtr + len;
        while (inPtr < end) {
            int i;
            int code;
            if ((code = codes[i = inBuf[inPtr++] & 0xFF]) != 0) {
                if (inPtr + code > end) {
                    int firstCharOffset = len - (end - inPtr) - 1;
                    this._reportTruncatedUTF8InName(len, firstCharOffset, i, code);
                }
                switch (code) {
                    case 1: {
                        i = (i & 0x1F) << 6 | inBuf[inPtr++] & 0x3F;
                        break;
                    }
                    case 2: {
                        i = (i & 0xF) << 12 | (inBuf[inPtr++] & 0x3F) << 6 | inBuf[inPtr++] & 0x3F;
                        break;
                    }
                    case 3: {
                        i = (i & 7) << 18 | (inBuf[inPtr++] & 0x3F) << 12 | (inBuf[inPtr++] & 0x3F) << 6 | inBuf[inPtr++] & 0x3F;
                        outBuf[outPtr++] = (char)(0xD800 | (i -= 65536) >> 10);
                        i = 0xDC00 | i & 0x3FF;
                        break;
                    }
                    default: {
                        this._inputPtr = inPtr;
                        throw this._constructReadException("Invalid byte 0x%02X in short Unicode text block", i);
                    }
                }
            }
            outBuf[outPtr++] = (char)i;
        }
        this._inputPtr += len;
        return this._textBuffer.setCurrentAndReturn(outPtr);
    }

    private final String _decodeLongUnicodeName(int[] quads, int byteLen, int quadLen, boolean addToSymbolTable) throws IOException {
        int lastQuad;
        int lastQuadBytes = byteLen & 3;
        if (lastQuadBytes > 0) {
            lastQuad = quads[quadLen - 1];
            quads[quadLen - 1] = lastQuad << (4 - lastQuadBytes << 3);
        } else {
            lastQuad = 0;
        }
        char[] cbuf = this._textBuffer.emptyAndGetCurrentSegment();
        int cix = 0;
        int ix = 0;
        while (ix < byteLen) {
            int ch = quads[ix >> 2];
            int byteIx = ix & 3;
            ch = ch >> (3 - byteIx << 3) & 0xFF;
            ++ix;
            if (ch > 127) {
                int needed;
                if ((ch & 0xE0) == 192) {
                    ch &= 0x1F;
                    needed = 1;
                } else if ((ch & 0xF0) == 224) {
                    ch &= 0xF;
                    needed = 2;
                } else if ((ch & 0xF8) == 240) {
                    ch &= 7;
                    needed = 3;
                } else {
                    this._reportInvalidInitial(ch);
                    ch = 1;
                    needed = 1;
                }
                if (ix + needed > byteLen) {
                    this._reportInvalidEOF(" in long field name", JsonToken.FIELD_NAME);
                }
                int ch2 = quads[ix >> 2];
                byteIx = ix & 3;
                ++ix;
                if (((ch2 >>= 3 - byteIx << 3) & 0xC0) != 128) {
                    this._reportInvalidOther(ch2);
                }
                ch = ch << 6 | ch2 & 0x3F;
                if (needed > 1) {
                    ch2 = quads[ix >> 2];
                    byteIx = ix & 3;
                    ++ix;
                    if (((ch2 >>= 3 - byteIx << 3) & 0xC0) != 128) {
                        this._reportInvalidOther(ch2);
                    }
                    ch = ch << 6 | ch2 & 0x3F;
                    if (needed > 2) {
                        ch2 = quads[ix >> 2];
                        byteIx = ix & 3;
                        ++ix;
                        if (((ch2 >>= 3 - byteIx << 3) & 0xC0) != 128) {
                            this._reportInvalidOther(ch2 & 0xFF);
                        }
                        ch = ch << 6 | ch2 & 0x3F;
                    }
                }
                if (needed > 2) {
                    ch -= 65536;
                    if (cix >= cbuf.length) {
                        cbuf = this._textBuffer.expandCurrentSegment();
                    }
                    cbuf[cix++] = (char)(55296 + (ch >> 10));
                    ch = 0xDC00 | ch & 0x3FF;
                }
            }
            if (cix >= cbuf.length) {
                cbuf = this._textBuffer.expandCurrentSegment();
            }
            cbuf[cix++] = (char)ch;
        }
        String baseName = new String(cbuf, 0, cix);
        if (lastQuadBytes > 0) {
            quads[quadLen - 1] = lastQuad;
        }
        if (addToSymbolTable) {
            return this._symbols.addName(baseName, quads, quadLen);
        }
        return baseName;
    }

    private final String _handleLongFieldName() throws IOException {
        String name;
        byte[] inBuf = this._inputBuffer;
        int quads = 0;
        int bytes = 0;
        int q = 0;
        while (true) {
            byte b;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if (-4 == (b = inBuf[this._inputPtr++])) {
                bytes = 0;
                break;
            }
            q = b & 0xFF;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if (-4 == (b = inBuf[this._inputPtr++])) {
                bytes = 1;
                break;
            }
            q = q << 8 | b & 0xFF;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if (-4 == (b = inBuf[this._inputPtr++])) {
                bytes = 2;
                break;
            }
            q = q << 8 | b & 0xFF;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if (-4 == (b = inBuf[this._inputPtr++])) {
                bytes = 3;
                break;
            }
            q = q << 8 | b & 0xFF;
            if (quads >= this._quadBuffer.length) {
                this._quadBuffer = SmileParser._growArrayTo(this._quadBuffer, this._quadBuffer.length + 256);
            }
            this._quadBuffer[quads++] = q;
        }
        int byteLen = quads << 2;
        if (bytes > 0) {
            if (quads >= this._quadBuffer.length) {
                this._quadBuffer = SmileParser._growArrayTo(this._quadBuffer, this._quadBuffer.length + 256);
            }
            q = SmileParser._padLastQuad(q, bytes);
            this._quadBuffer[quads++] = q;
            byteLen += bytes;
        }
        String string = name = this._symbolsCanonical ? this._symbols.findName(this._quadBuffer, quads) : null;
        if (name == null) {
            name = this._decodeLongUnicodeName(this._quadBuffer, byteLen, quads, this._symbolsCanonical);
        }
        if (this._seenNames != null) {
            if (this._seenNameCount >= this._seenNames.length) {
                this._seenNames = this._expandSeenNames(this._seenNames);
            }
            this._seenNames[this._seenNameCount++] = name;
        }
        this._streamReadContext.setCurrentName(name);
        return name;
    }

    private final String _findDecodedFromSymbols(int len) throws IOException {
        if (len < 5) {
            int inPtr = this._inputPtr;
            byte[] inBuf = this._inputBuffer;
            int q = SmileParser._padQuadForNulls(inBuf[inPtr]);
            if (len > 1) {
                q = (q << 8) + (inBuf[++inPtr] & 0xFF);
                if (len > 2) {
                    q = (q << 8) + (inBuf[++inPtr] & 0xFF);
                    if (len > 3) {
                        q = (q << 8) + (inBuf[++inPtr] & 0xFF);
                    }
                }
            }
            this._quad1 = q;
            return this._symbols.findName(q);
        }
        byte[] inBuf = this._inputBuffer;
        int inPtr = this._inputPtr;
        int q1 = inBuf[inPtr++] & 0xFF;
        q1 = q1 << 8 | inBuf[inPtr++] & 0xFF;
        q1 = q1 << 8 | inBuf[inPtr++] & 0xFF;
        q1 = q1 << 8 | inBuf[inPtr++] & 0xFF;
        if (len < 9) {
            int q2 = SmileParser._padQuadForNulls(inBuf[inPtr++]);
            int left = len - 5;
            if (left > 0) {
                q2 = (q2 << 8) + (inBuf[inPtr++] & 0xFF);
                if (left > 1) {
                    q2 = (q2 << 8) + (inBuf[inPtr++] & 0xFF);
                    if (left > 2) {
                        q2 = (q2 << 8) + (inBuf[inPtr++] & 0xFF);
                    }
                }
            }
            this._quad1 = q1;
            this._quad2 = q2;
            return this._symbols.findName(q1, q2);
        }
        int q2 = inBuf[inPtr++] & 0xFF;
        q2 = q2 << 8 | inBuf[inPtr++] & 0xFF;
        q2 = q2 << 8 | inBuf[inPtr++] & 0xFF;
        q2 = q2 << 8 | inBuf[inPtr++] & 0xFF;
        if (len < 13) {
            int q3 = SmileParser._padQuadForNulls(inBuf[inPtr++]);
            int left = len - 9;
            if (left > 0) {
                q3 = (q3 << 8) + (inBuf[inPtr++] & 0xFF);
                if (left > 1) {
                    q3 = (q3 << 8) + (inBuf[inPtr++] & 0xFF);
                    if (left > 2) {
                        q3 = (q3 << 8) + (inBuf[inPtr++] & 0xFF);
                    }
                }
            }
            this._quad1 = q1;
            this._quad2 = q2;
            this._quad3 = q3;
            return this._symbols.findName(q1, q2, q3);
        }
        return this._findDecodedFixed12(len, q1, q2);
    }

    private final String _findDecodedFixed12(int len, int q1, int q2) throws IOException {
        int q;
        int bufLen = len + 3 >> 2;
        if (bufLen > this._quadBuffer.length) {
            this._quadBuffer = SmileParser._growArrayTo(this._quadBuffer, bufLen);
        }
        this._quadBuffer[0] = q1;
        this._quadBuffer[1] = q2;
        int offset = 2;
        int inPtr = this._inputPtr + 8;
        len -= 8;
        byte[] inBuf = this._inputBuffer;
        do {
            q = inBuf[inPtr++] & 0xFF;
            q = q << 8 | inBuf[inPtr++] & 0xFF;
            q = q << 8 | inBuf[inPtr++] & 0xFF;
            q = q << 8 | inBuf[inPtr++] & 0xFF;
            this._quadBuffer[offset++] = q;
        } while ((len -= 4) > 3);
        if (len > 0) {
            q = SmileParser._padQuadForNulls(inBuf[inPtr]);
            if (len > 1) {
                q = (q << 8) + (inBuf[++inPtr] & 0xFF);
                if (len > 2) {
                    q = (q << 8) + (inBuf[++inPtr] & 0xFF);
                }
            }
            this._quadBuffer[offset++] = q;
        }
        return this._symbols.findName(this._quadBuffer, offset);
    }

    private static int[] _growArrayTo(int[] arr, int minSize) {
        int size = minSize + 4;
        if (arr == null) {
            return new int[size];
        }
        return Arrays.copyOf(arr, size);
    }

    private static final int _padLastQuad(int q, int bytes) {
        return bytes == 4 ? q : q | -1 << (bytes << 3);
    }

    private static final int _padQuadForNulls(int firstByte) {
        return firstByte & 0xFF | 0xFFFFFF00;
    }

    @Override
    protected void _parseNumericValue() throws IOException {
        if (!this._tokenIncomplete) {
            this._reportError("Internal error: number token (%s) decoded, no value set", this._currToken);
        }
        this._tokenIncomplete = false;
        int tb = this._typeAsInt;
        if (tb >> 5 != 1) {
            this._reportError("Current token (%s) not numeric, can not use numeric value accessors", this._currToken);
        }
        this._finishNumberToken(tb);
    }

    protected final void _finishToken() throws IOException {
        this._tokenIncomplete = false;
        int tb = this._typeAsInt;
        int type = tb >> 5;
        if (type == 1) {
            this._finishNumberToken(tb);
            return;
        }
        if (type <= 3) {
            this._decodeShortAsciiValue(1 + (tb & 0x3F));
            return;
        }
        if (type <= 5) {
            this._decodeShortUnicodeValue(2 + (tb & 0x3F));
            return;
        }
        if (type == 7) {
            switch ((tb &= 0x1F) >> 2) {
                case 0: {
                    this._decodeLongAsciiValue();
                    return;
                }
                case 1: {
                    this._decodeLongUnicodeValue();
                    return;
                }
                case 2: {
                    this._binaryValue = this._read7BitBinaryWithLength();
                    return;
                }
                case 7: {
                    this._binaryValue = this._finishBinaryRaw();
                    return;
                }
            }
        }
        this._throwInternal();
    }

    protected final void _finishNumberToken(int tb) throws IOException {
        switch (tb & 0x1F) {
            case 4: {
                this._finishInt();
                return;
            }
            case 5: {
                this._finishLong();
                return;
            }
            case 6: {
                this._finishBigInteger();
                return;
            }
            case 8: {
                this._finishFloat();
                return;
            }
            case 9: {
                this._finishDouble();
                return;
            }
            case 10: {
                this._finishBigDecimal();
                return;
            }
        }
        this._throwInternal();
    }

    private final void _finishInt() throws IOException {
        int value;
        this._numTypesValid = 1;
        this._numberType = JsonParser.NumberType.INT;
        int ptr = this._inputPtr;
        if (ptr + 5 >= this._inputEnd) {
            this._finishIntSlow();
            return;
        }
        if ((value = this._inputBuffer[ptr++]) < 0) {
            value &= 0x3F;
        } else {
            byte i;
            if ((i = this._inputBuffer[ptr++]) >= 0) {
                value = (value << 7) + i;
                if ((i = this._inputBuffer[ptr++]) >= 0) {
                    value = (value << 7) + i;
                    if ((i = this._inputBuffer[ptr++]) >= 0) {
                        value = (value << 7) + i;
                        if ((i = this._inputBuffer[ptr++]) >= 0) {
                            this._reportError("Corrupt input; 32-bit VInt extends beyond 5 data bytes");
                        }
                    }
                }
            }
            value = (value << 6) + (i & 0x3F);
        }
        this._inputPtr = ptr;
        this._numberInt = SmileUtil.zigzagDecode(value);
    }

    private final void _finishIntSlow() throws IOException {
        int value;
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        if ((value = this._inputBuffer[this._inputPtr++]) < 0) {
            value &= 0x3F;
        } else {
            byte i;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((i = this._inputBuffer[this._inputPtr++]) >= 0) {
                value = (value << 7) + i;
                if (this._inputPtr >= this._inputEnd) {
                    this._loadMoreGuaranteed();
                }
                if ((i = this._inputBuffer[this._inputPtr++]) >= 0) {
                    value = (value << 7) + i;
                    if (this._inputPtr >= this._inputEnd) {
                        this._loadMoreGuaranteed();
                    }
                    if ((i = this._inputBuffer[this._inputPtr++]) >= 0) {
                        value = (value << 7) + i;
                        if (this._inputPtr >= this._inputEnd) {
                            this._loadMoreGuaranteed();
                        }
                        if ((i = this._inputBuffer[this._inputPtr++]) >= 0) {
                            this._reportError("Corrupt input; 32-bit VInt extends beyond 5 data bytes");
                        }
                    }
                }
            }
            value = (value << 6) + (i & 0x3F);
        }
        this._numberInt = SmileUtil.zigzagDecode(value);
    }

    private final void _finishLong() throws IOException {
        this._numTypesValid = 2;
        this._numberType = JsonParser.NumberType.LONG;
        int ptr = this._inputPtr;
        int maxEnd = ptr + 11;
        if (maxEnd >= this._inputEnd) {
            this._finishLongSlow();
            return;
        }
        int i = this._inputBuffer[ptr++];
        i = (i << 7) + this._inputBuffer[ptr++];
        i = (i << 7) + this._inputBuffer[ptr++];
        i = (i << 7) + this._inputBuffer[ptr++];
        long l = i;
        do {
            byte value;
            if ((value = this._inputBuffer[ptr++]) < 0) {
                l = (l << 6) + (long)(value & 0x3F);
                this._inputPtr = ptr;
                this._numberLong = SmileUtil.zigzagDecode(l);
                return;
            }
            l = (l << 7) + (long)value;
        } while (ptr < maxEnd);
        this._reportError("Corrupt input; 64-bit VInt extends beyond 11 data bytes");
    }

    private final void _finishLongSlow() throws IOException {
        long l = this._fourBytesToInt();
        while (true) {
            byte value;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((value = this._inputBuffer[this._inputPtr++]) < 0) {
                l = (l << 6) + (long)(value & 0x3F);
                this._numberLong = SmileUtil.zigzagDecode(l);
                return;
            }
            l = (l << 7) + (long)value;
        }
    }

    private final int _fourBytesToInt() throws IOException {
        int ptr = this._inputPtr;
        if (ptr + 3 >= this._inputEnd) {
            return this._fourBytesToIntSlow();
        }
        int i = this._inputBuffer[ptr++];
        i = (i << 7) + this._inputBuffer[ptr++];
        i = (i << 7) + this._inputBuffer[ptr++];
        i = (i << 7) + this._inputBuffer[ptr++];
        this._inputPtr = ptr;
        return i;
    }

    private final int _fourBytesToIntSlow() throws IOException {
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        int i = this._inputBuffer[this._inputPtr++];
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        i = (i << 7) + this._inputBuffer[this._inputPtr++];
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        i = (i << 7) + this._inputBuffer[this._inputPtr++];
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        return (i << 7) + this._inputBuffer[this._inputPtr++];
    }

    private final void _finishBigInteger() throws IOException {
        byte[] raw = this._read7BitBinaryWithLength();
        if (raw.length == 0) {
            this._numberBigInt = BigInteger.ZERO;
        } else {
            this._streamReadConstraints.validateIntegerLength(raw.length);
            this._numberBigInt = new BigInteger(raw);
        }
        this._numTypesValid = 4;
        this._numberType = JsonParser.NumberType.BIG_INTEGER;
    }

    private final void _finishFloat() throws IOException {
        float f;
        int i = this._fourBytesToInt();
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        i = (i << 7) + this._inputBuffer[this._inputPtr++];
        this._numberFloat = f = Float.intBitsToFloat(i);
        this._numberType = JsonParser.NumberType.FLOAT;
        this._numTypesValid = 32;
    }

    private final void _finishDouble() throws IOException {
        long hi = this._fourBytesToInt();
        long value = (hi << 28) + (long)this._fourBytesToInt();
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        value = (value << 7) + (long)this._inputBuffer[this._inputPtr++];
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        value = (value << 7) + (long)this._inputBuffer[this._inputPtr++];
        this._numberDouble = Double.longBitsToDouble(value);
        this._numberType = JsonParser.NumberType.DOUBLE;
        this._numTypesValid = 8;
    }

    private final void _finishBigDecimal() throws IOException {
        int scale = SmileUtil.zigzagDecode(this._readUnsignedVInt());
        byte[] raw = this._read7BitBinaryWithLength();
        if (raw.length == 0) {
            this._numberBigDecimal = BigDecimal.ZERO;
        } else {
            this._streamReadConstraints.validateFPLength(raw.length);
            BigInteger unscaledValue = new BigInteger(raw);
            this._numberBigDecimal = new BigDecimal(unscaledValue, scale);
        }
        this._numTypesValid = 16;
        this._numberType = JsonParser.NumberType.BIG_DECIMAL;
    }

    protected final int _readUnsignedVInt() throws IOException {
        int ch;
        if (this._inputPtr + 5 > this._inputEnd) {
            return this._readUnsignedVIntSlow();
        }
        if ((ch = this._inputBuffer[this._inputPtr++]) < 0) {
            return ch & 0x3F;
        }
        int value = ch;
        if ((ch = this._inputBuffer[this._inputPtr++]) < 0) {
            return (value << 6) + (ch & 0x3F);
        }
        value = (value << 7) + ch;
        if ((ch = this._inputBuffer[this._inputPtr++]) < 0) {
            return (value << 6) + (ch & 0x3F);
        }
        value = (value << 7) + ch;
        if ((ch = this._inputBuffer[this._inputPtr++]) < 0) {
            return (value << 6) + (ch & 0x3F);
        }
        value = (value << 7) + ch;
        if ((ch = this._inputBuffer[this._inputPtr++]) >= 0 || value >>> 25 != 0) {
            this._reportInvalidUnsignedVInt(value >>> 21, ch);
        }
        return (value << 6) + (ch & 0x3F);
    }

    protected final int _readUnsignedVIntSlow() throws IOException {
        byte ch;
        int value = 0;
        int count = 0;
        do {
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((ch = this._inputBuffer[this._inputPtr++]) < 0) {
                value = (value << 6) + (ch & 0x3F);
                return value;
            }
            value = (value << 7) + ch;
        } while (++count < 4);
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        if ((ch = this._inputBuffer[this._inputPtr++]) >= 0 || value >>> 25 != 0) {
            this._reportInvalidUnsignedVInt(value >>> 21, ch);
        }
        return (value << 6) + (ch & 0x3F);
    }

    protected final void _reportInvalidUnsignedVInt(int firstCh, int lastCh) throws IOException {
        if (lastCh >= 0) {
            this._reportError("Overflow in VInt (current token %s): 5th byte (0x%2X) of 5-byte sequence must have its highest bit set to indicate end", this.currentToken(), lastCh);
        }
        this._reportError("Overflow in VInt (current token %s): 1st byte (0x%2X) of 5-byte sequence must have its top 4 bits zeroes", this.currentToken(), firstCh);
    }

    protected final String _decodeShortAsciiValue(int len) throws IOException {
        int inPtr;
        if (this._inputEnd - this._inputPtr < len) {
            this._loadToHaveAtLeast(len);
        }
        if (JDK11_OR_LATER) {
            int inPtr2 = this._inputPtr;
            this._inputPtr = inPtr2 + len;
            String str = new String(this._inputBuffer, inPtr2, len, StandardCharsets.US_ASCII);
            this._textBuffer.resetWithString(str);
            return str;
        }
        char[] outBuf = this._textBuffer.emptyAndGetCurrentSegment();
        int outPtr = 0;
        byte[] inBuf = this._inputBuffer;
        int end = inPtr + len;
        for (inPtr = this._inputPtr; inPtr < end; ++inPtr) {
            outBuf[outPtr++] = (char)inBuf[inPtr];
        }
        this._inputPtr = inPtr;
        return this._textBuffer.setCurrentAndReturn(len);
    }

    protected final String _decodeShortUnicodeValue(int byteLen) throws IOException {
        if (this._inputEnd - this._inputPtr < byteLen) {
            this._loadToHaveAtLeast(byteLen);
        }
        int outPtr = 0;
        char[] outBuf = this._textBuffer.emptyAndGetCurrentSegment();
        int inPtr = this._inputPtr;
        this._inputPtr += byteLen;
        int[] codes = SmileConstants.sUtf8UnitLengths;
        byte[] inputBuf = this._inputBuffer;
        int end = inPtr + byteLen;
        while (inPtr < end) {
            int i;
            if ((i = inputBuf[inPtr++]) >= 0) {
                outBuf[outPtr++] = (char)i;
                continue;
            }
            int unitLen = codes[i &= 0xFF];
            if (inPtr + unitLen > end) {
                int firstCharOffset = byteLen - (end - inPtr) - 1;
                return this._reportTruncatedUTF8InString(byteLen, firstCharOffset, i, unitLen);
            }
            switch (unitLen) {
                case 1: {
                    i = (i & 0x1F) << 6 | inputBuf[inPtr++] & 0x3F;
                    break;
                }
                case 2: {
                    i = (i & 0xF) << 12 | (inputBuf[inPtr++] & 0x3F) << 6 | inputBuf[inPtr++] & 0x3F;
                    break;
                }
                case 3: {
                    i = (i & 7) << 18 | (inputBuf[inPtr++] & 0x3F) << 12 | (inputBuf[inPtr++] & 0x3F) << 6 | inputBuf[inPtr++] & 0x3F;
                    outBuf[outPtr++] = (char)(0xD800 | (i -= 65536) >> 10);
                    i = 0xDC00 | i & 0x3FF;
                    break;
                }
                default: {
                    throw this._constructReadException("Invalid byte 0x%02X in short Unicode text block", i);
                }
            }
            outBuf[outPtr++] = (char)i;
        }
        return this._textBuffer.setCurrentAndReturn(outPtr);
    }

    private final void _decodeLongAsciiValue() throws IOException {
        int inPtr;
        int outPtr = 0;
        char[] outBuf = this._textBuffer.emptyAndGetCurrentSegment();
        block0: while (true) {
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            inPtr = this._inputPtr;
            int left = this._inputEnd - inPtr;
            if (outPtr >= outBuf.length) {
                outBuf = this._textBuffer.finishCurrentSegment();
                outPtr = 0;
            }
            left = Math.min(left, outBuf.length - outPtr);
            do {
                byte b;
                if ((b = this._inputBuffer[inPtr++]) == -4) break block0;
                outBuf[outPtr++] = (char)b;
            } while (--left > 0);
            this._inputPtr = inPtr;
        }
        this._inputPtr = inPtr;
        this._textBuffer.setCurrentLength(outPtr);
    }

    private final void _decodeLongUnicodeValue() throws IOException {
        int outPtr = 0;
        char[] outBuf = this._textBuffer.emptyAndGetCurrentSegment();
        int[] codes = SmileConstants.sUtf8UnitLengths;
        byte[] inputBuffer = this._inputBuffer;
        while (true) {
            int c;
            int ptr;
            block14: {
                int max;
                int max2;
                if ((ptr = this._inputPtr) >= this._inputEnd) {
                    this._loadMoreGuaranteed();
                    ptr = this._inputPtr;
                }
                if (outPtr >= outBuf.length) {
                    outBuf = this._textBuffer.finishCurrentSegment();
                    outPtr = 0;
                }
                if ((max2 = ptr + (outBuf.length - outPtr)) < (max = this._inputEnd)) {
                    max = max2;
                }
                while (ptr < max) {
                    if (codes[c = inputBuffer[ptr++] & 0xFF] == 0) {
                        outBuf[outPtr++] = (char)c;
                        continue;
                    }
                    break block14;
                }
                this._inputPtr = ptr;
                continue;
            }
            this._inputPtr = ptr;
            if (c == 252) break;
            switch (codes[c]) {
                case 1: {
                    c = this._decodeUtf8_2(c);
                    break;
                }
                case 2: {
                    if (this._inputEnd - this._inputPtr >= 2) {
                        c = this._decodeUtf8_3fast(c);
                        break;
                    }
                    c = this._decodeUtf8_3(c);
                    break;
                }
                case 3: {
                    c = this._decodeUtf8_4(c);
                    outBuf[outPtr++] = (char)(0xD800 | c >> 10);
                    if (outPtr >= outBuf.length) {
                        outBuf = this._textBuffer.finishCurrentSegment();
                        outPtr = 0;
                    }
                    c = 0xDC00 | c & 0x3FF;
                    break;
                }
                default: {
                    this._reportInvalidInitial(c);
                }
            }
            if (outPtr >= outBuf.length) {
                outBuf = this._textBuffer.finishCurrentSegment();
                outPtr = 0;
            }
            outBuf[outPtr++] = (char)c;
        }
        this._textBuffer.setCurrentLength(outPtr);
    }

    private final byte[] _finishBinaryRaw() throws IOException {
        int byteLen = this._readUnsignedVInt();
        if (byteLen > 250000) {
            return this._finishBinaryRawLong(byteLen);
        }
        int expLen = byteLen;
        byte[] b = new byte[byteLen];
        int ptr = 0;
        while (byteLen > 0) {
            if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                this._reportIncompleteBinaryReadRaw(expLen, ptr);
            }
            int toAdd = Math.min(byteLen, this._inputEnd - this._inputPtr);
            System.arraycopy(this._inputBuffer, this._inputPtr, b, ptr, toAdd);
            this._inputPtr += toAdd;
            ptr += toAdd;
            byteLen -= toAdd;
        }
        return b;
    }

    protected byte[] _finishBinaryRawLong(int expLen) throws IOException {
        try (ByteArrayBuilder bb = new ByteArrayBuilder(125000);){
            int count;
            for (int left = expLen; left > 0; left -= count) {
                int avail = this._inputEnd - this._inputPtr;
                if (avail <= 0) {
                    if (!this._loadMore()) {
                        this._reportIncompleteBinaryReadRaw(expLen, expLen - left);
                    }
                    avail = this._inputEnd - this._inputPtr;
                }
                count = Math.min(avail, left);
                bb.write(this._inputBuffer, this._inputPtr, count);
                this._inputPtr += count;
            }
            byte[] byArray = bb.toByteArray();
            return byArray;
        }
    }

    private final byte[] _read7BitBinaryWithLength() throws IOException {
        int byteLen = this._readUnsignedVInt();
        if (byteLen > 250000) {
            return this._finishBinary7BitLong(byteLen);
        }
        byte[] result = new byte[byteLen];
        int lastOkPtr = byteLen - 7;
        int ptr = 0;
        while (ptr <= lastOkPtr) {
            int missing;
            if (this._inputEnd - this._inputPtr < 8 && (missing = this._tryToLoadToHaveAtLeast(8)) > 0) {
                this._reportIncompleteBinaryRead7Bit(byteLen, ptr);
            }
            int i1 = (this._inputBuffer[this._inputPtr++] << 25) + (this._inputBuffer[this._inputPtr++] << 18) + (this._inputBuffer[this._inputPtr++] << 11) + (this._inputBuffer[this._inputPtr++] << 4);
            byte x = this._inputBuffer[this._inputPtr++];
            int i2 = ((x & 7) << 21) + (this._inputBuffer[this._inputPtr++] << 14) + (this._inputBuffer[this._inputPtr++] << 7) + this._inputBuffer[this._inputPtr++];
            result[ptr++] = (byte)((i1 += x >> 3) >> 24);
            result[ptr++] = (byte)(i1 >> 16);
            result[ptr++] = (byte)(i1 >> 8);
            result[ptr++] = (byte)i1;
            result[ptr++] = (byte)(i2 >> 16);
            result[ptr++] = (byte)(i2 >> 8);
            result[ptr++] = (byte)i2;
        }
        int toDecode = result.length - ptr;
        if (toDecode > 0) {
            int missing;
            if (this._inputEnd - this._inputPtr < toDecode + 1 && (missing = this._tryToLoadToHaveAtLeast(toDecode + 1)) > 0) {
                this._reportIncompleteBinaryRead7Bit(byteLen, ptr);
            }
            int value = this._inputBuffer[this._inputPtr++];
            for (int i = 1; i < toDecode; ++i) {
                value = (value << 7) + this._inputBuffer[this._inputPtr++];
                result[ptr++] = (byte)(value >> 7 - i);
            }
            result[ptr] = (byte)((value <<= toDecode) + this._inputBuffer[this._inputPtr++]);
        }
        return result;
    }

    protected byte[] _finishBinary7BitLong(int expLen) throws IOException {
        try (ByteArrayBuilder bb = new ByteArrayBuilder(125000);){
            int left;
            byte[] buffer = new byte[896];
            int bufPtr = 0;
            for (left = expLen; left >= 7; left -= 7) {
                int missing;
                if (this._inputEnd - this._inputPtr < 8 && (missing = this._tryToLoadToHaveAtLeast(8)) > 0) {
                    this._reportIncompleteBinaryRead7Bit(expLen, bb.size() + bufPtr);
                }
                int i1 = (this._inputBuffer[this._inputPtr++] << 25) + (this._inputBuffer[this._inputPtr++] << 18) + (this._inputBuffer[this._inputPtr++] << 11) + (this._inputBuffer[this._inputPtr++] << 4);
                byte x = this._inputBuffer[this._inputPtr++];
                int i2 = ((x & 7) << 21) + (this._inputBuffer[this._inputPtr++] << 14) + (this._inputBuffer[this._inputPtr++] << 7) + this._inputBuffer[this._inputPtr++];
                buffer[bufPtr++] = (byte)((i1 += x >> 3) >> 24);
                buffer[bufPtr++] = (byte)(i1 >> 16);
                buffer[bufPtr++] = (byte)(i1 >> 8);
                buffer[bufPtr++] = (byte)i1;
                buffer[bufPtr++] = (byte)(i2 >> 16);
                buffer[bufPtr++] = (byte)(i2 >> 8);
                buffer[bufPtr++] = (byte)i2;
                if (bufPtr < buffer.length) continue;
                bb.write(buffer, 0, bufPtr);
                bufPtr = 0;
            }
            if (left > 0) {
                if (this._inputEnd - this._inputPtr < left + 1) {
                    this._loadToHaveAtLeast(left + 1);
                }
                int value = this._inputBuffer[this._inputPtr++];
                for (int i = 1; i < left; ++i) {
                    value = (value << 7) + this._inputBuffer[this._inputPtr++];
                    buffer[bufPtr++] = (byte)(value >> 7 - i);
                }
                buffer[bufPtr++] = (byte)((value <<= left) + this._inputBuffer[this._inputPtr++]);
            }
            if (bufPtr > 0) {
                bb.write(buffer, 0, bufPtr);
            }
            byte[] byArray = bb.toByteArray();
            return byArray;
        }
    }

    protected void _skipIncomplete() throws IOException {
        this._tokenIncomplete = false;
        int tb = this._typeAsInt;
        switch (tb >> 5) {
            case 1: {
                switch ((tb &= 0x1F) >> 2) {
                    case 1: {
                        switch (tb & 3) {
                            case 1: {
                                this._skipBytes(4);
                            }
                            case 0: {
                                while (true) {
                                    int end = this._inputEnd;
                                    byte[] buf = this._inputBuffer;
                                    while (this._inputPtr < end) {
                                        if (buf[this._inputPtr++] >= 0) continue;
                                        return;
                                    }
                                    this._loadMoreGuaranteed();
                                }
                            }
                            case 2: {
                                this._skip7BitBinary();
                                return;
                            }
                        }
                        break;
                    }
                    case 2: {
                        switch (tb & 3) {
                            case 0: {
                                this._skipBytes(5);
                                return;
                            }
                            case 1: {
                                this._skipBytes(10);
                                return;
                            }
                            case 2: {
                                this._readUnsignedVInt();
                                this._skip7BitBinary();
                                return;
                            }
                        }
                    }
                }
                break;
            }
            case 2: 
            case 3: {
                this._skipBytes(1 + (tb & 0x3F));
                return;
            }
            case 4: 
            case 5: {
                this._skipBytes(2 + (tb & 0x3F));
                return;
            }
            case 7: {
                switch ((tb &= 0x1F) >> 2) {
                    case 0: 
                    case 1: {
                        while (true) {
                            int end = this._inputEnd;
                            byte[] buf = this._inputBuffer;
                            while (this._inputPtr < end) {
                                if (buf[this._inputPtr++] != -4) continue;
                                return;
                            }
                            this._loadMoreGuaranteed();
                        }
                    }
                    case 2: {
                        this._skip7BitBinary();
                        return;
                    }
                    case 7: {
                        this._skipBytes(this._readUnsignedVInt());
                        return;
                    }
                }
            }
        }
        this._throwInternal();
    }

    protected void _skipBytes(int len) throws IOException {
        if (len < 0) {
            throw this._constructReadException("Internal error: _skipBytes() called with negative value: %d", len);
        }
        while (true) {
            int toAdd = Math.min(len, this._inputEnd - this._inputPtr);
            this._inputPtr += toAdd;
            if ((len -= toAdd) <= 0) {
                return;
            }
            this._loadMoreGuaranteed();
        }
    }

    protected void _skip7BitBinary() throws IOException {
        int origBytes = this._readUnsignedVInt();
        int chunks = origBytes / 7;
        int encBytes = chunks * 8;
        if (encBytes < 0) {
            throw this._constructReadException("Invalid content: invalid 7-bit binary encoded byte length (0x%X) exceeds maximum valid value", origBytes);
        }
        if ((origBytes -= 7 * chunks) > 0) {
            encBytes += 1 + origBytes;
        }
        this._skipBytes(encBytes);
    }

    private final int _decodeUtf8_2(int c) throws IOException {
        byte d;
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        return (c & 0x1F) << 6 | d & 0x3F;
    }

    private final int _decodeUtf8_3(int c1) throws IOException {
        byte d;
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        c1 &= 0xF;
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        int c = c1 << 6 | d & 0x3F;
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        c = c << 6 | d & 0x3F;
        return c;
    }

    private final int _decodeUtf8_3fast(int c1) throws IOException {
        byte d;
        c1 &= 0xF;
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        int c = c1 << 6 | d & 0x3F;
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        c = c << 6 | d & 0x3F;
        return c;
    }

    private final int _decodeUtf8_4(int c) throws IOException {
        byte d;
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        c = (c & 7) << 6 | d & 0x3F;
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        c = c << 6 | d & 0x3F;
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        return (c << 6 | d & 0x3F) - 65536;
    }

    protected void _reportInvalidSharedName(int index) throws IOException {
        if (this._seenNames == null) {
            this._reportError("Encountered shared name reference, even though document header explicitly declared no shared name references are included");
        }
        this._reportError("Invalid shared name reference " + index + "; only got " + this._seenNameCount + " names in buffer (invalid content)");
    }

    protected void _reportInvalidSharedStringValue(int index) throws IOException {
        if (this._seenStringValues == null) {
            this._reportError("Encountered shared text value reference, even though document header did not declare shared text value references may be included");
        }
        this._reportError("Invalid shared text value reference " + index + "; only got " + this._seenStringValueCount + " names in buffer (invalid content)");
    }

    protected void _reportInvalidInitial(int mask) throws JsonParseException {
        this._reportError("Invalid UTF-8 start byte 0x" + Integer.toHexString(mask));
    }

    protected void _reportInvalidOther(int mask) throws JsonParseException {
        this._reportError("Invalid UTF-8 middle byte 0x" + Integer.toHexString(mask));
    }

    protected void _reportInvalidOther(int mask, int ptr) throws JsonParseException {
        this._inputPtr = ptr;
        this._reportInvalidOther(mask);
    }

    protected void _reportIncompleteBinaryReadRaw(int expLen, int actLen) throws IOException {
        this._reportInvalidEOF(String.format(" for Binary value (raw): expected %d bytes, only found %d", expLen, actLen), this.currentToken());
    }

    protected void _reportIncompleteBinaryRead7Bit(int expLen, int actLen) throws IOException {
        long encodedLen = (7L + 8L * (long)expLen) / 7L;
        this._reportInvalidEOF(String.format(" for Binary value (7-bit): expected %d payload bytes (from %d encoded), only decoded %d", expLen, encodedLen, actLen), this.currentToken());
    }

    protected String _reportTruncatedUTF8InString(int strLenBytes, int truncatedCharOffset, int firstUTFByteValue, int bytesExpected) throws IOException {
        throw this._constructReadException(String.format("Truncated UTF-8 character in Short Unicode String value (%d bytes): byte 0x%02X at offset #%d indicated %d more bytes needed", strLenBytes, firstUTFByteValue, truncatedCharOffset, bytesExpected));
    }

    protected String _reportTruncatedUTF8InName(int strLenBytes, int truncatedCharOffset, int firstUTFByteValue, int bytesExpected) throws IOException {
        throw this._constructReadException(String.format("Truncated UTF-8 character in Short Unicode Name (%d bytes): byte 0x%02X at offset #%d indicated %d more bytes needed", strLenBytes, firstUTFByteValue, truncatedCharOffset, bytesExpected));
    }

    private final JsonToken _eofAsNextToken() throws IOException {
        if (!this._streamReadContext.inRoot()) {
            this._handleEOF();
        }
        this.close();
        return this._updateTokenToNull();
    }

    private void createChildArrayContext(int lineNr, int colNr) throws IOException {
        this._streamReadContext = this._streamReadContext.createChildArrayContext(lineNr, colNr);
        this._streamReadConstraints.validateNestingDepth(this._streamReadContext.getNestingDepth());
    }

    private void createChildObjectContext(int lineNr, int colNr) throws IOException {
        this._streamReadContext = this._streamReadContext.createChildObjectContext(lineNr, colNr);
        this._streamReadConstraints.validateNestingDepth(this._streamReadContext.getNestingDepth());
    }

    static {
        boolean recentJdk;
        try {
            String.class.getMethod("strip", new Class[0]);
            recentJdk = true;
        }
        catch (Exception e) {
            recentJdk = false;
        }
        JDK11_OR_LATER = recentJdk;
    }

    public static enum Feature implements FormatFeature
    {
        REQUIRE_HEADER(true);

        final boolean _defaultState;
        final int _mask;

        public static int collectDefaults() {
            int flags = 0;
            for (Feature f : Feature.values()) {
                if (!f.enabledByDefault()) continue;
                flags |= f.getMask();
            }
            return flags;
        }

        private Feature(boolean defaultState) {
            this._defaultState = defaultState;
            this._mask = 1 << this.ordinal();
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public int getMask() {
            return this._mask;
        }

        public boolean enabledIn(int flags) {
            return (flags & this.getMask()) != 0;
        }
    }
}

