/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.engine.impl.persistence.entity;

import java.util.List;
import java.util.Map;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.idm.api.Group;
import org.flowable.idm.api.GroupQuery;
import org.flowable.idm.api.event.FlowableIdmEventType;
import org.flowable.idm.engine.IdmEngineConfiguration;
import org.flowable.idm.engine.delegate.event.impl.FlowableIdmEventBuilder;
import org.flowable.idm.engine.impl.GroupQueryImpl;
import org.flowable.idm.engine.impl.persistence.entity.AbstractIdmEngineEntityManager;
import org.flowable.idm.engine.impl.persistence.entity.GroupEntity;
import org.flowable.idm.engine.impl.persistence.entity.GroupEntityManager;
import org.flowable.idm.engine.impl.persistence.entity.MembershipEntityManager;
import org.flowable.idm.engine.impl.persistence.entity.data.GroupDataManager;

public class GroupEntityManagerImpl
extends AbstractIdmEngineEntityManager<GroupEntity, GroupDataManager>
implements GroupEntityManager {
    public GroupEntityManagerImpl(IdmEngineConfiguration idmEngineConfiguration, GroupDataManager groupDataManager) {
        super(idmEngineConfiguration, groupDataManager);
    }

    @Override
    public Group createNewGroup(String groupId) {
        GroupEntity groupEntity = (GroupEntity)((GroupDataManager)this.dataManager).create();
        groupEntity.setId(groupId);
        groupEntity.setRevision(0);
        return groupEntity;
    }

    public void delete(String groupId) {
        GroupEntity group = (GroupEntity)((GroupDataManager)this.dataManager).findById(groupId);
        if (group != null) {
            this.getMembershipEntityManager().deleteMembershipByGroupId(groupId);
            if (this.getEventDispatcher() != null && this.getEventDispatcher().isEnabled()) {
                this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableIdmEventBuilder.createMembershipEvent(FlowableIdmEventType.MEMBERSHIPS_DELETED, groupId, null), ((IdmEngineConfiguration)this.engineConfiguration).getEngineCfgKey());
            }
            this.delete(group);
        }
    }

    @Override
    public GroupQuery createNewGroupQuery() {
        return new GroupQueryImpl(this.getCommandExecutor());
    }

    @Override
    public List<Group> findGroupByQueryCriteria(GroupQueryImpl query) {
        return ((GroupDataManager)this.dataManager).findGroupByQueryCriteria(query);
    }

    @Override
    public long findGroupCountByQueryCriteria(GroupQueryImpl query) {
        return ((GroupDataManager)this.dataManager).findGroupCountByQueryCriteria(query);
    }

    @Override
    public List<Group> findGroupsByUser(String userId) {
        return ((GroupDataManager)this.dataManager).findGroupsByUser(userId);
    }

    @Override
    public List<Group> findGroupsByNativeQuery(Map<String, Object> parameterMap) {
        return ((GroupDataManager)this.dataManager).findGroupsByNativeQuery(parameterMap);
    }

    @Override
    public long findGroupCountByNativeQuery(Map<String, Object> parameterMap) {
        return ((GroupDataManager)this.dataManager).findGroupCountByNativeQuery(parameterMap);
    }

    @Override
    public boolean isNewGroup(Group group) {
        return ((GroupEntity)group).getRevision() == 0;
    }

    @Override
    public List<Group> findGroupsByPrivilegeId(String privilegeId) {
        return ((GroupDataManager)this.dataManager).findGroupsByPrivilegeId(privilegeId);
    }

    protected MembershipEntityManager getMembershipEntityManager() {
        return ((IdmEngineConfiguration)this.engineConfiguration).getMembershipEntityManager();
    }
}

