/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.ipc;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Utils;
import com.netflix.spectator.api.patterns.CardinalityLimiters;
import com.netflix.spectator.ipc.IpcLogEntry;
import com.netflix.spectator.ipc.IpcLoggerConfig;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.slf4j.event.Level;

public class IpcLogger {
    private static final Marker CLIENT = MarkerFactory.getMarker((String)"ipc-client");
    private static final Marker SERVER = MarkerFactory.getMarker((String)"ipc-server");
    private final Registry registry;
    private final Clock clock;
    private final Logger logger;
    private final IpcLoggerConfig config;
    private final boolean inflightEnabled;
    private final ConcurrentHashMap<Id, AtomicInteger> inflightRequests;
    private final ConcurrentHashMap<String, Function<String, String>> limiters;
    private final LinkedBlockingQueue<IpcLogEntry> entries;

    public IpcLogger(Registry registry, Logger logger, IpcLoggerConfig config) {
        this.registry = registry;
        this.clock = registry.clock();
        this.logger = logger;
        this.config = config;
        this.inflightEnabled = config.inflightMetricsEnabled();
        this.inflightRequests = new ConcurrentHashMap();
        this.limiters = new ConcurrentHashMap();
        this.entries = new LinkedBlockingQueue(config.entryQueueSize());
    }

    public IpcLogger(Registry registry, Logger logger) {
        this(registry, logger, k -> null);
    }

    public IpcLogger(Registry registry) {
        this(registry, LoggerFactory.getLogger(IpcLogger.class), k -> null);
    }

    boolean inflightEnabled() {
        return this.inflightEnabled;
    }

    AtomicInteger inflightRequests(Id id) {
        return (AtomicInteger)Utils.computeIfAbsent(this.inflightRequests, (Object)id, i -> new AtomicInteger());
    }

    Function<String, String> limiterForKey(String key) {
        return (Function)Utils.computeIfAbsent(this.limiters, (Object)key, k -> {
            int n = this.config.cardinalityLimit((String)k);
            return CardinalityLimiters.rollup((int)n);
        });
    }

    private IpcLogEntry newEntry() {
        IpcLogEntry entry = this.entries.poll();
        return entry == null ? new IpcLogEntry(this.clock) : entry;
    }

    public IpcLogEntry createClientEntry() {
        return this.newEntry().withRegistry(this.registry).withLogger(this).withMarker(CLIENT);
    }

    public IpcLogEntry createServerEntry() {
        return this.newEntry().withRegistry(this.registry).withLogger(this).withMarker(SERVER);
    }

    void log(IpcLogEntry entry) {
        BiConsumer<Marker, String> log;
        Predicate<Marker> enabled;
        Level level = entry.getLevel();
        switch (level) {
            case TRACE: {
                enabled = arg_0 -> ((Logger)this.logger).isTraceEnabled(arg_0);
                log = (arg_0, arg_1) -> ((Logger)this.logger).trace(arg_0, arg_1);
                break;
            }
            case DEBUG: {
                enabled = arg_0 -> ((Logger)this.logger).isDebugEnabled(arg_0);
                log = (arg_0, arg_1) -> ((Logger)this.logger).debug(arg_0, arg_1);
                break;
            }
            case INFO: {
                enabled = arg_0 -> ((Logger)this.logger).isInfoEnabled(arg_0);
                log = (arg_0, arg_1) -> ((Logger)this.logger).info(arg_0, arg_1);
                break;
            }
            case WARN: {
                enabled = arg_0 -> ((Logger)this.logger).isWarnEnabled(arg_0);
                log = (arg_0, arg_1) -> ((Logger)this.logger).warn(arg_0, arg_1);
                break;
            }
            case ERROR: {
                enabled = arg_0 -> ((Logger)this.logger).isErrorEnabled(arg_0);
                log = (arg_0, arg_1) -> ((Logger)this.logger).error(arg_0, arg_1);
                break;
            }
            default: {
                enabled = arg_0 -> ((Logger)this.logger).isDebugEnabled(arg_0);
                log = (arg_0, arg_1) -> ((Logger)this.logger).debug(arg_0, arg_1);
            }
        }
        if (enabled.test(entry.getMarker())) {
            entry.populateMDC();
            log.accept(entry.getMarker(), entry.toString());
            MDC.clear();
        }
        if (entry.isSuccessful()) {
            entry.reset();
            this.entries.offer(entry);
        } else {
            entry.resetForRetry();
        }
    }
}

