/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.util;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlFactory;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import lombok.Generated;
import org.apache.xerces.xs.XSObject;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.jdom2.Document;
import org.jdom2.input.DOMBuilder;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.core.xml.schema.XSBase64Binary;
import org.opensaml.core.xml.schema.XSBoolean;
import org.opensaml.core.xml.schema.XSBooleanValue;
import org.opensaml.core.xml.schema.XSDateTime;
import org.opensaml.core.xml.schema.XSInteger;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.core.xml.schema.XSURI;
import org.opensaml.core.xml.schema.impl.XSAnyBuilder;
import org.opensaml.core.xml.schema.impl.XSBase64BinaryBuilder;
import org.opensaml.core.xml.schema.impl.XSBooleanBuilder;
import org.opensaml.core.xml.schema.impl.XSDateTimeBuilder;
import org.opensaml.core.xml.schema.impl.XSIntegerBuilder;
import org.opensaml.core.xml.schema.impl.XSStringBuilder;
import org.opensaml.core.xml.schema.impl.XSURIBuilder;
import org.opensaml.saml.saml2.core.NameIDType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public abstract class AbstractSamlObjectBuilder
implements Serializable {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSamlObjectBuilder.class);
    protected static final String DEFAULT_ELEMENT_LOCAL_NAME_FIELD = "DEFAULT_ELEMENT_LOCAL_NAME";
    private static final ObjectMapper XML_OBJECT_MAPPER = JacksonObjectMapperFactory.builder().jsonFactory((JsonFactory)new XmlFactory()).useWrapperNameAsProperty(true).build().toObjectMapper();
    private static final String SIGNATURE_FACTORY_PROVIDER_CLASS = "org.jcp.xml.dsig.internal.dom.XMLDSigRI";
    private static final long serialVersionUID = -6833230731146922780L;
    private static final String LOG_MESSAGE_ATTR_CREATED = "Created attribute value XMLObject: [{}]";
    protected final transient OpenSamlConfigBean openSamlConfigBean;

    public static String signSamlResponse(String samlResponse, PrivateKey privateKey, PublicKey publicKey) {
        Document doc = AbstractSamlObjectBuilder.constructDocumentFromXml(samlResponse);
        if (doc != null) {
            org.jdom2.Element signedElement = AbstractSamlObjectBuilder.signSamlElement(doc.getRootElement(), privateKey, publicKey);
            doc.setRootElement(signedElement.detach());
            return new XMLOutputter().outputString(doc);
        }
        throw new IllegalArgumentException("Error signing SAML Response: Null document");
    }

    public static Document constructDocumentFromXml(String xmlString) {
        LOGGER.trace("Attempting to construct an instance of Document from xml: [{}]", (Object)xmlString);
        try {
            SAXBuilder builder = new SAXBuilder();
            builder.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            builder.setFeature("http://xml.org/sax/features/external-general-entities", false);
            builder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            return builder.build((InputStream)new ByteArrayInputStream(xmlString.getBytes(Charset.defaultCharset())));
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return null;
        }
    }

    private static org.jdom2.Element signSamlElement(org.jdom2.Element element, PrivateKey privKey, PublicKey pubKey) {
        try {
            LOGGER.trace("Attempting to sign Element: [{}]", (Object)element);
            String providerName = System.getProperty("jsr105Provider", SIGNATURE_FACTORY_PROVIDER_CLASS);
            Class<?> clazz = Class.forName(providerName);
            XMLSignatureFactory sigFactory = XMLSignatureFactory.getInstance("DOM", (Provider)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            List envelopedTransform = CollectionUtils.wrap((Object)sigFactory.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null));
            Reference ref = sigFactory.newReference("", sigFactory.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), envelopedTransform, null, null);
            SignatureMethod signatureMethod = AbstractSamlObjectBuilder.getSignatureMethodFromPublicKey(pubKey, sigFactory);
            CanonicalizationMethod canonicalizationMethod = sigFactory.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", (C14NMethodParameterSpec)null);
            SignedInfo signedInfo = sigFactory.newSignedInfo(canonicalizationMethod, signatureMethod, CollectionUtils.wrap((Object)ref));
            KeyInfoFactory keyInfoFactory = sigFactory.getKeyInfoFactory();
            KeyValue keyValuePair = keyInfoFactory.newKeyValue(pubKey);
            KeyInfo keyInfo = keyInfoFactory.newKeyInfo(CollectionUtils.wrap((Object)keyValuePair));
            Element w3cElement = AbstractSamlObjectBuilder.toDom(element);
            DOMSignContext dsc = new DOMSignContext(privKey, (Node)w3cElement);
            Node xmlSigInsertionPoint = AbstractSamlObjectBuilder.getXmlSignatureInsertLocation(w3cElement);
            dsc.setNextSibling(xmlSigInsertionPoint);
            XMLSignature signature = sigFactory.newXMLSignature(signedInfo, keyInfo);
            signature.sign(dsc);
            return new DOMBuilder().build(w3cElement);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error signing SAML element: " + e.getMessage(), e);
        }
    }

    private static SignatureMethod getSignatureMethodFromPublicKey(PublicKey pubKey, XMLSignatureFactory sigFactory) throws Exception {
        String algorithm = pubKey.getAlgorithm();
        if ("DSA".equalsIgnoreCase(algorithm)) {
            return sigFactory.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#dsa-sha1", null);
        }
        if ("RSA".equalsIgnoreCase(algorithm)) {
            return sigFactory.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null);
        }
        String format = String.format("Unsupported type of key algorithm: [%s]. Only DSA or RSA are supported", algorithm);
        throw new IllegalArgumentException(format);
    }

    private static Node getXmlSignatureInsertLocation(Element elem) {
        NodeList nodeListExtensions = elem.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:protocol", "Extensions");
        if (nodeListExtensions.getLength() != 0) {
            return nodeListExtensions.item(nodeListExtensions.getLength() - 1);
        }
        NodeList nodeListStatus = elem.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:protocol", "Status");
        return nodeListStatus.item(nodeListStatus.getLength() - 1);
    }

    private static Element toDom(org.jdom2.Element element) throws Exception {
        return Objects.requireNonNull(AbstractSamlObjectBuilder.toDom(element.getDocument())).getDocumentElement();
    }

    private static org.w3c.dom.Document toDom(Document doc) throws Exception {
        LOGGER.trace("Creating document from: [{}]", (Object)doc);
        XMLOutputter xmlOutputter = new XMLOutputter();
        StringWriter elemStrWriter = new StringWriter();
        xmlOutputter.output(doc, (Writer)elemStrWriter);
        byte[] xmlBytes = elemStrWriter.toString().getBytes(Charset.defaultCharset());
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        dbf.setFeature("http://apache.org/xml/features/validation/schema/normalized-value", false);
        dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
        dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        return dbf.newDocumentBuilder().parse(new ByteArrayInputStream(xmlBytes));
    }

    protected XMLObject newAttributeValue(Object value, String valueType, QName elementName) {
        LOGGER.trace("Creating new attribute value XMLObject for value: [{}], value type: [{}], QName: [{}]", new Object[]{value, valueType, elementName});
        if (value instanceof NameIDType) {
            NameIDType instance = (NameIDType)value;
            LOGGER.trace(LOG_MESSAGE_ATTR_CREATED, value);
            instance.detach();
            return (XMLObject)value;
        }
        if (XSString.class.getSimpleName().equalsIgnoreCase(valueType)) {
            XSStringBuilder builder = new XSStringBuilder();
            XSString attrValueObj = (XSString)builder.buildObject(elementName, XSString.TYPE_NAME);
            attrValueObj.setValue(value.toString());
            LOGGER.trace(LOG_MESSAGE_ATTR_CREATED, (Object)attrValueObj);
            return attrValueObj;
        }
        if (XSURI.class.getSimpleName().equalsIgnoreCase(valueType)) {
            XSURIBuilder builder = new XSURIBuilder();
            XSURI attrValueObj = (XSURI)builder.buildObject(elementName, XSURI.TYPE_NAME);
            attrValueObj.setURI(value.toString());
            LOGGER.trace(LOG_MESSAGE_ATTR_CREATED, (Object)attrValueObj);
            return attrValueObj;
        }
        if (XSBoolean.class.getSimpleName().equalsIgnoreCase(valueType)) {
            XSBooleanBuilder builder = new XSBooleanBuilder();
            XSBoolean attrValueObj = (XSBoolean)builder.buildObject(elementName, XSBoolean.TYPE_NAME);
            attrValueObj.setValue(XSBooleanValue.valueOf((String)value.toString().toLowerCase(Locale.ENGLISH)));
            LOGGER.trace(LOG_MESSAGE_ATTR_CREATED, (Object)attrValueObj);
            return attrValueObj;
        }
        if (XSInteger.class.getSimpleName().equalsIgnoreCase(valueType)) {
            XSIntegerBuilder builder = new XSIntegerBuilder();
            XSInteger attrValueObj = (XSInteger)builder.buildObject(elementName, XSInteger.TYPE_NAME);
            attrValueObj.setValue(Integer.valueOf(value.toString()));
            LOGGER.trace(LOG_MESSAGE_ATTR_CREATED, (Object)attrValueObj);
            return attrValueObj;
        }
        if (XSDateTime.class.getSimpleName().equalsIgnoreCase(valueType)) {
            XSDateTimeBuilder builder = new XSDateTimeBuilder();
            XSDateTime attrValueObj = (XSDateTime)builder.buildObject(elementName, XSDateTime.TYPE_NAME);
            attrValueObj.setValue(ZonedDateTime.parse(value.toString()).toInstant());
            LOGGER.trace(LOG_MESSAGE_ATTR_CREATED, (Object)attrValueObj);
            return attrValueObj;
        }
        if (XSBase64Binary.class.getSimpleName().equalsIgnoreCase(valueType)) {
            XSBase64BinaryBuilder builder = new XSBase64BinaryBuilder();
            XSBase64Binary attrValueObj = (XSBase64Binary)builder.buildObject(elementName, XSBase64Binary.TYPE_NAME);
            attrValueObj.setValue(value.toString());
            LOGGER.trace(LOG_MESSAGE_ATTR_CREATED, (Object)attrValueObj);
            return attrValueObj;
        }
        if (XSObject.class.getSimpleName().equalsIgnoreCase(valueType)) {
            return (XMLObject)FunctionUtils.doUnchecked(() -> {
                XSAnyBuilder builder = new XSAnyBuilder();
                XSAny attrValueObj = (XSAny)builder.buildObject(elementName);
                attrValueObj.setTextContent(XML_OBJECT_MAPPER.writeValueAsString(value));
                LOGGER.trace(LOG_MESSAGE_ATTR_CREATED, (Object)attrValueObj);
                return attrValueObj;
            });
        }
        XSAnyBuilder builder = new XSAnyBuilder();
        XSAny attrValueObj = (XSAny)builder.buildObject(elementName);
        attrValueObj.setTextContent(value.toString());
        LOGGER.trace(LOG_MESSAGE_ATTR_CREATED, (Object)attrValueObj);
        return attrValueObj;
    }

    protected void addAttributeValuesToSamlAttribute(String attributeName, Object attributeValue, String valueType, List<XMLObject> attributeList, QName defaultElementName) {
        Set values = CollectionUtils.toCollection((Object)attributeValue);
        if (values == null || values.isEmpty()) {
            LOGGER.trace("Skipping over SAML attribute [{}] since it has no value", (Object)attributeName);
            return;
        }
        LOGGER.trace("Attempting to generate SAML attribute [{}] with value(s) [{}]", (Object)attributeName, (Object)values);
        Set collection = values;
        LOGGER.debug("Generating multi-valued SAML attribute [{}] with values [{}]", (Object)attributeName, (Object)collection);
        collection.stream().map(value -> this.newAttributeValue(value, valueType, defaultElementName)).forEach(attributeList::add);
    }

    @Generated
    public OpenSamlConfigBean getOpenSamlConfigBean() {
        return this.openSamlConfigBean;
    }

    @Generated
    protected AbstractSamlObjectBuilder(OpenSamlConfigBean openSamlConfigBean) {
        this.openSamlConfigBean = openSamlConfigBean;
    }
}

