/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.accesstoken;

import com.google.common.base.Splitter;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.DefaultAuthenticationBuilder;
import org.apereo.cas.authentication.DefaultAuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessTokenFactory;
import org.apereo.cas.ticket.expiration.FixedInstantExpirationPolicy;
import org.apereo.cas.ticket.registry.TicketCompactor;
import org.apereo.cas.util.DateTimeUtils;
import org.springframework.beans.factory.ObjectProvider;

public class OAuth20AccessTokenCompactor
implements TicketCompactor<OAuth20AccessToken> {
    private final ObjectProvider<TicketFactory> ticketFactory;
    private final ServiceFactory serviceFactory;
    private final PrincipalFactory principalFactory;
    private long maximumTicketLength = 384L;

    public String compact(StringBuilder builder, Ticket ticket) throws Exception {
        OAuth20AccessToken accessToken = (OAuth20AccessToken)ticket;
        builder.append(String.format("%s%s", ",", accessToken.getService().getShortenedId()));
        builder.append(String.format("%s%s", ",", accessToken.getClientId()));
        builder.append(String.format("%s%s", ",", String.join((CharSequence)"|", accessToken.getScopes())));
        builder.append(String.format("%s%s", ",", accessToken.getResponseType() != null ? accessToken.getResponseType().ordinal() : OAuth20ResponseTypes.CODE.ordinal()));
        builder.append(String.format("%s%s", ",", accessToken.getGrantType() != null ? accessToken.getGrantType().ordinal() : OAuth20GrantTypes.AUTHORIZATION_CODE.ordinal()));
        builder.append(this.compactAuthenticationAttempt(accessToken).toString());
        return builder.toString();
    }

    public Class<OAuth20AccessToken> getTicketType() {
        return OAuth20AccessToken.class;
    }

    public Ticket expand(String ticketId) throws Throwable {
        TicketCompactor.CompactTicket structure = this.parse(ticketId);
        Service service = this.serviceFactory.createService((String)structure.ticketElements().get(TicketCompactor.CompactTicketIndexes.SERVICE.getIndex()));
        String clientId = (String)structure.ticketElements().get(3);
        HashSet scopes = StringUtils.isNotBlank((CharSequence)((CharSequence)structure.ticketElements().get(4))) ? Splitter.on((String)"|").splitToList((CharSequence)structure.ticketElements().get(4)) : new HashSet();
        OAuth20ResponseTypes responseType = OAuth20ResponseTypes.values()[Integer.parseInt((String)structure.ticketElements().get(5))];
        OAuth20GrantTypes grantType = OAuth20GrantTypes.values()[Integer.parseInt((String)structure.ticketElements().get(6))];
        Authentication authentication = this.expandAuthentication(this.principalFactory, structure);
        OAuth20AccessTokenFactory accessTokenFactory = (OAuth20AccessTokenFactory)((TicketFactory)this.ticketFactory.getObject()).get(this.getTicketType());
        OAuth20AccessToken accessToken = accessTokenFactory.create(service, authentication, scopes, clientId, responseType, grantType);
        accessToken.setExpirationPolicy((ExpirationPolicy)new FixedInstantExpirationPolicy(structure.expirationTime()));
        accessToken.setCreationTime(DateTimeUtils.zonedDateTimeOf((Instant)structure.creationTime()));
        return accessToken;
    }

    protected Authentication expandAuthentication(PrincipalFactory principalFactory, TicketCompactor.CompactTicket structure) throws Throwable {
        List authenticationData = Splitter.on((String)":").splitToList((CharSequence)structure.ticketElements().get(7));
        Principal principal = principalFactory.createPrincipal((String)authenticationData.getFirst());
        Set handlers = Arrays.stream(((String)authenticationData.get(1)).split("#")).collect(Collectors.toSet());
        Set credentialTypes = Arrays.stream(((String)authenticationData.get(2)).split("#")).collect(Collectors.toSet());
        return DefaultAuthenticationBuilder.newInstance().setPrincipal(principal).addAttribute("credentialType", credentialTypes).addAttribute("successfulAuthenticationHandlers", handlers).setSuccesses(handlers.stream().collect(Collectors.toMap(Function.identity(), name -> new DefaultAuthenticationHandlerExecutionResult(name, principal)))).addAttribute("authenticationMethod", handlers).build();
    }

    protected StringBuilder compactAuthenticationAttempt(OAuth20AccessToken code) {
        Authentication authentication = code.getAuthentication();
        StringBuilder builder = new StringBuilder();
        if (authentication != null) {
            String handlers = String.join((CharSequence)"#", authentication.getSuccesses().keySet());
            String principalId = authentication.getPrincipal().getId();
            String credentialTypes = authentication.getCredentials().stream().map(credential -> credential.getClass().getSimpleName()).collect(Collectors.joining("#"));
            builder.append(String.format("%s%s:%s:%s", ",", principalId, handlers, credentialTypes));
        }
        return builder;
    }

    @Generated
    public OAuth20AccessTokenCompactor(ObjectProvider<TicketFactory> ticketFactory, ServiceFactory serviceFactory, PrincipalFactory principalFactory) {
        this.ticketFactory = ticketFactory;
        this.serviceFactory = serviceFactory;
        this.principalFactory = principalFactory;
    }

    @Generated
    public long getMaximumTicketLength() {
        return this.maximumTicketLength;
    }
}

