/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.jobexecutor;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.flowable.batch.api.Batch;
import org.flowable.batch.api.BatchPart;
import org.flowable.batch.api.BatchService;
import org.flowable.common.engine.api.FlowableBatchPartMigrationException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandConfig;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.jobexecutor.AbstractProcessInstanceMigrationJobHandler;
import org.flowable.engine.impl.migration.ProcessInstanceMigrationDocumentImpl;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.migration.ProcessInstanceMigrationDocument;
import org.flowable.engine.migration.ProcessInstanceMigrationManager;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.variable.api.delegate.VariableScope;

public class ProcessInstanceMigrationJobHandler
extends AbstractProcessInstanceMigrationJobHandler {
    public static final String TYPE = "process-migration";

    public String getType() {
        return TYPE;
    }

    public void execute(JobEntity job, String configuration, VariableScope variableScope, CommandContext commandContext) {
        final ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        final BatchService batchService = processEngineConfiguration.getBatchServiceConfiguration().getBatchService();
        ProcessInstanceMigrationManager processInstanceMigrationManager = processEngineConfiguration.getProcessInstanceMigrationManager();
        final String batchPartId = ProcessInstanceMigrationJobHandler.getBatchPartIdFromHandlerCfg(configuration);
        BatchPart batchPart = batchService.getBatchPart(batchPartId);
        Batch batch = batchService.getBatch(batchPart.getBatchId());
        ProcessInstanceMigrationDocument migrationDocument = ProcessInstanceMigrationDocumentImpl.fromJson(batch.getBatchDocumentJson(processEngineConfiguration.getEngineCfgKey()));
        try {
            processInstanceMigrationManager.migrateProcessInstance(batchPart.getScopeId(), migrationDocument, commandContext);
        }
        catch (Exception e) {
            final String exceptionMessage = e.getMessage();
            processEngineConfiguration.getCommandExecutor().execute((Command)new Command<Object>(){

                public Void execute(CommandContext commandContext) {
                    CommandConfig commandConfig = processEngineConfiguration.getCommandExecutor().getDefaultConfig().transactionRequiresNew();
                    return (Void)processEngineConfiguration.getCommandExecutor().execute(commandConfig, (Command)new Command<Void>(){

                        public Void execute(CommandContext commandContext2) {
                            String resultAsJsonString = ProcessInstanceMigrationJobHandler.this.prepareResultAsJsonString(exceptionMessage, e);
                            batchService.completeBatchPart(batchPartId, "fail", resultAsJsonString);
                            return null;
                        }
                    });
                }
            });
            FlowableBatchPartMigrationException wrappedException = new FlowableBatchPartMigrationException(e.getMessage(), (Throwable)e);
            wrappedException.setIgnoreFailedJob(true);
            throw wrappedException;
        }
        String resultAsJsonString = this.prepareResultAsJsonString();
        batchService.completeBatchPart(batchPartId, "success", resultAsJsonString);
    }

    protected String prepareResultAsJsonString(String exceptionMessage, Exception e) {
        ObjectNode objectNode = ProcessInstanceMigrationJobHandler.getObjectMapper().createObjectNode();
        objectNode.put("resultStatus", "fail");
        objectNode.put("resultMessage", exceptionMessage);
        objectNode.put("resultStacktrace", this.getExceptionStacktrace(e));
        return objectNode.toString();
    }

    protected String prepareResultAsJsonString() {
        ObjectNode objectNode = ProcessInstanceMigrationJobHandler.getObjectMapper().createObjectNode();
        objectNode.put("resultStatus", "success");
        return objectNode.toString();
    }

    protected String getExceptionStacktrace(Throwable exception) {
        StringWriter stringWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }
}

