/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao.repo;

import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.core.persistence.api.dao.EntityCacheDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.jpa.dao.repo.ImplementationRepoExt;
import org.apache.syncope.core.persistence.jpa.entity.JPAExternalResource;
import org.apache.syncope.core.persistence.jpa.entity.JPAImplementation;
import org.apache.syncope.core.spring.implementation.ImplementationManager;

public class ImplementationRepoExtImpl
implements ImplementationRepoExt {
    protected final ExternalResourceDAO resourceDAO;
    protected final EntityCacheDAO entityCacheDAO;
    protected final EntityManager entityManager;

    public ImplementationRepoExtImpl(ExternalResourceDAO resourceDAO, EntityCacheDAO entityCacheDAO, EntityManager entityManager) {
        this.resourceDAO = resourceDAO;
        this.entityCacheDAO = entityCacheDAO;
        this.entityManager = entityManager;
    }

    @Override
    public List<Implementation> findByTypeAndKeyword(String type, String keyword) {
        StringBuilder queryString = new StringBuilder("SELECT e FROM ").append(JPAImplementation.class.getSimpleName()).append(" e ").append("WHERE e.type=:type ");
        if (StringUtils.isNotBlank((CharSequence)keyword)) {
            queryString.append("AND e.id LIKE :keyword ");
        }
        queryString.append("ORDER BY e.id ASC");
        TypedQuery query = this.entityManager.createQuery(queryString.toString(), Implementation.class);
        query.setParameter("type", (Object)type);
        if (StringUtils.isNotBlank((CharSequence)keyword)) {
            query.setParameter("keyword", (Object)keyword);
        }
        return query.getResultList();
    }

    @Override
    public Implementation save(Implementation implementation) {
        Implementation merged = (Implementation)this.entityManager.merge((Object)implementation);
        ImplementationManager.purge((String)merged.getKey());
        this.resourceDAO.findByProvisionSorter(merged).forEach(resource -> this.entityCacheDAO.evict(JPAExternalResource.class, resource.getKey()));
        return merged;
    }

    @Override
    public void deleteById(String key) {
        Implementation implementation = (Implementation)this.entityManager.find(JPAImplementation.class, (Object)key);
        if (implementation == null) {
            return;
        }
        this.entityManager.remove((Object)implementation);
        ImplementationManager.purge((String)key);
    }
}

