/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.openjpa;

import java.util.Locale;
import java.util.Optional;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.meta.ValueMapping;
import org.apache.openjpa.jdbc.meta.strats.AbstractValueHandler;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ColumnIO;
import org.apache.openjpa.jdbc.sql.DBDictionary;

public class LocaleValueHandler
extends AbstractValueHandler {
    private static final long serialVersionUID = 487849441377630981L;
    private static final LocaleValueHandler INSTANCE = new LocaleValueHandler();

    public static LocaleValueHandler getInstance() {
        return INSTANCE;
    }

    @Deprecated
    public Column[] map(ValueMapping vm, String name, ColumnIO io, boolean adapt) {
        DBDictionary dict = vm.getMappingRepository().getDBDictionary();
        DBIdentifier colName = DBIdentifier.newColumn((String)name, (boolean)Optional.ofNullable(dict).filter(DBDictionary::delimitAll).isPresent());
        return LocaleValueHandler.map(colName);
    }

    public static Column[] map(DBIdentifier name) {
        Column col = new Column();
        col.setIdentifier(name);
        col.setJavaType(9);
        return new Column[]{col};
    }

    public Object toDataStoreValue(ValueMapping vm, Object val, JDBCStore store) {
        return Optional.ofNullable(val).map(o -> ((Locale)o).toString()).orElse(null);
    }

    public Object toObjectValue(ValueMapping vm, Object val) {
        return Optional.ofNullable(val).map(o -> LocaleUtils.toLocale((String)((String)o))).orElse(null);
    }
}

