/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.credentials;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.scribejava.core.model.OAuth2AccessToken;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import lombok.Generated;
import org.pac4j.core.credentials.Credentials;

public class OAuth20Credentials
extends Credentials {
    private static final long serialVersionUID = -1370874913317625788L;
    private String code;
    private OAuth20AccessToken accessToken;

    public OAuth20Credentials(String code) {
        this.code = code;
    }

    @JsonIgnore
    public OAuth2AccessToken toAccessToken() {
        return new OAuth2AccessToken(this.accessToken.getAccessToken(), this.accessToken.getTokenType(), this.accessToken.getExpiresIn(), this.accessToken.getRefreshToken(), this.accessToken.getScope(), this.accessToken.getRawResponse());
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OAuth20Credentials)) {
            return false;
        }
        OAuth20Credentials other = (OAuth20Credentials)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$code = this.code;
        String other$code = other.code;
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        OAuth20AccessToken this$accessToken = this.accessToken;
        OAuth20AccessToken other$accessToken = other.accessToken;
        return !(this$accessToken == null ? other$accessToken != null : !((Object)this$accessToken).equals(other$accessToken));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OAuth20Credentials;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $code = this.code;
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        OAuth20AccessToken $accessToken = this.accessToken;
        result = result * 59 + ($accessToken == null ? 43 : ((Object)$accessToken).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "OAuth20Credentials(code=" + this.code + ", accessToken=" + this.accessToken + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OAuth20Credentials() {
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setCode(String code) {
        this.code = code;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getCode() {
        return this.code;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setAccessToken(OAuth20AccessToken accessToken) {
        this.accessToken = accessToken;
    }

    public static class OAuth20AccessToken
    implements Serializable {
        private static final long serialVersionUID = -1370874913317625788L;
        private String accessToken;
        private String tokenType;
        private Integer expiresIn;
        private String refreshToken;
        private String scope;
        private String rawResponse;

        public static OAuth20AccessToken from(OAuth2AccessToken accessToken) {
            return new OAuth20AccessToken(accessToken.getAccessToken(), accessToken.getTokenType(), accessToken.getExpiresIn(), accessToken.getRefreshToken(), accessToken.getScope(), accessToken.getRawResponse());
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getAccessToken() {
            return this.accessToken;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getTokenType() {
            return this.tokenType;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Integer getExpiresIn() {
            return this.expiresIn;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getRefreshToken() {
            return this.refreshToken;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getScope() {
            return this.scope;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getRawResponse() {
            return this.rawResponse;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public void setTokenType(String tokenType) {
            this.tokenType = tokenType;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public void setExpiresIn(Integer expiresIn) {
            this.expiresIn = expiresIn;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public void setRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public void setScope(String scope) {
            this.scope = scope;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public void setRawResponse(String rawResponse) {
            this.rawResponse = rawResponse;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public OAuth20AccessToken(String accessToken, String tokenType, Integer expiresIn, String refreshToken, String scope, String rawResponse) {
            this.accessToken = accessToken;
            this.tokenType = tokenType;
            this.expiresIn = expiresIn;
            this.refreshToken = refreshToken;
            this.scope = scope;
            this.rawResponse = rawResponse;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public OAuth20AccessToken() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public OAuth20AccessToken withAccessToken(String accessToken) {
            return this.accessToken == accessToken ? this : new OAuth20AccessToken(accessToken, this.tokenType, this.expiresIn, this.refreshToken, this.scope, this.rawResponse);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public OAuth20AccessToken withTokenType(String tokenType) {
            return this.tokenType == tokenType ? this : new OAuth20AccessToken(this.accessToken, tokenType, this.expiresIn, this.refreshToken, this.scope, this.rawResponse);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public OAuth20AccessToken withExpiresIn(Integer expiresIn) {
            return this.expiresIn == expiresIn ? this : new OAuth20AccessToken(this.accessToken, this.tokenType, expiresIn, this.refreshToken, this.scope, this.rawResponse);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public OAuth20AccessToken withRefreshToken(String refreshToken) {
            return this.refreshToken == refreshToken ? this : new OAuth20AccessToken(this.accessToken, this.tokenType, this.expiresIn, refreshToken, this.scope, this.rawResponse);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public OAuth20AccessToken withScope(String scope) {
            return this.scope == scope ? this : new OAuth20AccessToken(this.accessToken, this.tokenType, this.expiresIn, this.refreshToken, scope, this.rawResponse);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public OAuth20AccessToken withRawResponse(String rawResponse) {
            return this.rawResponse == rawResponse ? this : new OAuth20AccessToken(this.accessToken, this.tokenType, this.expiresIn, this.refreshToken, this.scope, rawResponse);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OAuth20AccessToken)) {
                return false;
            }
            OAuth20AccessToken other = (OAuth20AccessToken)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$expiresIn = this.expiresIn;
            Integer other$expiresIn = other.expiresIn;
            if (this$expiresIn == null ? other$expiresIn != null : !((Object)this$expiresIn).equals(other$expiresIn)) {
                return false;
            }
            String this$accessToken = this.accessToken;
            String other$accessToken = other.accessToken;
            if (this$accessToken == null ? other$accessToken != null : !this$accessToken.equals(other$accessToken)) {
                return false;
            }
            String this$tokenType = this.tokenType;
            String other$tokenType = other.tokenType;
            if (this$tokenType == null ? other$tokenType != null : !this$tokenType.equals(other$tokenType)) {
                return false;
            }
            String this$refreshToken = this.refreshToken;
            String other$refreshToken = other.refreshToken;
            if (this$refreshToken == null ? other$refreshToken != null : !this$refreshToken.equals(other$refreshToken)) {
                return false;
            }
            String this$scope = this.scope;
            String other$scope = other.scope;
            if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
                return false;
            }
            String this$rawResponse = this.rawResponse;
            String other$rawResponse = other.rawResponse;
            return !(this$rawResponse == null ? other$rawResponse != null : !this$rawResponse.equals(other$rawResponse));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof OAuth20AccessToken;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $expiresIn = this.expiresIn;
            result = result * 59 + ($expiresIn == null ? 43 : ((Object)$expiresIn).hashCode());
            String $accessToken = this.accessToken;
            result = result * 59 + ($accessToken == null ? 43 : $accessToken.hashCode());
            String $tokenType = this.tokenType;
            result = result * 59 + ($tokenType == null ? 43 : $tokenType.hashCode());
            String $refreshToken = this.refreshToken;
            result = result * 59 + ($refreshToken == null ? 43 : $refreshToken.hashCode());
            String $scope = this.scope;
            result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
            String $rawResponse = this.rawResponse;
            result = result * 59 + ($rawResponse == null ? 43 : $rawResponse.hashCode());
            return result;
        }
    }
}

