/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.atlas.impl;

import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.atlas.impl.MeasurementSerializer;
import com.netflix.spectator.atlas.shaded.spectator-atlas.json.core.JsonFactory;
import com.netflix.spectator.atlas.shaded.spectator-atlas.json.databind.ObjectMapper;
import com.netflix.spectator.atlas.shaded.spectator-atlas.json.databind.module.SimpleModule;
import com.netflix.spectator.impl.AsciiSet;
import java.util.function.Function;

public final class JsonUtils {
    private JsonUtils() {
    }

    public static Function<String, String> createReplacementFunction(String pattern) {
        if (pattern == null) {
            return Function.identity();
        }
        AsciiSet set = AsciiSet.fromPattern((String)pattern);
        return s -> set.replaceNonMembers(s, '_');
    }

    public static ObjectMapper createMapper(JsonFactory factory, Function<String, String> fixTag) {
        SimpleModule module = new SimpleModule().addSerializer(Measurement.class, new MeasurementSerializer(fixTag));
        return new ObjectMapper(factory).registerModule(module);
    }
}

