/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.kafka.clients.MetadataRecoveryStrategy;
import org.apache.kafka.clients.producer.ProducerConfig;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ProducerConfigTest {
    private final Serializer<byte[]> keySerializer = new ByteArraySerializer();
    private final Serializer<String> valueSerializer = new StringSerializer();
    private final Object keySerializerClass = this.keySerializer.getClass();
    private final Object valueSerializerClass = this.valueSerializer.getClass();

    @Test
    public void testAppendSerializerToConfig() {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("key.serializer", this.keySerializerClass);
        configs.put("value.serializer", this.valueSerializerClass);
        Map newConfigs = ProducerConfig.appendSerializerToConfig(configs, null, null);
        Assertions.assertEquals(newConfigs.get("key.serializer"), (Object)this.keySerializerClass);
        Assertions.assertEquals(newConfigs.get("value.serializer"), (Object)this.valueSerializerClass);
        configs.clear();
        configs.put("value.serializer", this.valueSerializerClass);
        newConfigs = ProducerConfig.appendSerializerToConfig(configs, this.keySerializer, null);
        Assertions.assertEquals(newConfigs.get("key.serializer"), (Object)this.keySerializerClass);
        Assertions.assertEquals(newConfigs.get("value.serializer"), (Object)this.valueSerializerClass);
        configs.clear();
        configs.put("key.serializer", this.keySerializerClass);
        newConfigs = ProducerConfig.appendSerializerToConfig(configs, null, this.valueSerializer);
        Assertions.assertEquals(newConfigs.get("key.serializer"), (Object)this.keySerializerClass);
        Assertions.assertEquals(newConfigs.get("value.serializer"), (Object)this.valueSerializerClass);
        configs.clear();
        newConfigs = ProducerConfig.appendSerializerToConfig(configs, this.keySerializer, this.valueSerializer);
        Assertions.assertEquals(newConfigs.get("key.serializer"), (Object)this.keySerializerClass);
        Assertions.assertEquals(newConfigs.get("value.serializer"), (Object)this.valueSerializerClass);
    }

    @Test
    public void testAppendSerializerToConfigWithException() {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("key.serializer", null);
        configs.put("value.serializer", this.valueSerializerClass);
        Assertions.assertThrows(ConfigException.class, () -> ProducerConfig.appendSerializerToConfig((Map)configs, null, this.valueSerializer));
        configs.clear();
        configs.put("key.serializer", this.keySerializerClass);
        configs.put("value.serializer", null);
        Assertions.assertThrows(ConfigException.class, () -> ProducerConfig.appendSerializerToConfig((Map)configs, this.keySerializer, null));
    }

    @Test
    public void testInvalidCompressionType() {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("key.serializer", this.keySerializerClass);
        configs.put("value.serializer", this.valueSerializerClass);
        configs.put("compression.type", "abc");
        Assertions.assertThrows(ConfigException.class, () -> new ProducerConfig(configs));
    }

    @Test
    public void testInvalidSecurityProtocol() {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("key.serializer", this.keySerializerClass);
        configs.put("value.serializer", this.valueSerializerClass);
        configs.put("security.protocol", "abc");
        ConfigException ce = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> new ProducerConfig(configs));
        Assertions.assertTrue((boolean)ce.getMessage().contains("security.protocol"));
    }

    @Test
    public void testDefaultMetadataRecoveryStrategy() {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("key.serializer", this.keySerializerClass);
        configs.put("value.serializer", this.valueSerializerClass);
        ProducerConfig producerConfig = new ProducerConfig(configs);
        Assertions.assertEquals((Object)MetadataRecoveryStrategy.NONE.name, (Object)producerConfig.getString("metadata.recovery.strategy"));
    }

    @Test
    public void testInvalidMetadataRecoveryStrategy() {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("key.serializer", this.keySerializerClass);
        configs.put("value.serializer", this.valueSerializerClass);
        configs.put("metadata.recovery.strategy", "abc");
        ConfigException ce = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> new ProducerConfig(configs));
        Assertions.assertTrue((boolean)ce.getMessage().contains("metadata.recovery.strategy"));
    }

    @Test
    public void testCaseInsensitiveSecurityProtocol() {
        String saslSslLowerCase = SecurityProtocol.SASL_SSL.name.toLowerCase(Locale.ROOT);
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("key.serializer", this.keySerializerClass);
        configs.put("value.serializer", this.valueSerializerClass);
        configs.put("security.protocol", saslSslLowerCase);
        ProducerConfig producerConfig = new ProducerConfig(configs);
        Assertions.assertEquals((Object)saslSslLowerCase, producerConfig.originals().get("security.protocol"));
    }
}

