/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.metadata;

import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationBuilder;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationTransaction;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.metadata.BaseAuthenticationMetaDataPopulator;
import org.springframework.util.StringUtils;

public class AuthenticationContextAttributeMetaDataPopulator
extends BaseAuthenticationMetaDataPopulator {
    private final String authenticationContextAttribute;
    private final AuthenticationHandler authenticationHandler;
    private final String authenticationContextAttributeValue;

    public void populateAttributes(AuthenticationBuilder builder, AuthenticationTransaction transaction) {
        if (builder.hasAttribute("authenticationMethod", obj -> obj.toString().equals(this.authenticationHandler.getName()))) {
            StringUtils.commaDelimitedListToSet((String)this.authenticationContextAttribute).forEach(attribute -> builder.mergeAttribute(attribute, (Object)this.authenticationContextAttributeValue));
        }
    }

    public boolean supports(Credential credential) {
        return this.authenticationHandler.supports(credential);
    }

    @Override
    @Generated
    public String toString() {
        return "AuthenticationContextAttributeMetaDataPopulator(super=" + super.toString() + ", authenticationContextAttribute=" + this.authenticationContextAttribute + ", authenticationHandler=" + String.valueOf(this.authenticationHandler) + ", authenticationContextAttributeValue=" + this.authenticationContextAttributeValue + ")";
    }

    @Generated
    public AuthenticationContextAttributeMetaDataPopulator(String authenticationContextAttribute, AuthenticationHandler authenticationHandler, String authenticationContextAttributeValue) {
        this.authenticationContextAttribute = authenticationContextAttribute;
        this.authenticationHandler = authenticationHandler;
        this.authenticationContextAttributeValue = authenticationContextAttributeValue;
    }
}

