/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.starter;

import com.zaxxer.hikari.HikariDataSource;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.Collection;
import java.util.List;
import javax.sql.DataSource;
import org.apache.syncope.core.persistence.api.DomainHolder;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.actuate.metrics.data.MetricsRepositoryMethodInvocationListener;
import org.springframework.boot.actuate.metrics.jdbc.DataSourcePoolMetrics;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.jdbc.metadata.DataSourcePoolMetadataProvidersConfiguration;
import org.springframework.boot.jdbc.metadata.DataSourcePoolMetadataProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactory;
import org.springframework.data.repository.core.support.RepositoryMethodInvocationListener;
import org.springframework.util.Assert;
import org.springframework.util.function.SingletonSupplier;

@ConditionalOnClass(value={HikariDataSource.class})
@Import(value={DataSourcePoolMetadataProvidersConfiguration.class})
@Configuration(proxyBeanMethods=false)
public class JPAMetricsContext {
    @Bean
    public MeterBinder dataSourcePoolMetadataMeterBinder(final ObjectProvider<DataSourcePoolMetadataProvider> metadataProviders, final DomainHolder<DataSource> domainHolder) {
        return new MeterBinder(){

            public void bindTo(MeterRegistry registry) {
                List metadataProvidersList = metadataProviders.stream().toList();
                domainHolder.getDomains().forEach((name, dataSource) -> new DataSourcePoolMetrics(dataSource, (Collection)metadataProvidersList, name, List.of()).bindTo(registry));
            }
        };
    }

    @Bean
    public static BeanPostProcessor jpaRepositoryFactoryBeanPostProcessor(final ObjectProvider<MetricsRepositoryMethodInvocationListener> metricsRepositoryMethodInvocationListener) {
        return new BeanPostProcessor(){

            public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                if (bean instanceof JpaRepositoryFactory) {
                    JpaRepositoryFactory jpaRepositoryFactory = (JpaRepositoryFactory)bean;
                    MetricsRepositoryMethodInvocationListener listener = (MetricsRepositoryMethodInvocationListener)SingletonSupplier.of(() -> ((ObjectProvider)metricsRepositoryMethodInvocationListener).getObject()).get();
                    Assert.state((listener != null ? 1 : 0) != 0, (String)"'listener' must not be null");
                    jpaRepositoryFactory.addInvocationListener((RepositoryMethodInvocationListener)listener);
                }
                return bean;
            }
        };
    }
}

