/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.parser;

import java.util.Iterator;
import java.util.Map;
import org.apache.wicket.util.lang.Objects;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.StringValue;
import org.apache.wicket.util.value.AttributeMap;
import org.apache.wicket.util.value.IValueMap;

public class XmlTag {
    TextSegment text;
    private AttributeMap attributes;
    String name;
    String namespace;
    TagType type;
    private XmlTag closes;
    private XmlTag copyOf = this;
    private boolean isMutable = true;

    public XmlTag() {
    }

    public XmlTag(TextSegment text, TagType type) {
        this.text = text;
        this.type = type;
    }

    public final boolean closes(XmlTag open) {
        return this.closes == open || this.closes == open.copyOf && this != open;
    }

    public final boolean equalTo(XmlTag element) {
        XmlTag that = element;
        if (!Objects.equal((Object)this.getNamespace(), (Object)that.getNamespace())) {
            return false;
        }
        if (!this.getName().equals(that.getName())) {
            return false;
        }
        return this.getAttributes().equals(that.getAttributes());
    }

    public IValueMap getAttributes() {
        return this.attributes();
    }

    private AttributeMap attributes() {
        if (this.attributes == null) {
            this.attributes = this.copyOf == this || this.copyOf == null || this.copyOf.attributes == null ? new AttributeMap() : new AttributeMap((Map)this.copyOf.attributes);
        }
        return this.attributes;
    }

    public boolean hasAttributes() {
        return this.attributes != null && this.attributes.size() > 0;
    }

    public int getColumnNumber() {
        return this.text != null ? this.text.columnNumber : 0;
    }

    public int getLength() {
        return this.text != null ? this.text.text.length() : 0;
    }

    public int getLineNumber() {
        return this.text != null ? this.text.lineNumber : 0;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public final XmlTag getOpenTag() {
        return this.closes;
    }

    public int getPos() {
        return this.text != null ? this.text.pos : 0;
    }

    public CharSequence getAttribute(String key) {
        return this.getAttributes().getCharSequence(key);
    }

    public TagType getType() {
        return this.type;
    }

    public boolean isClose() {
        return this.type == TagType.CLOSE;
    }

    public final boolean isMutable() {
        return this.isMutable;
    }

    public boolean isOpen() {
        return this.type == TagType.OPEN;
    }

    public boolean isOpenClose() {
        return this.type == TagType.OPEN_CLOSE;
    }

    public XmlTag makeImmutable() {
        if (this.isMutable) {
            this.isMutable = false;
            if (this.attributes != null) {
                this.attributes.makeImmutable();
                this.text = null;
            }
        }
        return this;
    }

    public XmlTag mutable() {
        if (this.isMutable) {
            return this;
        }
        XmlTag tag = new XmlTag();
        this.copyPropertiesTo(tag);
        return tag;
    }

    void copyPropertiesTo(XmlTag dest) {
        dest.namespace = this.namespace;
        dest.name = this.name;
        dest.text = this.text;
        dest.type = this.type;
        dest.isMutable = true;
        dest.closes = this.closes;
        dest.copyOf = this.copyOf;
        if (this.attributes != null) {
            dest.attributes = new AttributeMap((Map)this.attributes);
        }
    }

    public Object put(String key, boolean value) {
        return this.put(key, Boolean.toString(value));
    }

    public Object put(String key, int value) {
        return this.put(key, Integer.toString(value));
    }

    public Object put(String key, CharSequence value) {
        return this.getAttributes().put((Object)key, (Object)value);
    }

    public Object put(String key, StringValue value) {
        return this.getAttributes().put((Object)key, (Object)(value != null ? value.toString() : null));
    }

    public void putAll(Map<String, Object> map) {
        Iterator<Map.Entry<String, Object>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Object value;
            Map.Entry<String, Object> entry;
            this.put(entry.getKey(), (value = (entry = iterator.next()).getValue()) != null ? value.toString() : null);
        }
    }

    public void remove(String key) {
        this.getAttributes().remove((Object)key);
    }

    public void setName(String name) {
        if (!this.isMutable) {
            throw new UnsupportedOperationException("Attempt to set name of immutable tag");
        }
        this.name = name.intern();
    }

    public void setNamespace(String namespace) {
        if (!this.isMutable) {
            throw new UnsupportedOperationException("Attempt to set namespace of immutable tag");
        }
        this.namespace = namespace != null ? namespace.intern() : null;
    }

    public void setOpenTag(XmlTag tag) {
        this.closes = tag;
    }

    public void setType(TagType type) {
        if (!this.isMutable) {
            throw new UnsupportedOperationException("Attempt to set type of immutable tag");
        }
        this.type = type;
    }

    public String toDebugString() {
        return "[Tag name = " + this.name + ", pos = " + this.text.pos + ", line = " + this.text.lineNumber + ", attributes = [" + String.valueOf(this.getAttributes()) + "], type = " + String.valueOf((Object)this.type) + "]";
    }

    public String toString() {
        return this.toCharSequence().toString();
    }

    public CharSequence toCharSequence() {
        if (!this.isMutable && this.text != null) {
            return this.text.text;
        }
        return this.toXmlString();
    }

    public String toUserDebugString() {
        return " '" + this.toString() + "' (line " + this.getLineNumber() + ", column " + this.getColumnNumber() + ")";
    }

    public CharSequence toXmlString() {
        AppendingStringBuffer buffer = new AppendingStringBuffer();
        buffer.append('<');
        if (this.type == TagType.CLOSE) {
            buffer.append('/');
        }
        if (this.namespace != null) {
            buffer.append(this.namespace);
            buffer.append(':');
        }
        buffer.append(this.name);
        buffer.append((Object)this.attributes().toCharSequence());
        if (this.type == TagType.OPEN_CLOSE) {
            buffer.append('/');
        }
        buffer.append('>');
        return buffer;
    }

    static class TextSegment {
        final int columnNumber;
        final int lineNumber;
        final int pos;
        final CharSequence text;

        TextSegment(CharSequence text, int pos, int line, int col) {
            this.text = text;
            this.pos = pos;
            this.lineNumber = line;
            this.columnNumber = col;
        }

        public final CharSequence getText() {
            return this.text;
        }

        public String toString() {
            return this.text.toString();
        }
    }

    public static enum TagType {
        CLOSE,
        OPEN,
        OPEN_CLOSE;

    }
}

