/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.query.simple;

import com.googlecode.cqengine.attribute.Attribute;
import com.googlecode.cqengine.attribute.SimpleAttribute;
import com.googlecode.cqengine.query.option.QueryOptions;
import com.googlecode.cqengine.query.simple.SimpleQuery;
import com.googlecode.cqengine.query.simple.StringStartsWith;
import com.googlecode.cqengine.query.support.QueryValidation;

public class StringIsPrefixOf<O, A extends CharSequence>
extends SimpleQuery<O, A> {
    private final A value;

    public StringIsPrefixOf(Attribute<O, A> attribute, A value) {
        super(attribute);
        this.value = (CharSequence)QueryValidation.checkQueryValueNotNull(value);
    }

    public A getValue() {
        return this.value;
    }

    @Override
    protected boolean matchesSimpleAttribute(SimpleAttribute<O, A> attribute, O object, QueryOptions queryOptions) {
        CharSequence attributeValue = (CharSequence)attribute.getValue(object, queryOptions);
        return StringStartsWith.matchesValue(this.value, attributeValue, queryOptions);
    }

    @Override
    protected boolean matchesNonSimpleAttribute(Attribute<O, A> attribute, O object, QueryOptions queryOptions) {
        for (CharSequence attributeValue : attribute.getValues(object, queryOptions)) {
            if (!StringStartsWith.matchesValue(this.value, attributeValue, queryOptions)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int calcHashCode() {
        int result = this.attribute.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StringIsPrefixOf)) {
            return false;
        }
        StringIsPrefixOf that = (StringIsPrefixOf)o;
        if (!this.attribute.equals(that.attribute)) {
            return false;
        }
        return this.value.equals(that.value);
    }
}

