/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.to.Provision;
import org.apache.syncope.common.lib.to.ProvisioningReport;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.common.lib.types.TraceLevel;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.PolicyDAO;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.task.ProvisioningTask;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.ConnectorManager;
import org.apache.syncope.core.provisioning.api.ProvisionSorter;
import org.apache.syncope.core.provisioning.api.job.JobExecutionContext;
import org.apache.syncope.core.provisioning.api.job.JobExecutionException;
import org.apache.syncope.core.provisioning.java.job.AbstractSchedTaskJobDelegate;
import org.apache.syncope.core.provisioning.java.job.TaskJob;
import org.apache.syncope.core.provisioning.java.pushpull.DefaultProvisionSorter;
import org.apache.syncope.core.spring.implementation.ImplementationManager;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractProvisioningJobDelegate<T extends ProvisioningTask<T>>
extends AbstractSchedTaskJobDelegate<T> {
    private static final String USER = "USER";
    private static final String GROUP = "GROUP";
    private static final String LINKED_ACCOUNT = "LINKED_ACCOUNT";
    @Autowired
    protected ConnectorManager connectorManager;
    @Autowired
    protected AnyTypeDAO anyTypeDAO;
    @Autowired
    protected ExternalResourceDAO resourceDAO;
    @Autowired
    protected EntityFactory entityFactory;
    @Autowired
    protected AnyUtilsFactory anyUtilsFactory;
    @Autowired
    protected PolicyDAO policyDAO;
    protected Optional<ProvisionSorter> perContextProvisionSorter = Optional.empty();
    protected Connector connector;

    @Override
    protected void init(TaskType taskType, String taskKey, JobExecutionContext context) throws JobExecutionException {
        super.init(taskType, taskKey, context);
        boolean noMapping = true;
        for (Provision provision2 : ((ProvisioningTask)this.task).getResource().getProvisions().stream().filter(provision -> provision.getMapping() != null).toList()) {
            noMapping = false;
            if (provision2.getMapping().getConnObjectKeyItem() != null) continue;
            throw new JobExecutionException("Invalid ConnObjectKey mapping for provision " + String.valueOf(provision2));
        }
        if (noMapping) {
            boolean bl = noMapping = ((ProvisioningTask)this.task).getResource().getOrgUnit() == null;
        }
        if (noMapping) {
            throw new JobExecutionException("No provisions nor orgUnit available: aborting...");
        }
        this.connector = this.connectorManager.getConnector(((ProvisioningTask)this.task).getResource());
    }

    @Override
    protected boolean hasToBeRegistered(TaskExec<?> execution) {
        return TaskJob.Status.valueOf(execution.getStatus()) == TaskJob.Status.FAILURE && ((ProvisioningTask)this.task).getResource().getProvisioningTraceLevel().ordinal() >= TraceLevel.FAILURES.ordinal() || ((ProvisioningTask)this.task).getResource().getProvisioningTraceLevel().ordinal() >= TraceLevel.SUMMARY.ordinal();
    }

    protected ProvisionSorter getProvisionSorter(T task) {
        if (task.getResource().getProvisionSorter() != null) {
            try {
                return (ProvisionSorter)ImplementationManager.build((Implementation)task.getResource().getProvisionSorter(), () -> this.perContextProvisionSorter.orElse(null), instance -> {
                    this.perContextProvisionSorter = Optional.of(instance);
                });
            }
            catch (Exception e) {
                LOG.error("While building {}", (Object)task.getResource().getProvisionSorter(), (Object)e);
            }
        }
        if (this.perContextProvisionSorter.isEmpty()) {
            this.perContextProvisionSorter = Optional.of(new DefaultProvisionSorter());
        }
        return this.perContextProvisionSorter.get();
    }

    protected String generate(Collection<ProvisioningReport> results, TraceLevel level) {
        StringBuilder sb = new StringBuilder();
        results.stream().map(result -> {
            if (level == TraceLevel.SUMMARY) {
                return null;
            }
            if (level == TraceLevel.FAILURES && result.getStatus() == ProvisioningReport.Status.FAILURE) {
                return String.format("Failed %s (key/name): %s/%s with message: %s", result.getOperation(), result.getKey(), result.getName(), result.getMessage());
            }
            return String.format("%s %s (key/name): %s/%s %s", result.getOperation(), result.getStatus(), result.getKey(), result.getName(), StringUtils.isBlank((CharSequence)result.getMessage()) ? "" : "with message: " + result.getMessage());
        }).filter(Objects::nonNull).forEach(report -> sb.append((String)report).append('\n'));
        return sb.toString();
    }

    protected String createReport(Collection<ProvisioningReport> provResults, ExternalResource resource, boolean dryRun) {
        boolean includeRealm;
        TraceLevel traceLevel = resource.getProvisioningTraceLevel();
        if (traceLevel == TraceLevel.NONE) {
            return null;
        }
        StringBuilder report = new StringBuilder();
        if (dryRun) {
            report.append("==> Dry run only, no modifications were made <==\n\n");
        }
        ArrayList<ProvisioningReport> rSuccCreate = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> rFailCreate = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> rSuccUpdate = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> rFailUpdate = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> rSuccDelete = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> rFailDelete = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> rSuccNone = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> rIgnore = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> uSuccCreate = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> uFailCreate = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> uSuccUpdate = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> uFailUpdate = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> uSuccDelete = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> uFailDelete = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> uSuccNone = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> uIgnore = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> gSuccCreate = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> gFailCreate = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> gSuccUpdate = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> gFailUpdate = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> gSuccDelete = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> gFailDelete = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> gSuccNone = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> gIgnore = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> aSuccCreate = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> aFailCreate = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> aSuccUpdate = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> aFailUpdate = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> aSuccDelete = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> aFailDelete = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> aSuccNone = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> aIgnore = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> laSuccCreate = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> laFailCreate = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> laSuccUpdate = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> laFailUpdate = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> laSuccDelete = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> laFailDelete = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> laSuccNone = new ArrayList<ProvisioningReport>();
        ArrayList<ProvisioningReport> laIgnore = new ArrayList<ProvisioningReport>();
        for (ProvisioningReport provResult : provResults) {
            block0 : switch (provResult.getStatus()) {
                case SUCCESS: {
                    switch (provResult.getOperation()) {
                        case CREATE: {
                            if (StringUtils.isBlank((CharSequence)provResult.getAnyType())) {
                                rSuccCreate.add(provResult);
                                break block0;
                            }
                            switch (provResult.getAnyType()) {
                                case "USER": {
                                    uSuccCreate.add(provResult);
                                    break block0;
                                }
                                case "LINKED_ACCOUNT": {
                                    laSuccCreate.add(provResult);
                                    break block0;
                                }
                                case "GROUP": {
                                    gSuccCreate.add(provResult);
                                    break block0;
                                }
                            }
                            aSuccCreate.add(provResult);
                            break block0;
                        }
                        case UPDATE: {
                            if (StringUtils.isBlank((CharSequence)provResult.getAnyType())) {
                                rSuccUpdate.add(provResult);
                                break block0;
                            }
                            switch (provResult.getAnyType()) {
                                case "USER": {
                                    uSuccUpdate.add(provResult);
                                    break block0;
                                }
                                case "LINKED_ACCOUNT": {
                                    laSuccUpdate.add(provResult);
                                    break block0;
                                }
                                case "GROUP": {
                                    gSuccUpdate.add(provResult);
                                    break block0;
                                }
                            }
                            aSuccUpdate.add(provResult);
                            break block0;
                        }
                        case DELETE: {
                            if (StringUtils.isBlank((CharSequence)provResult.getAnyType())) {
                                rSuccDelete.add(provResult);
                                break block0;
                            }
                            switch (provResult.getAnyType()) {
                                case "USER": {
                                    uSuccDelete.add(provResult);
                                    break block0;
                                }
                                case "LINKED_ACCOUNT": {
                                    laSuccDelete.add(provResult);
                                    break block0;
                                }
                                case "GROUP": {
                                    gSuccDelete.add(provResult);
                                    break block0;
                                }
                            }
                            aSuccDelete.add(provResult);
                            break block0;
                        }
                        case NONE: {
                            if (StringUtils.isBlank((CharSequence)provResult.getAnyType())) {
                                rSuccNone.add(provResult);
                                break block0;
                            }
                            switch (provResult.getAnyType()) {
                                case "USER": {
                                    uSuccNone.add(provResult);
                                    break block0;
                                }
                                case "LINKED_ACCOUNT": {
                                    laSuccNone.add(provResult);
                                    break block0;
                                }
                                case "GROUP": {
                                    gSuccNone.add(provResult);
                                    break block0;
                                }
                            }
                            aSuccNone.add(provResult);
                            break block0;
                        }
                    }
                    break;
                }
                case FAILURE: {
                    switch (provResult.getOperation()) {
                        case CREATE: {
                            if (StringUtils.isBlank((CharSequence)provResult.getAnyType())) {
                                rFailCreate.add(provResult);
                                break block0;
                            }
                            switch (provResult.getAnyType()) {
                                case "USER": {
                                    uFailCreate.add(provResult);
                                    break block0;
                                }
                                case "LINKED_ACCOUNT": {
                                    laFailCreate.add(provResult);
                                    break block0;
                                }
                                case "GROUP": {
                                    gFailCreate.add(provResult);
                                    break block0;
                                }
                            }
                            aFailCreate.add(provResult);
                            break block0;
                        }
                        case UPDATE: {
                            if (StringUtils.isBlank((CharSequence)provResult.getAnyType())) {
                                rFailUpdate.add(provResult);
                                break block0;
                            }
                            switch (provResult.getAnyType()) {
                                case "USER": {
                                    uFailUpdate.add(provResult);
                                    break block0;
                                }
                                case "LINKED_ACCOUNT": {
                                    laFailUpdate.add(provResult);
                                    break block0;
                                }
                                case "GROUP": {
                                    gFailUpdate.add(provResult);
                                    break block0;
                                }
                            }
                            aFailUpdate.add(provResult);
                            break block0;
                        }
                        case DELETE: {
                            if (StringUtils.isBlank((CharSequence)provResult.getAnyType())) {
                                rFailDelete.add(provResult);
                                break block0;
                            }
                            switch (provResult.getAnyType()) {
                                case "USER": {
                                    uFailDelete.add(provResult);
                                    break block0;
                                }
                                case "LINKED_ACCOUNT": {
                                    laFailDelete.add(provResult);
                                    break block0;
                                }
                                case "GROUP": {
                                    gFailDelete.add(provResult);
                                    break block0;
                                }
                            }
                            aFailDelete.add(provResult);
                            break block0;
                        }
                    }
                    break;
                }
                case IGNORE: {
                    if (StringUtils.isBlank((CharSequence)provResult.getAnyType())) {
                        rIgnore.add(provResult);
                        break;
                    }
                    switch (provResult.getAnyType()) {
                        case "USER": {
                            uIgnore.add(provResult);
                            break block0;
                        }
                        case "LINKED_ACCOUNT": {
                            laIgnore.add(provResult);
                            break block0;
                        }
                        case "GROUP": {
                            gIgnore.add(provResult);
                            break block0;
                        }
                    }
                    aIgnore.add(provResult);
                    break;
                }
            }
        }
        boolean includeUser = resource.getProvisionByAnyType(AnyTypeKind.USER.name()).isPresent();
        boolean includeGroup = resource.getProvisionByAnyType(AnyTypeKind.GROUP.name()).isPresent();
        boolean includeAnyObject = resource.getProvisions().stream().anyMatch(provision -> !provision.getAnyType().equals(AnyTypeKind.USER.name()) && !provision.getAnyType().equals(AnyTypeKind.GROUP.name()));
        boolean bl = includeRealm = resource.getOrgUnit() != null;
        if (includeUser) {
            report.append("Users ").append("[created/failures]: ").append(uSuccCreate.size()).append('/').append(uFailCreate.size()).append(' ').append("[updated/failures]: ").append(uSuccUpdate.size()).append('/').append(uFailUpdate.size()).append(' ').append("[deleted/failures]: ").append(uSuccDelete.size()).append('/').append(uFailDelete.size()).append(' ').append("[no operation/ignored]: ").append(uSuccNone.size()).append('/').append(uIgnore.size()).append('\n');
            report.append("Accounts ").append("[created/failures]: ").append(laSuccCreate.size()).append('/').append(laFailCreate.size()).append(' ').append("[updated/failures]: ").append(laSuccUpdate.size()).append('/').append(laFailUpdate.size()).append(' ').append("[deleted/failures]: ").append(laSuccDelete.size()).append('/').append(laFailDelete.size()).append(' ').append("[no operation/ignored]: ").append(laSuccNone.size()).append('/').append(laIgnore.size()).append('\n');
        }
        if (includeGroup) {
            report.append("Groups ").append("[created/failures]: ").append(gSuccCreate.size()).append('/').append(gFailCreate.size()).append(' ').append("[updated/failures]: ").append(gSuccUpdate.size()).append('/').append(gFailUpdate.size()).append(' ').append("[deleted/failures]: ").append(gSuccDelete.size()).append('/').append(gFailDelete.size()).append(' ').append("[no operation/ignored]: ").append(gSuccNone.size()).append('/').append(gIgnore.size()).append('\n');
        }
        if (includeAnyObject) {
            report.append("Any objects ").append("[created/failures]: ").append(aSuccCreate.size()).append('/').append(aFailCreate.size()).append(' ').append("[updated/failures]: ").append(aSuccUpdate.size()).append('/').append(aFailUpdate.size()).append(' ').append("[deleted/failures]: ").append(aSuccDelete.size()).append('/').append(aFailDelete.size()).append(' ').append("[no operation/ignored]: ").append(aSuccNone.size()).append('/').append(aIgnore.size());
        }
        if (includeRealm) {
            report.append("Realms ").append("[created/failures]: ").append(rSuccCreate.size()).append('/').append(rFailCreate.size()).append(' ').append("[updated/failures]: ").append(rSuccUpdate.size()).append('/').append(rFailUpdate.size()).append(' ').append("[deleted/failures]: ").append(rSuccDelete.size()).append('/').append(rFailDelete.size()).append(' ').append("[no operation/ignored]: ").append(rSuccNone.size()).append('/').append(rIgnore.size());
        }
        if (traceLevel == TraceLevel.FAILURES || traceLevel == TraceLevel.ALL) {
            if (includeUser) {
                if (!uFailCreate.isEmpty()) {
                    report.append("\n\nUsers failed to create: ");
                    report.append(this.generate(uFailCreate, traceLevel));
                }
                if (!uFailUpdate.isEmpty()) {
                    report.append("\nUsers failed to update: ");
                    report.append(this.generate(uFailUpdate, traceLevel));
                }
                if (!uFailDelete.isEmpty()) {
                    report.append("\nUsers failed to delete: ");
                    report.append(this.generate(uFailDelete, traceLevel));
                }
                if (!laFailCreate.isEmpty()) {
                    report.append("\n\nAccounts failed to create: ");
                    report.append(this.generate(laFailCreate, traceLevel));
                }
                if (!laFailUpdate.isEmpty()) {
                    report.append("\nAccounts failed to update: ");
                    report.append(this.generate(laFailUpdate, traceLevel));
                }
                if (!laFailDelete.isEmpty()) {
                    report.append("\nAccounts failed to delete: ");
                    report.append(this.generate(laFailDelete, traceLevel));
                }
            }
            if (includeGroup) {
                if (!gFailCreate.isEmpty()) {
                    report.append("\n\nGroups failed to create: ");
                    report.append(this.generate(gFailCreate, traceLevel));
                }
                if (!gFailUpdate.isEmpty()) {
                    report.append("\nGroups failed to update: ");
                    report.append(this.generate(gFailUpdate, traceLevel));
                }
                if (!gFailDelete.isEmpty()) {
                    report.append("\nGroups failed to delete: ");
                    report.append(this.generate(gFailDelete, traceLevel));
                }
            }
            if (includeAnyObject && !aFailCreate.isEmpty()) {
                report.append("\nAny objects failed to create: ");
                report.append(this.generate(aFailCreate, traceLevel));
            }
            if (includeAnyObject && !aFailUpdate.isEmpty()) {
                report.append("\nAny objects failed to update: ");
                report.append(this.generate(aFailUpdate, traceLevel));
            }
            if (includeAnyObject && !aFailDelete.isEmpty()) {
                report.append("\nAny objects failed to delete: ");
                report.append(this.generate(aFailDelete, traceLevel));
            }
            if (includeRealm) {
                if (!rFailCreate.isEmpty()) {
                    report.append("\nRealms failed to create: ");
                    report.append(this.generate(rFailCreate, traceLevel));
                }
                if (!rFailUpdate.isEmpty()) {
                    report.append("\nRealms failed to update: ");
                    report.append(this.generate(rFailUpdate, traceLevel));
                }
                if (!rFailDelete.isEmpty()) {
                    report.append("\nRealms failed to delete: ");
                    report.append(this.generate(rFailDelete, traceLevel));
                }
            }
        }
        if (traceLevel == TraceLevel.ALL) {
            if (includeUser) {
                if (!uSuccCreate.isEmpty()) {
                    report.append("\n\nUsers created:\n").append(this.generate(uSuccCreate, traceLevel));
                }
                if (!uSuccUpdate.isEmpty()) {
                    report.append("\nUsers updated:\n").append(this.generate(uSuccUpdate, traceLevel));
                }
                if (!uSuccDelete.isEmpty()) {
                    report.append("\nUsers deleted:\n").append(this.generate(uSuccDelete, traceLevel));
                }
                if (!uSuccNone.isEmpty()) {
                    report.append("\nUsers no operation:\n").append(this.generate(uSuccNone, traceLevel));
                }
                if (!uIgnore.isEmpty()) {
                    report.append("\nUsers ignored:\n").append(this.generate(uIgnore, traceLevel));
                }
                if (!laSuccCreate.isEmpty()) {
                    report.append("\n\nAccounts created:\n").append(this.generate(laSuccCreate, traceLevel));
                }
                if (!laSuccUpdate.isEmpty()) {
                    report.append("\nAccounts updated:\n").append(this.generate(laSuccUpdate, traceLevel));
                }
                if (!laSuccDelete.isEmpty()) {
                    report.append("\nAccounts deleted:\n").append(this.generate(laSuccDelete, traceLevel));
                }
                if (!laSuccNone.isEmpty()) {
                    report.append("\nAccounts no operation:\n").append(this.generate(laSuccNone, traceLevel));
                }
                if (!laIgnore.isEmpty()) {
                    report.append("\nAccounts ignored:\n").append(this.generate(laIgnore, traceLevel));
                }
            }
            if (includeGroup) {
                if (!gSuccCreate.isEmpty()) {
                    report.append("\n\nGroups created:\n").append(this.generate(gSuccCreate, traceLevel));
                }
                if (!gSuccUpdate.isEmpty()) {
                    report.append("\nGroups updated:\n").append(this.generate(gSuccUpdate, traceLevel));
                }
                if (!gSuccDelete.isEmpty()) {
                    report.append("\nGroups deleted:\n").append(this.generate(gSuccDelete, traceLevel));
                }
                if (!gSuccNone.isEmpty()) {
                    report.append("\nGroups no operation:\n").append(this.generate(gSuccNone, traceLevel));
                }
                if (!gIgnore.isEmpty()) {
                    report.append("\nGroups ignored:\n").append(this.generate(gIgnore, traceLevel));
                }
            }
            if (includeAnyObject) {
                if (!aSuccCreate.isEmpty()) {
                    report.append("\n\nAny objects created:\n").append(this.generate(aSuccCreate, traceLevel));
                }
                if (!aSuccUpdate.isEmpty()) {
                    report.append("\nAny objects updated:\n").append(this.generate(aSuccUpdate, traceLevel));
                }
                if (!aSuccDelete.isEmpty()) {
                    report.append("\nAny objects deleted:\n").append(this.generate(aSuccDelete, traceLevel));
                }
                if (!aSuccNone.isEmpty()) {
                    report.append("\nAny objects no operation:\n").append(this.generate(aSuccNone, traceLevel));
                }
                if (!aIgnore.isEmpty()) {
                    report.append("\nAny objects ignored:\n").append(this.generate(aIgnore, traceLevel));
                }
            }
            if (includeRealm) {
                if (!rSuccCreate.isEmpty()) {
                    report.append("\n\nRealms created:\n").append(this.generate(rSuccCreate, traceLevel));
                }
                if (!rSuccUpdate.isEmpty()) {
                    report.append("\nRealms updated:\n").append(this.generate(rSuccUpdate, traceLevel));
                }
                if (!rSuccDelete.isEmpty()) {
                    report.append("\nRealms deleted:\n").append(this.generate(rSuccDelete, traceLevel));
                }
                if (!rSuccNone.isEmpty()) {
                    report.append("\nRealms no operation:\n").append(this.generate(rSuccNone, traceLevel));
                }
                if (!rIgnore.isEmpty()) {
                    report.append("\nRealms ignored:\n").append(this.generate(rIgnore, traceLevel));
                }
            }
        }
        return report.toString();
    }
}

