/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group;

import java.util.Iterator;
import java.util.Map;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import org.apache.kafka.common.Uuid;

public class Utils {
    private Utils() {
    }

    public static OptionalInt ofSentinel(int value) {
        return value != -1 ? OptionalInt.of(value) : OptionalInt.empty();
    }

    public static OptionalLong ofSentinel(long value) {
        return value != -1L ? OptionalLong.of(value) : OptionalLong.empty();
    }

    public static String assignmentToString(Map<Uuid, Set<Integer>> assignment) {
        StringBuilder builder = new StringBuilder("[");
        Iterator<Map.Entry<Uuid, Set<Integer>>> topicsIterator = assignment.entrySet().iterator();
        while (topicsIterator.hasNext()) {
            Map.Entry<Uuid, Set<Integer>> entry = topicsIterator.next();
            Iterator<Integer> partitionsIterator = entry.getValue().iterator();
            while (partitionsIterator.hasNext()) {
                builder.append(entry.getKey());
                builder.append("-");
                builder.append(partitionsIterator.next());
                if (!partitionsIterator.hasNext() && !topicsIterator.hasNext()) continue;
                builder.append(", ");
            }
        }
        builder.append("]");
        return builder.toString();
    }
}

