/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.multitenancy.DefaultTenantExtractor;
import org.apereo.cas.multitenancy.DefaultTenantsManager;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.multitenancy.TenantsManager;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.CasWebSecurityConfigurer;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.io.Resource;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.Multitenancy})
@AutoConfiguration
public class CasCoreMultitenancyAutoConfiguration {
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"tenantsManager"})
    public TenantsManager tenantsManager(CasConfigurationProperties casProperties) throws Exception {
        Resource location = casProperties.getMultitenancy().getJson().getLocation();
        return new DefaultTenantsManager(location);
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"tenantExtractor"})
    public TenantExtractor tenantExtractor(ApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="tenantsManager") TenantsManager tenantsManager) {
        return new DefaultTenantExtractor(tenantsManager, applicationContext, casProperties);
    }

    @Bean
    @ConditionalOnMissingBean(name={"casMultitenancyEndpointConfigurer"})
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public CasWebSecurityConfigurer<HttpSecurity> casMultitenancyEndpointConfigurer() {
        return new CasWebSecurityConfigurer<HttpSecurity>(this){

            @CanIgnoreReturnValue
            public CasWebSecurityConfigurer<HttpSecurity> configure(HttpSecurity http) throws Exception {
                http.authorizeHttpRequests(customizer -> {
                    AntPathRequestMatcher authEndpoints = new AntPathRequestMatcher("/tenants/**");
                    ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)customizer.requestMatchers(new RequestMatcher[]{authEndpoints})).permitAll();
                });
                return this;
            }
        };
    }
}

