/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.CASSPClientAppDAO;
import org.apache.syncope.core.persistence.api.dao.DuplicateException;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.OIDCRPClientAppDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.RealmSearchDAO;
import org.apache.syncope.core.persistence.api.dao.SAML2SPClientAppDAO;
import org.apache.syncope.core.persistence.api.dao.TaskDAO;
import org.apache.syncope.core.persistence.api.dao.search.AbstractSearchCond;
import org.apache.syncope.core.persistence.api.dao.search.AnyCond;
import org.apache.syncope.core.persistence.api.dao.search.AttrCond;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.persistence.api.search.SyncopePage;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.data.RealmDataBinder;
import org.apache.syncope.core.provisioning.api.propagation.PropagationManager;
import org.apache.syncope.core.provisioning.api.propagation.PropagationReporter;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskExecutor;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.DelegatedAdministrationException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

public class RealmLogic
extends AbstractTransactionalLogic<RealmTO> {
    protected final RealmDAO realmDAO;
    protected final RealmSearchDAO realmSearchDAO;
    protected final AnySearchDAO searchDAO;
    protected final TaskDAO taskDAO;
    protected final CASSPClientAppDAO casSPClientAppDAO;
    protected final OIDCRPClientAppDAO oidcRPClientAppDAO;
    protected final SAML2SPClientAppDAO saml2SPClientAppDAO;
    protected final RealmDataBinder binder;
    protected final PropagationManager propagationManager;
    protected final PropagationTaskExecutor taskExecutor;

    public RealmLogic(RealmDAO realmDAO, RealmSearchDAO realmSearchDAO, AnySearchDAO searchDAO, TaskDAO taskDAO, CASSPClientAppDAO casSPClientAppDAO, OIDCRPClientAppDAO oidcRPClientAppDAO, SAML2SPClientAppDAO saml2SPClientAppDAO, RealmDataBinder binder, PropagationManager propagationManager, PropagationTaskExecutor taskExecutor) {
        this.realmDAO = realmDAO;
        this.realmSearchDAO = realmSearchDAO;
        this.searchDAO = searchDAO;
        this.taskDAO = taskDAO;
        this.casSPClientAppDAO = casSPClientAppDAO;
        this.oidcRPClientAppDAO = oidcRPClientAppDAO;
        this.saml2SPClientAppDAO = saml2SPClientAppDAO;
        this.binder = binder;
        this.propagationManager = propagationManager;
        this.taskExecutor = taskExecutor;
    }

    protected void securityChecks(Set<String> effectiveRealms, String realm) {
        boolean authorized = effectiveRealms.stream().anyMatch(realm::startsWith);
        if (!authorized) {
            throw new DelegatedAdministrationException(realm, User.class.getSimpleName(), AuthContextUtils.getUsername());
        }
    }

    @PreAuthorize(value="isAuthenticated()")
    @Transactional(readOnly=true)
    public Page<RealmTO> search(String keyword, Set<String> bases, Pageable pageable) {
        HashSet<String> baseRealms = new HashSet<String>();
        if (CollectionUtils.isEmpty(bases)) {
            baseRealms.add("/");
        } else {
            for (String base : bases) {
                baseRealms.add(this.realmSearchDAO.findByFullPath(base).map(Realm::getFullPath).orElseThrow(() -> new NotFoundException("Realm " + base)));
            }
        }
        long count = this.realmSearchDAO.countDescendants(baseRealms, keyword);
        Set authorizations = AuthContextUtils.getAuthorizations().getOrDefault("REALM_SEARCH", Set.of());
        List<RealmTO> result = this.realmSearchDAO.findDescendants(baseRealms, keyword, pageable).stream().map(realm -> this.binder.getRealmTO(realm, authorizations.stream().anyMatch(auth -> realm.getFullPath().startsWith((String)auth)))).sorted(Comparator.comparing(RealmTO::getFullPath)).toList();
        return new SyncopePage(result, pageable, count);
    }

    @PreAuthorize(value="hasRole('REALM_CREATE')")
    public ProvisioningResult<RealmTO> create(String parentPath, RealmTO realmTO) {
        Realm parent;
        if (StringUtils.isBlank((CharSequence)realmTO.getParent())) {
            parent = (Realm)this.realmSearchDAO.findByFullPath(parentPath).orElseThrow(() -> new NotFoundException("Realm " + parentPath));
            realmTO.setParent(parent.getFullPath());
        } else {
            parent = (Realm)this.realmDAO.findById(realmTO.getParent()).orElseThrow(() -> new NotFoundException("Realm " + realmTO.getParent()));
            if (!parent.getFullPath().equals(parentPath)) {
                SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidPath);
                sce.getElements().add("Mismatching parent realm: " + parentPath + " Vs " + parent.getFullPath());
                throw sce;
            }
        }
        this.securityChecks((Set)AuthContextUtils.getAuthorizations().get("REALM_CREATE"), parent.getFullPath());
        String fullPath = Strings.CS.appendIfMissing(parent.getFullPath(), (CharSequence)"/", new CharSequence[0]) + realmTO.getName();
        if (this.realmSearchDAO.findByFullPath(fullPath).isPresent()) {
            throw new DuplicateException(fullPath);
        }
        Realm realm = (Realm)this.realmDAO.save((Entity)this.binder.create(parent, realmTO));
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.addAll(ResourceOperation.CREATE, realm.getResources().stream().map(Entity::getKey).toList());
        List taskInfos = this.propagationManager.createTasks(realm, propByRes, null);
        PropagationReporter propagationReporter = this.taskExecutor.execute((Collection)taskInfos, false, AuthContextUtils.getUsername());
        ProvisioningResult result = new ProvisioningResult();
        result.setEntity((EntityTO)this.binder.getRealmTO(realm, true));
        result.getPropagationStatuses().addAll(propagationReporter.getStatuses());
        return result;
    }

    @PreAuthorize(value="hasRole('REALM_UPDATE')")
    public ProvisioningResult<RealmTO> update(RealmTO realmTO) {
        Realm realm = (Realm)this.realmSearchDAO.findByFullPath(realmTO.getFullPath()).orElseThrow(() -> new NotFoundException("Realm " + realmTO.getFullPath()));
        this.securityChecks((Set)AuthContextUtils.getAuthorizations().get("REALM_UPDATE"), realm.getFullPath());
        List beforeAttrs = this.propagationManager.prepareAttrs(realm);
        PropagationByResource propByRes = this.binder.update(realm, realmTO);
        realm = (Realm)this.realmDAO.save((Entity)realm);
        List taskInfos = this.propagationManager.setAttributeDeltas(this.propagationManager.createTasks(realm, propByRes, null), beforeAttrs);
        PropagationReporter propagationReporter = this.taskExecutor.execute((Collection)taskInfos, false, AuthContextUtils.getUsername());
        ProvisioningResult result = new ProvisioningResult();
        result.setEntity((EntityTO)this.binder.getRealmTO(realm, true));
        result.getPropagationStatuses().addAll(propagationReporter.getStatuses());
        return result;
    }

    @PreAuthorize(value="hasRole('REALM_DELETE')")
    public ProvisioningResult<RealmTO> delete(String fullPath) {
        Realm realm = (Realm)this.realmSearchDAO.findByFullPath(fullPath).orElseThrow(() -> new NotFoundException("Realm " + fullPath));
        this.securityChecks((Set)AuthContextUtils.getAuthorizations().get("REALM_DELETE"), realm.getFullPath());
        if (!this.realmSearchDAO.findChildren(realm).isEmpty()) {
            throw SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RealmContains);
        }
        Set<String> adminRealms = Set.of(realm.getFullPath());
        AnyCond keyCond = new AnyCond(AttrCond.Type.ISNOTNULL);
        keyCond.setSchema("key");
        SearchCond allMatchingCond = SearchCond.of((AbstractSearchCond)keyCond);
        long users = this.searchDAO.count(realm, true, adminRealms, allMatchingCond, AnyTypeKind.USER);
        long groups = this.searchDAO.count(realm, true, adminRealms, allMatchingCond, AnyTypeKind.GROUP);
        long anyObjects = this.searchDAO.count(realm, true, adminRealms, allMatchingCond, AnyTypeKind.ANY_OBJECT);
        long macroTasks = this.taskDAO.findByRealm(realm).size();
        long clientApps = this.casSPClientAppDAO.findAllByRealm(realm).size() + this.saml2SPClientAppDAO.findAllByRealm(realm).size() + this.oidcRPClientAppDAO.findAllByRealm(realm).size();
        if (users + groups + anyObjects + macroTasks + clientApps > 0L) {
            SyncopeClientException realmContains = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RealmContains);
            realmContains.getElements().add(users + " user(s)");
            realmContains.getElements().add(groups + " group(s)");
            realmContains.getElements().add(anyObjects + " anyObject(s)");
            realmContains.getElements().add(macroTasks + " command task(s)");
            realmContains.getElements().add(clientApps + " client app(s)");
            throw realmContains;
        }
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.addAll(ResourceOperation.DELETE, realm.getResources().stream().map(Entity::getKey).toList());
        List taskInfos = this.propagationManager.createTasks(realm, propByRes, null);
        PropagationReporter propagationReporter = this.taskExecutor.execute((Collection)taskInfos, false, AuthContextUtils.getUsername());
        ProvisioningResult result = new ProvisioningResult();
        result.setEntity((EntityTO)this.binder.getRealmTO(realm, true));
        result.getPropagationStatuses().addAll(propagationReporter.getStatuses());
        this.realmDAO.delete((Entity)realm);
        return result;
    }

    @Override
    protected RealmTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String fullPath = null;
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; fullPath == null && i < args.length; ++i) {
                Object object = args[i];
                if (object instanceof String) {
                    String string;
                    fullPath = string = (String)object;
                    continue;
                }
                object = args[i];
                if (!(object instanceof RealmTO)) continue;
                RealmTO realmTO = (RealmTO)object;
                fullPath = realmTO.getFullPath();
            }
        }
        if (fullPath != null) {
            try {
                return this.binder.getRealmTO((Realm)this.realmSearchDAO.findByFullPath(fullPath).orElseThrow(), true);
            }
            catch (Throwable e) {
                LOG.debug("Unresolved reference", e);
                throw new UnresolvedReferenceException(e);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

