/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.syncope.common.lib.to.OIDCJWKSTO;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.DuplicateException;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.OIDCJWKSDAO;
import org.apache.syncope.core.persistence.api.dao.WAConfigDAO;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.am.OIDCJWKS;
import org.apache.syncope.core.persistence.api.entity.am.WAConfigEntry;
import org.apache.syncope.core.provisioning.api.data.OIDCJWKSDataBinder;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class OIDCJWKSLogic
extends AbstractTransactionalLogic<OIDCJWKSTO> {
    protected final OIDCJWKSDataBinder binder;
    protected final OIDCJWKSDAO oidcJWKSDAO;
    protected final WAConfigDAO waConfigDAO;
    protected final EntityFactory entityFactory;

    public OIDCJWKSLogic(OIDCJWKSDataBinder binder, OIDCJWKSDAO oidcJWKSDAO, WAConfigDAO waConfigDAO, EntityFactory entityFactory) {
        this.binder = binder;
        this.oidcJWKSDAO = oidcJWKSDAO;
        this.waConfigDAO = waConfigDAO;
        this.entityFactory = entityFactory;
    }

    @PreAuthorize(value="hasRole('OIDC_JWKS_READ') or hasRole('ANONYMOUS')")
    @Transactional(readOnly=true)
    public OIDCJWKSTO get() {
        return this.oidcJWKSDAO.get().map(arg_0 -> ((OIDCJWKSDataBinder)this.binder).getOIDCJWKSTO(arg_0)).orElseThrow(() -> new NotFoundException("OIDC JWKS not found"));
    }

    @PreAuthorize(value="hasRole('OIDC_JWKS_GENERATE') or hasRole('ANONYMOUS')")
    public OIDCJWKSTO generate(String jwksKeyId, String jwksType, int jwksKeySize) {
        if (this.oidcJWKSDAO.get().isEmpty()) {
            OIDCJWKSTO oidcJWKSTO = this.binder.getOIDCJWKSTO(this.oidcJWKSDAO.save(this.binder.create(jwksKeyId, jwksType, jwksKeySize)));
            WAConfigEntry jwksKeyIdConfig = (WAConfigEntry)this.entityFactory.newEntity(WAConfigEntry.class);
            jwksKeyIdConfig.setKey("cas.authn.oidc.jwks.core.jwks-key-id");
            jwksKeyIdConfig.setValues(List.of(jwksKeyId));
            this.waConfigDAO.save((Entity)jwksKeyIdConfig);
            WAConfigEntry jwksTypeConfig = (WAConfigEntry)this.entityFactory.newEntity(WAConfigEntry.class);
            jwksTypeConfig.setKey("cas.authn.oidc.jwks.core.jwks-type");
            jwksTypeConfig.setValues(List.of(jwksType));
            this.waConfigDAO.save((Entity)jwksTypeConfig);
            WAConfigEntry jwksKeySizeConfig = (WAConfigEntry)this.entityFactory.newEntity(WAConfigEntry.class);
            jwksKeySizeConfig.setKey("cas.authn.oidc.jwks.core.jwks-key-size");
            jwksKeySizeConfig.setValues(List.of(String.valueOf(jwksKeySize)));
            this.waConfigDAO.save((Entity)jwksKeySizeConfig);
            return oidcJWKSTO;
        }
        throw new DuplicateException("OIDC JWKS already set");
    }

    @PreAuthorize(value="hasRole('OIDC_JWKS_SET') or hasRole('ANONYMOUS')")
    public OIDCJWKSTO set(OIDCJWKSTO entityTO) {
        OIDCJWKS jwks = this.oidcJWKSDAO.get().orElseGet(() -> (OIDCJWKS)this.entityFactory.newEntity(OIDCJWKS.class));
        jwks.setJson(entityTO.getJson());
        return this.binder.getOIDCJWKSTO(this.oidcJWKSDAO.save(jwks));
    }

    @PreAuthorize(value="hasRole('OIDC_JWKS_DELETE')")
    public void delete() {
        this.oidcJWKSDAO.delete();
    }

    protected OIDCJWKSTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        OIDCJWKS jwks = (OIDCJWKS)this.oidcJWKSDAO.get().orElseThrow(UnresolvedReferenceException::new);
        return this.binder.getOIDCJWKSTO(jwks);
    }
}

