/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.trusted.web.flow;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.trusted.web.flow.MultifactorAuthenticationTrustBean;
import org.apereo.cas.web.flow.configurer.AbstractCasMultifactorWebflowConfigurer;
import org.apereo.cas.web.flow.configurer.CasMultifactorWebflowCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.Assert;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.ActionState;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.TargetStateResolver;
import org.springframework.webflow.engine.Transition;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.ViewState;
import org.springframework.webflow.engine.builder.BinderConfiguration;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.engine.support.DefaultTargetStateResolver;
import org.springframework.webflow.execution.Action;

public abstract class AbstractMultifactorTrustedDeviceWebflowConfigurer
extends AbstractCasMultifactorWebflowConfigurer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMultifactorTrustedDeviceWebflowConfigurer.class);
    public static final String MFA_TRUSTED_AUTHN_SCOPE_ATTR = "mfaTrustedAuthentication";

    protected AbstractMultifactorTrustedDeviceWebflowConfigurer(FlowBuilderServices flowBuilderServices, FlowDefinitionRegistry flowDefinitionRegistry, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, Optional<FlowDefinitionRegistry> mfaFlowDefinitionRegistry, List<CasMultifactorWebflowCustomizer> mfaFlowCustomizers) {
        super(flowBuilderServices, flowDefinitionRegistry, applicationContext, casProperties, mfaFlowDefinitionRegistry, mfaFlowCustomizers);
    }

    protected void registerMultifactorTrustedAuthentication() {
        this.multifactorAuthenticationFlowDefinitionRegistries.forEach(this::registerMultifactorTrustedAuthentication);
    }

    protected void registerMultifactorTrustedAuthentication(FlowDefinitionRegistry registry) {
        this.validateFlowDefinitionConfiguration();
        LOGGER.trace("Flow definitions found in the registry are [{}]", (Object[])registry.getFlowDefinitionIds());
        String flowId = Arrays.stream(registry.getFlowDefinitionIds()).findFirst().orElseThrow();
        LOGGER.trace("Processing flow definition [{}]", (Object)flowId);
        Flow flow = (Flow)registry.getFlowDefinition(flowId);
        Assert.notNull((Object)flow, (String)String.format("%s flow cannot be null or undefined", flowId));
        ActionState state = (ActionState)this.getState(flow, "initializeLoginForm", ActionState.class);
        Assert.notNull((Object)state, (String)String.format("%s state cannot be null or undefined", "initializeLoginForm"));
        Transition transition = (Transition)state.getTransition("success");
        Assert.notNull((Object)state, (String)String.format("%s transition cannot be null or undefined", "success"));
        String targetStateId = transition.getTargetStateId();
        transition.setTargetStateResolver((TargetStateResolver)new DefaultTargetStateResolver("verifyTrustedDevice"));
        ActionState verifyAction = this.createActionState(flow, "verifyTrustedDevice", new String[]{"mfaVerifyTrustAction"});
        boolean enableDeviceRegistration = this.casProperties.getAuthn().getMfa().getTrusted().getCore().isDeviceRegistrationEnabled();
        if (enableDeviceRegistration) {
            LOGGER.trace("Device registration is turned on for multifactor flow [{}]", (Object)flowId);
            this.createTransitionForState((TransitionableState)verifyAction, "yes", "finishMfaTrustedAuth");
        } else {
            this.createTransitionForState((TransitionableState)verifyAction, "yes", "realSubmit");
        }
        this.createTransitionForState((TransitionableState)verifyAction, "no", targetStateId);
        this.createTransitionForState((TransitionableState)verifyAction, "skip", targetStateId);
        ActionState submit = (ActionState)this.getState(flow, "realSubmit", ActionState.class);
        Transition success = (Transition)submit.getTransition("success");
        Assert.notNull((Object)state, (String)String.format("%s transition cannot be null or undefined", "success"));
        if (enableDeviceRegistration) {
            success.setTargetStateResolver((TargetStateResolver)new DefaultTargetStateResolver("prepareRegisterTrustedDevice"));
        } else {
            success.setTargetStateResolver((TargetStateResolver)new DefaultTargetStateResolver("registerTrustedDevice"));
        }
        this.createRegisterDeviceView(flow);
        ActionState registerAction = this.createActionState(flow, "registerTrustedDevice", new String[]{"mfaSetTrustAction"});
        this.createStateDefaultTransition((TransitionableState)registerAction, "success");
        Assert.isTrue((submit.getActionList().size() > 0 ? 1 : 0) != 0, (String)("There are no actions defined for " + flowId));
        Action act = (Action)submit.getActionList().iterator().next();
        ActionState finishMfaTrustedAuth = this.createActionState(flow, "finishMfaTrustedAuth", act);
        Transition finishedTransition = this.createTransition("success", "success");
        finishMfaTrustedAuth.getTransitionSet().add(finishedTransition);
        this.createStateDefaultTransition((TransitionableState)finishMfaTrustedAuth, "success");
    }

    private void createRegisterDeviceView(Flow flow) {
        ActionState prepareAction = this.createActionState(flow, "prepareRegisterTrustedDevice", new String[]{"mfaPrepareTrustDeviceViewAction"});
        this.createTransitionForState((TransitionableState)prepareAction, "skip", "success");
        this.createTransitionForState((TransitionableState)prepareAction, "register", "registerDeviceView");
        this.createTransitionForState((TransitionableState)prepareAction, "store", "registerTrustedDevice");
        this.createFlowVariable(flow, "mfaTrustRecord", MultifactorAuthenticationTrustBean.class);
        List fields = Arrays.stream(MultifactorAuthenticationTrustBean.class.getDeclaredFields()).map(Field::getName).collect(Collectors.toList());
        BinderConfiguration binder = this.createStateBinderConfiguration(fields);
        ViewState viewRegister = this.createViewState(flow, "registerDeviceView", "mfa-trusted-devices/casMfaRegisterDeviceView", binder);
        this.createStateModelBinding((TransitionableState)viewRegister, "mfaTrustRecord", MultifactorAuthenticationTrustBean.class);
        this.createTransitionForState((TransitionableState)viewRegister, "submit", "registerTrustedDevice", Map.of("bind", Boolean.TRUE, "validate", Boolean.TRUE));
        this.createTransitionForState((TransitionableState)viewRegister, "skip", "success", Map.of("bind", Boolean.FALSE, "validate", Boolean.FALSE));
    }

    private void validateFlowDefinitionConfiguration() {
        this.multifactorAuthenticationFlowDefinitionRegistries.forEach(registry -> {
            String msg = "CAS application context cannot find bean [%s] or [%s]. This typically indicates that configuration is attempting to activate trusted-devices functionality for multifactor authentication, yet the configuration modules that auto-configure the webflow are absent from the CAS application runtime. If you have no need for trusted-devices functionality and wish to let the multifactor authentication provider (and not CAS) remember and record trusted devices for you, you need to turn this behavior off.";
            if (!this.applicationContext.containsBean("mfaSetTrustAction") || !this.applicationContext.containsBean("mfaVerifyTrustAction")) {
                throw new IllegalArgumentException(String.format("CAS application context cannot find bean [%s] or [%s]. This typically indicates that configuration is attempting to activate trusted-devices functionality for multifactor authentication, yet the configuration modules that auto-configure the webflow are absent from the CAS application runtime. If you have no need for trusted-devices functionality and wish to let the multifactor authentication provider (and not CAS) remember and record trusted devices for you, you need to turn this behavior off.", "mfaSetTrustAction", "mfaVerifyTrustAction"));
            }
        });
    }

    protected void doInitialize() {
        super.doInitialize();
        this.registerMultifactorTrustedAuthentication();
    }
}

