/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.cipher;

import lombok.Generated;
import org.apereo.cas.configuration.model.core.util.EncryptionRandomizedSigningJwtCryptographyProperties;
import org.apereo.cas.util.cipher.BaseBinaryCipherExecutor;
import org.apereo.cas.util.crypto.CipherExecutor;

public class WebflowConversationStateCipherExecutor
extends BaseBinaryCipherExecutor {
    public WebflowConversationStateCipherExecutor(String secretKeyAlg, int signingKeySize, int encryptionKeySize) {
        this(null, null, secretKeyAlg, signingKeySize, encryptionKeySize, "webflow");
    }

    public WebflowConversationStateCipherExecutor(String secretKeyEncryption, String secretKeySigning, String secretKeyAlg, int signingKeySize, int encryptionKeySize, String cipherName) {
        super(secretKeyEncryption, secretKeySigning, signingKeySize, encryptionKeySize, cipherName);
        this.setSecretKeyAlgorithm(secretKeyAlg);
    }

    public WebflowConversationStateCipherExecutor(String encryptionSecretKey, String signingSecretKey, String secretKeyAlg, int signingKeySize, int encryptionKeySize) {
        this(encryptionSecretKey, signingSecretKey, secretKeyAlg, signingKeySize, encryptionKeySize, "webflow");
    }

    public String getName() {
        return "Spring Webflow Session State Management";
    }

    public String getEncryptionKeySetting() {
        return "cas." + this.cipherName + ".crypto.encryption.key";
    }

    public String getSigningKeySetting() {
        return "cas." + this.cipherName + ".crypto.signing.key";
    }

    public static CipherExecutor from(EncryptionRandomizedSigningJwtCryptographyProperties crypto) {
        return new WebflowConversationStateCipherExecutor(crypto.getEncryption().getKey(), crypto.getSigning().getKey(), crypto.getAlg(), crypto.getSigning().getKeySize(), crypto.getEncryption().getKeySize());
    }

    @Generated
    public WebflowConversationStateCipherExecutor() {
    }
}

