/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.http;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.http.HttpClient;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.springframework.http.HttpMethod;

public class HttpExecutionRequest {
    private static final ObjectMapper MAPPER = ((JacksonObjectMapperFactory)((JacksonObjectMapperFactory.JacksonObjectMapperFactoryBuilder)JacksonObjectMapperFactory.builder().defaultTypingEnabled(false)).build()).toObjectMapper();
    private final HttpClient httpClient;
    @NonNull
    private final HttpMethod method;
    @NonNull
    private final String url;
    private final String basicAuthUsername;
    private final String basicAuthPassword;
    private final String entity;
    private final String proxyUrl;
    private final String bearerToken;
    private final int maximumRetryAttempts;
    private final Map<String, String> parameters;
    private final Map<String, String> headers;

    boolean isBasicAuthentication() {
        return StringUtils.isNotBlank((CharSequence)this.basicAuthUsername) && StringUtils.isNotBlank((CharSequence)this.basicAuthPassword);
    }

    boolean isBearerAuthentication() {
        return StringUtils.isNotBlank((CharSequence)this.bearerToken);
    }

    @JsonIgnore
    @CanIgnoreReturnValue
    public HttpExecutionRequest body(Object body) {
        return this.withEntity((String)FunctionUtils.doUnchecked(() -> MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(body)));
    }

    @Generated
    private static int $default$maximumRetryAttempts() {
        return 3;
    }

    @Generated
    private static Map<String, String> $default$parameters() {
        return new LinkedHashMap<String, String>();
    }

    @Generated
    private static Map<String, String> $default$headers() {
        return new LinkedHashMap<String, String>();
    }

    @Generated
    protected HttpExecutionRequest(HttpExecutionRequestBuilder<?, ?> b) {
        this.httpClient = b.httpClient;
        this.method = b.method;
        if (this.method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        this.url = b.url;
        if (this.url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        this.basicAuthUsername = b.basicAuthUsername;
        this.basicAuthPassword = b.basicAuthPassword;
        this.entity = b.entity;
        this.proxyUrl = b.proxyUrl;
        this.bearerToken = b.bearerToken;
        this.maximumRetryAttempts = b.maximumRetryAttempts$set ? b.maximumRetryAttempts$value : HttpExecutionRequest.$default$maximumRetryAttempts();
        this.parameters = b.parameters$set ? b.parameters$value : HttpExecutionRequest.$default$parameters();
        this.headers = b.headers$set ? b.headers$value : HttpExecutionRequest.$default$headers();
    }

    @Generated
    public static HttpExecutionRequestBuilder<?, ?> builder() {
        return new HttpExecutionRequestBuilderImpl();
    }

    @Generated
    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    @NonNull
    @Generated
    public HttpMethod getMethod() {
        return this.method;
    }

    @NonNull
    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public String getBasicAuthUsername() {
        return this.basicAuthUsername;
    }

    @Generated
    public String getBasicAuthPassword() {
        return this.basicAuthPassword;
    }

    @Generated
    public String getEntity() {
        return this.entity;
    }

    @Generated
    public String getProxyUrl() {
        return this.proxyUrl;
    }

    @Generated
    public String getBearerToken() {
        return this.bearerToken;
    }

    @Generated
    public int getMaximumRetryAttempts() {
        return this.maximumRetryAttempts;
    }

    @Generated
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @Generated
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Generated
    public HttpExecutionRequest withHttpClient(HttpClient httpClient) {
        return this.httpClient == httpClient ? this : new HttpExecutionRequest(httpClient, this.method, this.url, this.basicAuthUsername, this.basicAuthPassword, this.entity, this.proxyUrl, this.bearerToken, this.maximumRetryAttempts, this.parameters, this.headers);
    }

    @Generated
    public HttpExecutionRequest withMethod(@NonNull HttpMethod method) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        return this.method == method ? this : new HttpExecutionRequest(this.httpClient, method, this.url, this.basicAuthUsername, this.basicAuthPassword, this.entity, this.proxyUrl, this.bearerToken, this.maximumRetryAttempts, this.parameters, this.headers);
    }

    @Generated
    public HttpExecutionRequest withUrl(@NonNull String url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        return this.url == url ? this : new HttpExecutionRequest(this.httpClient, this.method, url, this.basicAuthUsername, this.basicAuthPassword, this.entity, this.proxyUrl, this.bearerToken, this.maximumRetryAttempts, this.parameters, this.headers);
    }

    @Generated
    public HttpExecutionRequest withBasicAuthUsername(String basicAuthUsername) {
        return this.basicAuthUsername == basicAuthUsername ? this : new HttpExecutionRequest(this.httpClient, this.method, this.url, basicAuthUsername, this.basicAuthPassword, this.entity, this.proxyUrl, this.bearerToken, this.maximumRetryAttempts, this.parameters, this.headers);
    }

    @Generated
    public HttpExecutionRequest withBasicAuthPassword(String basicAuthPassword) {
        return this.basicAuthPassword == basicAuthPassword ? this : new HttpExecutionRequest(this.httpClient, this.method, this.url, this.basicAuthUsername, basicAuthPassword, this.entity, this.proxyUrl, this.bearerToken, this.maximumRetryAttempts, this.parameters, this.headers);
    }

    @Generated
    public HttpExecutionRequest withEntity(String entity) {
        return this.entity == entity ? this : new HttpExecutionRequest(this.httpClient, this.method, this.url, this.basicAuthUsername, this.basicAuthPassword, entity, this.proxyUrl, this.bearerToken, this.maximumRetryAttempts, this.parameters, this.headers);
    }

    @Generated
    public HttpExecutionRequest withProxyUrl(String proxyUrl) {
        return this.proxyUrl == proxyUrl ? this : new HttpExecutionRequest(this.httpClient, this.method, this.url, this.basicAuthUsername, this.basicAuthPassword, this.entity, proxyUrl, this.bearerToken, this.maximumRetryAttempts, this.parameters, this.headers);
    }

    @Generated
    public HttpExecutionRequest withBearerToken(String bearerToken) {
        return this.bearerToken == bearerToken ? this : new HttpExecutionRequest(this.httpClient, this.method, this.url, this.basicAuthUsername, this.basicAuthPassword, this.entity, this.proxyUrl, bearerToken, this.maximumRetryAttempts, this.parameters, this.headers);
    }

    @Generated
    public HttpExecutionRequest withMaximumRetryAttempts(int maximumRetryAttempts) {
        return this.maximumRetryAttempts == maximumRetryAttempts ? this : new HttpExecutionRequest(this.httpClient, this.method, this.url, this.basicAuthUsername, this.basicAuthPassword, this.entity, this.proxyUrl, this.bearerToken, maximumRetryAttempts, this.parameters, this.headers);
    }

    @Generated
    public HttpExecutionRequest withParameters(Map<String, String> parameters) {
        return this.parameters == parameters ? this : new HttpExecutionRequest(this.httpClient, this.method, this.url, this.basicAuthUsername, this.basicAuthPassword, this.entity, this.proxyUrl, this.bearerToken, this.maximumRetryAttempts, parameters, this.headers);
    }

    @Generated
    public HttpExecutionRequest withHeaders(Map<String, String> headers) {
        return this.headers == headers ? this : new HttpExecutionRequest(this.httpClient, this.method, this.url, this.basicAuthUsername, this.basicAuthPassword, this.entity, this.proxyUrl, this.bearerToken, this.maximumRetryAttempts, this.parameters, headers);
    }

    @Generated
    public HttpExecutionRequest(HttpClient httpClient, @NonNull HttpMethod method, @NonNull String url, String basicAuthUsername, String basicAuthPassword, String entity, String proxyUrl, String bearerToken, int maximumRetryAttempts, Map<String, String> parameters, Map<String, String> headers) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        this.httpClient = httpClient;
        this.method = method;
        this.url = url;
        this.basicAuthUsername = basicAuthUsername;
        this.basicAuthPassword = basicAuthPassword;
        this.entity = entity;
        this.proxyUrl = proxyUrl;
        this.bearerToken = bearerToken;
        this.maximumRetryAttempts = maximumRetryAttempts;
        this.parameters = parameters;
        this.headers = headers;
    }

    @Generated
    public static abstract class HttpExecutionRequestBuilder<C extends HttpExecutionRequest, B extends HttpExecutionRequestBuilder<C, B>> {
        @Generated
        private HttpClient httpClient;
        @Generated
        private HttpMethod method;
        @Generated
        private String url;
        @Generated
        private String basicAuthUsername;
        @Generated
        private String basicAuthPassword;
        @Generated
        private String entity;
        @Generated
        private String proxyUrl;
        @Generated
        private String bearerToken;
        @Generated
        private boolean maximumRetryAttempts$set;
        @Generated
        private int maximumRetryAttempts$value;
        @Generated
        private boolean parameters$set;
        @Generated
        private Map<String, String> parameters$value;
        @Generated
        private boolean headers$set;
        @Generated
        private Map<String, String> headers$value;

        @Generated
        public B httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this.self();
        }

        @Generated
        public B method(@NonNull HttpMethod method) {
            if (method == null) {
                throw new NullPointerException("method is marked non-null but is null");
            }
            this.method = method;
            return this.self();
        }

        @Generated
        public B url(@NonNull String url) {
            if (url == null) {
                throw new NullPointerException("url is marked non-null but is null");
            }
            this.url = url;
            return this.self();
        }

        @Generated
        public B basicAuthUsername(String basicAuthUsername) {
            this.basicAuthUsername = basicAuthUsername;
            return this.self();
        }

        @Generated
        public B basicAuthPassword(String basicAuthPassword) {
            this.basicAuthPassword = basicAuthPassword;
            return this.self();
        }

        @Generated
        public B entity(String entity) {
            this.entity = entity;
            return this.self();
        }

        @Generated
        public B proxyUrl(String proxyUrl) {
            this.proxyUrl = proxyUrl;
            return this.self();
        }

        @Generated
        public B bearerToken(String bearerToken) {
            this.bearerToken = bearerToken;
            return this.self();
        }

        @Generated
        public B maximumRetryAttempts(int maximumRetryAttempts) {
            this.maximumRetryAttempts$value = maximumRetryAttempts;
            this.maximumRetryAttempts$set = true;
            return this.self();
        }

        @Generated
        public B parameters(Map<String, String> parameters) {
            this.parameters$value = parameters;
            this.parameters$set = true;
            return this.self();
        }

        @Generated
        public B headers(Map<String, String> headers) {
            this.headers$value = headers;
            this.headers$set = true;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "HttpExecutionRequest.HttpExecutionRequestBuilder(httpClient=" + String.valueOf(this.httpClient) + ", method=" + String.valueOf(this.method) + ", url=" + this.url + ", basicAuthUsername=" + this.basicAuthUsername + ", basicAuthPassword=" + this.basicAuthPassword + ", entity=" + this.entity + ", proxyUrl=" + this.proxyUrl + ", bearerToken=" + this.bearerToken + ", maximumRetryAttempts$value=" + this.maximumRetryAttempts$value + ", parameters$value=" + String.valueOf(this.parameters$value) + ", headers$value=" + String.valueOf(this.headers$value) + ")";
        }
    }

    @Generated
    private static final class HttpExecutionRequestBuilderImpl
    extends HttpExecutionRequestBuilder<HttpExecutionRequest, HttpExecutionRequestBuilderImpl> {
        @Generated
        private HttpExecutionRequestBuilderImpl() {
        }

        @Override
        @Generated
        protected HttpExecutionRequestBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public HttpExecutionRequest build() {
            return new HttpExecutionRequest(this);
        }
    }
}

