/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.web.LocaleProperties;
import org.apereo.cas.configuration.model.support.delegation.DelegationAutoRedirectTypes;
import org.apereo.cas.web.DelegatedClientIdentityProviderConfiguration;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.WebContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriComponentsBuilder;

public class DelegatedClientIdentityProviderConfigurationFactory {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatedClientIdentityProviderConfigurationFactory.class);
    public static final String ENDPOINT_URL_REDIRECT = "clientredirect";
    private static final Pattern PAC4J_CLIENT_SUFFIX_PATTERN = Pattern.compile("Client\\d*");
    private final IndirectClient client;
    private final WebContext webContext;
    private final WebApplicationService service;
    private final CasConfigurationProperties casProperties;

    public Optional<DelegatedClientIdentityProviderConfiguration> resolve() {
        String name = this.client.getName();
        Matcher matcher = PAC4J_CLIENT_SUFFIX_PATTERN.matcher(this.client.getClass().getSimpleName());
        String type = matcher.replaceAll("").toLowerCase(Locale.ENGLISH);
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)ENDPOINT_URL_REDIRECT).queryParam("client_name", new Object[]{name});
        HashMap<String, String> queryParams = new HashMap<String, String>();
        LOGGER.trace("Request parameters are [{}]", (Object)this.webContext.getRequestParameters());
        if (this.service != null) {
            String sourceParam = this.service.getSource();
            String serviceParam = this.service.getOriginalUrl();
            LOGGER.debug("Processing service parameter [{}] with value [{}]", (Object)sourceParam, (Object)serviceParam);
            if (StringUtils.isNotBlank((CharSequence)sourceParam) && StringUtils.isNotBlank((CharSequence)serviceParam)) {
                uriBuilder.queryParam(sourceParam, new Object[]{"{service}"});
                queryParams.put("service", serviceParam);
            }
        }
        this.checkForMethodParameter(uriBuilder, queryParams);
        this.checkForLocalParameter(uriBuilder, queryParams);
        this.checkForThemeParameter(uriBuilder, queryParams);
        String redirectUrl = uriBuilder.build(queryParams).toString();
        LOGGER.trace("Final redirect url is [{}]", (Object)redirectUrl);
        DelegationAutoRedirectTypes autoRedirect = this.client.getCustomProperties().getOrDefault("autoRedirectType", DelegationAutoRedirectTypes.NONE);
        String title = this.client.getCustomProperties().getOrDefault("displayName", name);
        String cssClass = this.client.getCustomProperties().getOrDefault("cssClass", "");
        DelegatedClientIdentityProviderConfiguration providerConfig = DelegatedClientIdentityProviderConfiguration.builder().name(name).autoRedirectType(autoRedirect).redirectUrl(redirectUrl).type(type).title(title).cssClass(cssClass).build();
        return Optional.of(providerConfig);
    }

    protected void checkForThemeParameter(UriComponentsBuilder uriBuilder, Map<String, String> queryParams) {
        this.webContext.getRequestParameter(this.casProperties.getTheme().getParamName()).ifPresent(themeParam -> {
            LOGGER.trace("Processing theme parameter [{}] with value [{}]", (Object)this.casProperties.getTheme().getParamName(), themeParam);
            uriBuilder.queryParam(this.casProperties.getTheme().getParamName(), new Object[]{"{theme}"});
            queryParams.put("theme", (String)themeParam);
        });
    }

    protected void checkForLocalParameter(UriComponentsBuilder uriBuilder, Map<String, String> queryParams) {
        LocaleProperties localProps = this.casProperties.getLocale();
        LOGGER.trace("Processing locale parameter [{}]", (Object)localProps.getParamName());
        this.webContext.getRequestParameter(localProps.getParamName()).ifPresent(localeParam -> {
            LOGGER.debug("Processing locale parameter [{}] with value [{}]", (Object)localProps.getParamName(), localeParam);
            uriBuilder.queryParam(localProps.getParamName(), new Object[]{"{locale}"});
            queryParams.put("locale", (String)localeParam);
        });
    }

    protected void checkForMethodParameter(UriComponentsBuilder uriBuilder, Map<String, String> queryParams) {
        this.webContext.getRequestParameter("method").ifPresent(methodParam -> {
            LOGGER.trace("Processing method parameter [{}] with value [{}]", (Object)"method", methodParam);
            uriBuilder.queryParam("method", new Object[]{"{method}"});
            queryParams.put("method", (String)methodParam);
        });
    }

    @Generated
    protected DelegatedClientIdentityProviderConfigurationFactory(DelegatedClientIdentityProviderConfigurationFactoryBuilder<?, ?> b) {
        this.client = b.client;
        this.webContext = b.webContext;
        this.service = b.service;
        this.casProperties = b.casProperties;
    }

    @Generated
    public static DelegatedClientIdentityProviderConfigurationFactoryBuilder<?, ?> builder() {
        return new DelegatedClientIdentityProviderConfigurationFactoryBuilderImpl();
    }

    @Generated
    public static abstract class DelegatedClientIdentityProviderConfigurationFactoryBuilder<C extends DelegatedClientIdentityProviderConfigurationFactory, B extends DelegatedClientIdentityProviderConfigurationFactoryBuilder<C, B>> {
        @Generated
        private IndirectClient client;
        @Generated
        private WebContext webContext;
        @Generated
        private WebApplicationService service;
        @Generated
        private CasConfigurationProperties casProperties;

        @Generated
        public B client(IndirectClient client) {
            this.client = client;
            return this.self();
        }

        @Generated
        public B webContext(WebContext webContext) {
            this.webContext = webContext;
            return this.self();
        }

        @Generated
        public B service(WebApplicationService service) {
            this.service = service;
            return this.self();
        }

        @Generated
        public B casProperties(CasConfigurationProperties casProperties) {
            this.casProperties = casProperties;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "DelegatedClientIdentityProviderConfigurationFactory.DelegatedClientIdentityProviderConfigurationFactoryBuilder(client=" + String.valueOf(this.client) + ", webContext=" + String.valueOf(this.webContext) + ", service=" + String.valueOf(this.service) + ", casProperties=" + String.valueOf(this.casProperties) + ")";
        }
    }

    @Generated
    private static final class DelegatedClientIdentityProviderConfigurationFactoryBuilderImpl
    extends DelegatedClientIdentityProviderConfigurationFactoryBuilder<DelegatedClientIdentityProviderConfigurationFactory, DelegatedClientIdentityProviderConfigurationFactoryBuilderImpl> {
        @Generated
        private DelegatedClientIdentityProviderConfigurationFactoryBuilderImpl() {
        }

        @Override
        @Generated
        protected DelegatedClientIdentityProviderConfigurationFactoryBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DelegatedClientIdentityProviderConfigurationFactory build() {
            return new DelegatedClientIdentityProviderConfigurationFactory(this);
        }
    }
}

