/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.wicket.spring.boot.starter.configuration.extensions.core.settings.markup;

import com.giffing.wicket.spring.boot.context.extensions.ApplicationInitExtension;
import com.giffing.wicket.spring.boot.context.extensions.WicketApplicationInitConfiguration;
import com.giffing.wicket.spring.boot.context.extensions.boot.actuator.WicketAutoConfig;
import com.giffing.wicket.spring.boot.context.extensions.boot.actuator.WicketEndpointRepository;
import com.giffing.wicket.spring.boot.starter.configuration.extensions.core.settings.markup.MarkupSettingsProperties;
import lombok.Generated;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.settings.MarkupSettings;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

@ApplicationInitExtension
@EnableConfigurationProperties(value={MarkupSettingsProperties.class})
public class MarkupSettingsConfig
implements WicketApplicationInitConfiguration {
    private final MarkupSettingsProperties props;
    private final WicketEndpointRepository wicketEndpointRepository;

    public void init(WebApplication webApplication) {
        MarkupSettings markupSettings = webApplication.getMarkupSettings();
        if (this.props.getDefaultMarkupEncoding() != null) {
            markupSettings.setDefaultMarkupEncoding(this.props.getDefaultMarkupEncoding());
        }
        markupSettings.setAutomaticLinking(this.props.isAutomaticLinking());
        markupSettings.setCompressWhitespace(this.props.isCompressWhitespace());
        markupSettings.setStripComments(this.props.isStripComments());
        markupSettings.setStripWicketTags(this.props.isStripWicketTags());
        markupSettings.setThrowExceptionOnMissingXmlDeclaration(this.props.isThrowExceptionOnMissingXmlDeclaration());
        this.wicketEndpointRepository.add(new WicketAutoConfig.Builder(this.getClass()).withDetail("properties", (Object)this.props).build());
    }

    @Generated
    public MarkupSettingsConfig(MarkupSettingsProperties props, WicketEndpointRepository wicketEndpointRepository) {
        this.props = props;
        this.wicketEndpointRepository = wicketEndpointRepository;
    }
}

