/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.lib.batch;

import java.util.List;
import java.util.UUID;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.ClientConfiguration;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.syncope.client.lib.batch.BatchClientFactoryBean;
import org.apache.syncope.client.lib.batch.BatchResponse;
import org.apache.syncope.common.rest.api.Preference;
import org.apache.syncope.common.rest.api.RESTHeaders;
import org.apache.syncope.common.rest.api.batch.BatchPayloadGenerator;
import org.apache.syncope.common.rest.api.batch.BatchRequestItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchRequest {
    private static final Logger LOG = LoggerFactory.getLogger(BatchRequest.class);
    private final String jwt;
    private final String address;
    private final List<?> providers;
    private final TLSClientParameters tlsClientParameters;
    private BatchClientFactoryBean bcfb;

    public BatchRequest(String address, List<?> providers, String jwt, TLSClientParameters tlsClientParameters) {
        this.jwt = jwt;
        this.address = address;
        this.providers = providers;
        this.tlsClientParameters = tlsClientParameters;
        this.initBatchClientFactoryBean();
    }

    private void initBatchClientFactoryBean() {
        this.bcfb = new BatchClientFactoryBean();
        this.bcfb.setAddress(this.address);
        this.bcfb.setProviders(this.providers);
    }

    public <T> T getService(Class<T> serviceClass) {
        this.bcfb.setServiceClass(serviceClass);
        Object serviceInstance = this.bcfb.create(serviceClass, new Object[0]);
        Client client = WebClient.client((Object)serviceInstance);
        client.type("application/json").accept(new String[]{"application/json"});
        return (T)serviceInstance;
    }

    public List<BatchRequestItem> getItems() {
        return this.bcfb.getBatchRequestItems();
    }

    public BatchResponse commit() {
        return this.commit(false);
    }

    public BatchResponse commit(boolean async) {
        String boundary = "--batch_" + String.valueOf(UUID.randomUUID());
        WebClient webClient = WebClient.create((String)this.bcfb.getAddress()).path((Object)"batch").header("Authorization", new Object[]{"Bearer " + this.jwt}).type(RESTHeaders.multipartMixedWith((String)boundary.substring(2)));
        if (async) {
            webClient.header("Prefer", new Object[]{Preference.RESPOND_ASYNC});
        }
        if (this.tlsClientParameters != null) {
            ClientConfiguration config = WebClient.getConfig((Object)webClient);
            HTTPConduit httpConduit = (HTTPConduit)config.getConduit();
            httpConduit.setTlsClientParameters(this.tlsClientParameters);
        }
        String body = BatchPayloadGenerator.generate(this.bcfb.getBatchRequestItems(), (String)boundary);
        LOG.debug("Batch request body:\n{}", (Object)body);
        this.initBatchClientFactoryBean();
        return new BatchResponse(boundary, this.jwt, this.tlsClientParameters, webClient.post((Object)body));
    }
}

