/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.audit.spi.resource;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.model.core.audit.AuditEngineProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.util.DigestUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.inspektr.audit.spi.support.ReturnValueAsStringResourceResolver;
import org.aspectj.lang.JoinPoint;

public class ServiceAccessEnforcementAuditResourceResolver
extends ReturnValueAsStringResourceResolver {
    protected final AuthenticationServiceSelectionPlan serviceSelectionStrategy;
    protected final AuditEngineProperties properties;
    protected final PrincipalFactory defaultPrincipalFactory = PrincipalFactoryUtils.newPrincipalFactory();

    @Override
    public String[] resolveFrom(JoinPoint auditableTarget, Object returnValue) {
        Objects.requireNonNull(returnValue, "AuditableExecutionResult must not be null");
        AuditableExecutionResult serviceAccessCheckResult = (AuditableExecutionResult)returnValue;
        String accessCheckOutcome = "Service Access " + BooleanUtils.toString((boolean)serviceAccessCheckResult.isExecutionFailure(), (String)"Denied", (String)"Granted");
        HashMap<String, CallSite> values = new HashMap<String, CallSite>();
        values.put("result", (CallSite)((Object)accessCheckOutcome));
        serviceAccessCheckResult.getService().ifPresent(service -> values.put("service", (CallSite)((Object)this.getServiceId((Service)service))));
        serviceAccessCheckResult.getAuthentication().ifPresent(authn -> values.put("principal", (CallSite)this.determinePrincipal((Authentication)authn)));
        serviceAccessCheckResult.getRegisteredService().stream().map(RegisteredService::getAccessStrategy).filter(Objects::nonNull).filter(strategy -> !strategy.getRequiredAttributes().isEmpty()).findFirst().ifPresent(strategy -> values.put("requiredAttributes", (CallSite)((Object)strategy.getRequiredAttributes())));
        return new String[]{this.auditFormat.serialize(values)};
    }

    protected Principal determinePrincipal(Authentication authentication) {
        return (Principal)FunctionUtils.doUnchecked(() -> this.properties.isIncludeValidationAssertion() ? authentication.getPrincipal() : this.defaultPrincipalFactory.withoutAttributes(authentication.getPrincipal()));
    }

    protected String getServiceId(Service service) {
        String serviceId = (String)FunctionUtils.doUnchecked(() -> this.serviceSelectionStrategy.resolveService(service).getId());
        return DigestUtils.abbreviate((String)serviceId, (int)this.properties.getAbbreviationLength());
    }

    @Generated
    public ServiceAccessEnforcementAuditResourceResolver(AuthenticationServiceSelectionPlan serviceSelectionStrategy, AuditEngineProperties properties) {
        this.serviceSelectionStrategy = serviceSelectionStrategy;
        this.properties = properties;
    }
}

