/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.persondir;

import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apereo.cas.authentication.attribute.AttributeRepositoryQuery;
import org.apereo.cas.authentication.attribute.AttributeRepositoryResolver;
import org.apereo.cas.authentication.principal.RegisteredServicePrincipalAttributesRepository;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.multitenancy.TenantAuthenticationPolicy;
import org.apereo.cas.multitenancy.TenantDefinition;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.ServicesManager;
import org.springframework.util.StringUtils;

public class DefaultAttributeRepositoryResolver
implements AttributeRepositoryResolver {
    private final ServicesManager servicesManager;
    private final TenantExtractor tenantExtractor;
    private final CasConfigurationProperties casProperties;

    public Set<String> resolve(AttributeRepositoryQuery query) {
        TenantDefinition tenant;
        TenantAuthenticationPolicy authenticationPolicy;
        HashSet<String> repositoryIds = new HashSet<String>();
        if (StringUtils.hasText((String)query.getTenant()) && (authenticationPolicy = (tenant = (TenantDefinition)this.tenantExtractor.getTenantsManager().findTenant(query.getTenant()).orElseThrow()).getAuthenticationPolicy()) != null && authenticationPolicy.getAttributeRepositories() != null) {
            repositoryIds.addAll(authenticationPolicy.getAttributeRepositories());
        }
        this.determineRegisteredService(query).map(RegisteredService::getAttributeReleasePolicy).map(RegisteredServiceAttributeReleasePolicy::getPrincipalAttributesRepository).map(RegisteredServicePrincipalAttributesRepository::getAttributeRepositoryIds).filter(identifiers -> !identifiers.isEmpty()).ifPresentOrElse(repositoryIds::addAll, () -> {
            Map selectionMap = this.casProperties.getPersonDirectory().getAttributeRepositorySelection();
            if (Objects.nonNull(query.getAuthenticationHandler()) && selectionMap.containsKey(query.getAuthenticationHandler().getName())) {
                Set assignedRepositories = StringUtils.commaDelimitedListToSet((String)((String)selectionMap.get(query.getAuthenticationHandler().getName())));
                repositoryIds.addAll(assignedRepositories);
            } else if (Objects.nonNull(query.getActiveRepositoryIds())) {
                repositoryIds.addAll(query.getActiveRepositoryIds());
            }
        });
        if (repositoryIds.isEmpty()) {
            repositoryIds.add("*");
        }
        return repositoryIds;
    }

    protected Optional<RegisteredService> determineRegisteredService(AttributeRepositoryQuery query) {
        RegisteredService result = Optional.ofNullable(query.getService()).map(arg_0 -> ((ServicesManager)this.servicesManager).findServiceBy(arg_0)).orElseGet(() -> ((AttributeRepositoryQuery)query).getRegisteredService());
        return Optional.ofNullable(result);
    }

    @Generated
    public DefaultAttributeRepositoryResolver(ServicesManager servicesManager, TenantExtractor tenantExtractor, CasConfigurationProperties casProperties) {
        this.servicesManager = servicesManager;
        this.tenantExtractor = tenantExtractor;
        this.casProperties = casProperties;
    }

    @Generated
    public ServicesManager getServicesManager() {
        return this.servicesManager;
    }

    @Generated
    public TenantExtractor getTenantExtractor() {
        return this.tenantExtractor;
    }

    @Generated
    public CasConfigurationProperties getCasProperties() {
        return this.casProperties;
    }
}

