/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.flowable.task;

import org.apache.syncope.common.lib.AnyOperations;
import org.apache.syncope.common.lib.request.UserUR;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.core.flowable.task.FlowableServiceTask;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.data.UserDataBinder;
import org.flowable.engine.delegate.DelegateExecution;

public class AutoActivate
extends FlowableServiceTask {
    protected final UserDataBinder dataBinder;
    protected final UserDAO userDAO;

    public AutoActivate(UserDataBinder dataBinder, UserDAO userDAO) {
        this.dataBinder = dataBinder;
        this.userDAO = userDAO;
    }

    @Override
    protected void doExecute(DelegateExecution execution) {
        User user = (User)execution.getVariable("user", User.class);
        UserTO userTO = (UserTO)execution.getVariable("userTO", UserTO.class);
        if (userTO != null && userTO.getKey() != null && user.getKey() != null) {
            UserUR req = AnyOperations.diff((UserTO)userTO, (UserTO)this.dataBinder.getUserTO(user = (User)this.userDAO.save((Entity)user), true), (boolean)false);
            if (req.isEmpty()) {
                LOG.debug("Nothing to change, skip user update");
            } else {
                req.setPassword(null);
                this.dataBinder.update(user, req);
                execution.setVariable("user", (Object)user);
            }
        }
        execution.setVariable("propagateEnable", (Object)Boolean.TRUE);
    }
}

