/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.support.sms.GroovySmsProperties;
import org.apereo.cas.configuration.model.support.sms.RestfulSmsProperties;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.notifications.CommunicationsManager;
import org.apereo.cas.notifications.DefaultCommunicationsManager;
import org.apereo.cas.notifications.call.PhoneCallOperator;
import org.apereo.cas.notifications.mail.DefaultEmailSender;
import org.apereo.cas.notifications.mail.EmailSender;
import org.apereo.cas.notifications.mail.EmailSenderCustomizer;
import org.apereo.cas.notifications.push.DefaultNotificationSender;
import org.apereo.cas.notifications.push.NotificationSender;
import org.apereo.cas.notifications.push.NotificationSenderExecutionPlanConfigurer;
import org.apereo.cas.notifications.sms.GroovySmsSender;
import org.apereo.cas.notifications.sms.RestfulSmsSender;
import org.apereo.cas.notifications.sms.SmsSender;
import org.apereo.cas.util.http.HttpClient;
import org.apereo.cas.util.nativex.CasRuntimeHintsRegistrar;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.mail.MailProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.scheduling.annotation.EnableScheduling;

@EnableScheduling
@EnableConfigurationProperties(value={CasConfigurationProperties.class, MailProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.Notifications})
@AutoConfiguration
public class CasCoreNotificationsAutoConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasCoreNotificationsAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(name={"communicationsManager"})
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public CommunicationsManager communicationsManager(@Qualifier(value="tenantExtractor") TenantExtractor tenantExtractor, @Qualifier(value="smsSender") SmsSender smsSender, @Qualifier(value="emailSender") EmailSender emailSender, @Qualifier(value="phoneCallOperator") PhoneCallOperator phoneCallOperator, @Qualifier(value="notificationSender") NotificationSender notificationSender) {
        return new DefaultCommunicationsManager(smsSender, emailSender, notificationSender, phoneCallOperator, tenantExtractor);
    }

    @Bean
    @ConditionalOnMissingBean(name={"emailSender"})
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public EmailSender emailSender(ConfigurableApplicationContext applicationContext, ObjectProvider<List<EmailSenderCustomizer>> customizers, MailProperties mailProperties, ObjectProvider<SslBundles> sslBundles, @Qualifier(value="tenantExtractor") TenantExtractor tenantExtractor, @Qualifier(value="messageSource") MessageSource messageSource) {
        List<EmailSenderCustomizer> emailSenderCustomizers = Optional.ofNullable((List)customizers.getIfAvailable()).orElseGet(ArrayList::new).stream().filter(BeanSupplier::isNotProxy).sorted((Comparator<EmailSenderCustomizer>)AnnotationAwareOrderComparator.INSTANCE).toList();
        return new DefaultEmailSender(messageSource, (ApplicationContext)applicationContext, emailSenderCustomizers, mailProperties, sslBundles, tenantExtractor);
    }

    @Bean
    @ConditionalOnMissingBean(name={"phoneCallOperator"})
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public PhoneCallOperator phoneCallOperator(CasConfigurationProperties casProperties) {
        return PhoneCallOperator.noOp();
    }

    @Bean
    @ConditionalOnMissingBean(name={"smsSender"})
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public SmsSender smsSender(@Qualifier(value="supportsTrustStoreSslSocketFactoryHttpClient") HttpClient supportsTrustStoreSslSocketFactoryHttpClient, CasConfigurationProperties casProperties) {
        GroovySmsProperties groovy = casProperties.getSmsProvider().getGroovy();
        if (groovy.getLocation() != null && CasRuntimeHintsRegistrar.notInNativeImage()) {
            return new GroovySmsSender(groovy.getLocation());
        }
        RestfulSmsProperties rest = casProperties.getSmsProvider().getRest();
        if (StringUtils.isNotBlank((CharSequence)rest.getUrl())) {
            return new RestfulSmsSender(rest, supportsTrustStoreSslSocketFactoryHttpClient);
        }
        return SmsSender.noOp();
    }

    @Bean
    @ConditionalOnMissingBean(name={"notificationSender"})
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public NotificationSender notificationSender(ObjectProvider<List<NotificationSenderExecutionPlanConfigurer>> configurerProviders) {
        List configurers = Optional.ofNullable((List)configurerProviders.getIfAvailable()).orElseGet(ArrayList::new);
        List results = configurers.stream().map(cfg -> {
            LOGGER.trace("Configuring notification sender [{}]", (Object)cfg.getName());
            return cfg.configureNotificationSender();
        }).sorted(Comparator.comparing(NotificationSender::getOrder)).collect(Collectors.toList());
        return new DefaultNotificationSender(results);
    }
}

