/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.service;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.headers.Header;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.common.lib.to.SchemaTO;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.syncope.common.rest.api.beans.SchemaQuery;
import org.apache.syncope.common.rest.api.service.JAXRSService;

@Tag(name="Schemas")
@SecurityRequirements(value={@SecurityRequirement(name="BasicAuthentication"), @SecurityRequirement(name="Bearer")})
@Path(value="schemas")
public interface SchemaService
extends JAXRSService {
    @GET
    @Path(value="{type}")
    @Produces(value={"application/json"})
    public <T extends SchemaTO> List<T> search(@BeanParam SchemaQuery var1);

    @GET
    @Path(value="{type}/{key}")
    @Produces(value={"application/json"})
    public <T extends SchemaTO> T read(@NotNull @PathParam(value="type") SchemaType var1, @NotNull @PathParam(value="key") String var2);

    @ApiResponses(value={@ApiResponse(responseCode="201", description="Schema successfully created", headers={@Header(name="X-Syncope-Key", schema=@Schema(type="string"), description="Key value for the entity created"), @Header(name="Location", schema=@Schema(type="string"), description="URL of the entity created")})})
    @POST
    @Path(value="{type}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response create(@NotNull @PathParam(value="type") SchemaType var1, @NotNull SchemaTO var2);

    @Parameter(name="key", description="Schema's key", in=ParameterIn.PATH, schema=@Schema(type="string"))
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Operation was successful")})
    @PUT
    @Path(value="{type}/{key}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public void update(@NotNull @PathParam(value="type") SchemaType var1, @NotNull SchemaTO var2);

    @ApiResponses(value={@ApiResponse(responseCode="204", description="Operation was successful")})
    @DELETE
    @Path(value="{type}/{key}")
    @Produces(value={"application/json"})
    public void delete(@NotNull @PathParam(value="type") SchemaType var1, @NotNull @PathParam(value="key") String var2);

    @POST
    @Path(value="PLAIN/any/{key}/dropdownValues")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Attr getDropdownValues(@NotNull @PathParam(value="key") String var1, @NotNull AnyTO var2);

    @POST
    @Path(value="PLAIN/realm/{key}/dropdownValues")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Attr getDropdownValues(@NotNull @PathParam(value="key") String var1, @NotNull RealmTO var2);
}

