/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.principal;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.core5.net.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Service
extends Serializable {
    public static final String SERVICE_ATTRIBUTE_HTTP_REQUEST = "httpRequest";
    public static final String SERVICE_ATTRIBUTE_COOKIES = "cookies";
    public static final String SERVICE_ATTRIBUTE_HEADERS = "headers";
    public static final Logger LOGGER = LoggerFactory.getLogger(Service.class);

    default public void setPrincipal(String principal) {
    }

    public void setAttributes(Map<String, Object> var1);

    public String getOriginalUrl();

    public String getId();

    public String getTenant();

    public void setTenant(String var1);

    default public Map<String, Object> getAttributes() {
        return new LinkedHashMap<String, Object>();
    }

    default public <T> T getAttributeAs(String name, Class<T> clazz) {
        Object attribute = this.getAttributes().get(name);
        if (attribute == null) {
            return null;
        }
        if (!clazz.isAssignableFrom(attribute.getClass())) {
            throw new ClassCastException("Attribute " + name + "[" + String.valueOf(attribute) + " is of type " + String.valueOf(attribute.getClass()) + " when we were expecting " + String.valueOf(clazz));
        }
        return (T)attribute;
    }

    default public <T> T getFirstAttribute(String name, Class<T> clazz) {
        List values = this.getAttributeAs(name, List.class);
        return values == null || values.isEmpty() ? null : (T)clazz.cast(values.getFirst());
    }

    @JsonIgnore
    default public String getShortenedId() throws Exception {
        String lastSegment;
        URIBuilder urlBuilder = new URIBuilder(this.getId());
        Object serviceId = "";
        if (StringUtils.isNotBlank((CharSequence)urlBuilder.getScheme())) {
            serviceId = (String)serviceId + urlBuilder.getScheme().concat("://");
        }
        if (StringUtils.isNotBlank((CharSequence)urlBuilder.getHost())) {
            serviceId = (String)serviceId + urlBuilder.getHost();
        }
        if (urlBuilder.getPort() > 0) {
            serviceId = (String)serviceId + ":" + urlBuilder.getPort();
        }
        if (!urlBuilder.getPathSegments().isEmpty()) {
            serviceId = (String)serviceId + String.valueOf(StringUtils.isBlank((CharSequence)serviceId) ? "" : Character.valueOf('/')) + (String)urlBuilder.getPathSegments().getFirst();
        }
        if (urlBuilder.getPathSegments().size() >= 2) {
            serviceId = (String)serviceId + "/" + (String)urlBuilder.getPathSegments().get(1);
        }
        if (!urlBuilder.getPathSegments().isEmpty() && !((String)serviceId).contains(lastSegment = (String)urlBuilder.getPathSegments().getLast())) {
            serviceId = (String)serviceId + "/" + lastSegment;
        }
        return serviceId;
    }
}

