/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.procedure.internal;

import jakarta.persistence.ParameterMode;
import java.util.List;
import org.hibernate.QueryException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.procedure.internal.AbstractStandardCallableStatementSupport;
import org.hibernate.procedure.spi.FunctionReturnImplementor;
import org.hibernate.procedure.spi.ProcedureCallImplementor;
import org.hibernate.procedure.spi.ProcedureParameterImplementor;
import org.hibernate.query.spi.ProcedureParameterMetadataImplementor;
import org.hibernate.sql.exec.internal.JdbcCallImpl;
import org.hibernate.sql.exec.spi.JdbcCallParameterRegistration;
import org.hibernate.sql.exec.spi.JdbcOperationQueryCall;

public class SybaseCallableStatementSupport
extends AbstractStandardCallableStatementSupport {
    public static final SybaseCallableStatementSupport INSTANCE = new SybaseCallableStatementSupport();
    private static final String FUNCTION_SYNTAX_START = "select ";
    private static final String FUNCTION_SYNTAX_END = ") from (select 1) t1(c1)";
    private static final String CALL_SYNTAX_START = "{call ";
    private static final String CALL_SYNTAX_END = ")}";

    @Override
    public JdbcOperationQueryCall interpretCall(ProcedureCallImplementor<?> procedureCall) {
        StringBuilder buffer;
        int offset;
        String procedureName = procedureCall.getProcedureName();
        FunctionReturnImplementor functionReturn = procedureCall.getFunctionReturn();
        ProcedureParameterMetadataImplementor parameterMetadata = procedureCall.getParameterMetadata();
        List<ProcedureParameterImplementor<?>> registrations = parameterMetadata.getRegistrationsAsList();
        int paramStringSizeEstimate = functionReturn == null && parameterMetadata.hasNamedParameters() ? registrations.size() * 12 : registrations.size() * 2;
        JdbcCallImpl.Builder builder = new JdbcCallImpl.Builder();
        if (functionReturn != null) {
            offset = 1;
            buffer = new StringBuilder(FUNCTION_SYNTAX_START.length() + FUNCTION_SYNTAX_END.length() + procedureName.length() + paramStringSizeEstimate).append(FUNCTION_SYNTAX_START);
        } else {
            offset = 1;
            buffer = new StringBuilder(CALL_SYNTAX_START.length() + CALL_SYNTAX_END.length() + procedureName.length() + paramStringSizeEstimate).append(CALL_SYNTAX_START);
        }
        buffer.append(procedureName);
        if (registrations.isEmpty()) {
            buffer.append('(');
        } else {
            int sep = 40;
            for (int i = 0; i < registrations.size(); ++i) {
                ProcedureParameterImplementor<?> parameter = registrations.get(i);
                if (parameter.getMode() == ParameterMode.REF_CURSOR) {
                    throw new QueryException("Dialect [" + procedureCall.getSession().getJdbcServices().getJdbcEnvironment().getDialect().getClass().getName() + "] not known to support REF_CURSOR parameters");
                }
                buffer.append((char)sep);
                JdbcCallParameterRegistration registration = parameter.toJdbcParameterRegistration(i + offset, procedureCall);
                SharedSessionContractImplementor session = procedureCall.getSession();
                if (parameter.getName() != null && session.getJdbcServices().getExtractedMetaDataSupport().supportsNamedParameters() && session.getFactory().getSessionFactoryOptions().isPassProcedureParameterNames()) {
                    buffer.append("@").append(parameter.getName()).append(" = ?");
                } else {
                    buffer.append("?");
                }
                sep = 44;
                builder.addParameterRegistration(registration);
            }
        }
        if (functionReturn != null) {
            buffer.append(FUNCTION_SYNTAX_END);
        } else {
            buffer.append(CALL_SYNTAX_END);
        }
        builder.setCallableName(buffer.toString());
        return builder.buildJdbcCall();
    }
}

