/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.kendo.ui.form.combobox;

import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.wicketstuff.jquery.core.IJQueryWidget;
import org.wicketstuff.jquery.core.JQueryBehavior;
import org.wicketstuff.jquery.core.Options;
import org.wicketstuff.jquery.core.behavior.ChoiceModelBehavior;
import org.wicketstuff.jquery.core.event.ISelectionChangedListener;
import org.wicketstuff.jquery.core.event.SelectionChangedAdapter;
import org.wicketstuff.jquery.core.renderer.IChoiceRenderer;
import org.wicketstuff.jquery.core.renderer.ITextRenderer;
import org.wicketstuff.jquery.core.template.IJQueryTemplate;
import org.wicketstuff.kendo.ui.form.combobox.ComboBoxBehavior;
import org.wicketstuff.kendo.ui.renderer.ChoiceRenderer;
import org.wicketstuff.kendo.ui.template.KendoTemplateBehavior;

public class ComboBox<T>
extends TextField<String>
implements IJQueryWidget {
    private static final long serialVersionUID = 1L;
    private ComboBoxBehavior widgetBehavior = null;
    private final IModel<List<T>> choices;
    private ChoiceModelBehavior<T> choiceModelBehavior;
    private final IChoiceRenderer<? super T> renderer;
    private final IJQueryTemplate template;
    private KendoTemplateBehavior templateBehavior = null;
    private int width = 0;

    public ComboBox(String id, List<T> choices) {
        this(id, Model.ofList(choices), new ChoiceRenderer());
    }

    public ComboBox(String id, List<T> choices, IChoiceRenderer<? super T> renderer) {
        this(id, Model.ofList(choices), renderer);
    }

    public ComboBox(String id, IModel<List<T>> choices) {
        this(id, choices, new ChoiceRenderer());
    }

    public ComboBox(String id, IModel<List<T>> choices, IChoiceRenderer<? super T> renderer) {
        super(id);
        this.choices = choices;
        this.renderer = renderer;
        this.template = this.newTemplate();
    }

    public ComboBox(String id, IModel<String> model, List<T> choices) {
        this(id, model, Model.ofList(choices), new ChoiceRenderer());
    }

    public ComboBox(String id, IModel<String> model, List<T> choices, IChoiceRenderer<? super T> renderer) {
        this(id, model, Model.ofList(choices), renderer);
    }

    public ComboBox(String id, IModel<String> model, IModel<List<T>> choices) {
        this(id, model, choices, new ChoiceRenderer());
    }

    public ComboBox(String id, IModel<String> model, IModel<List<T>> choices, IChoiceRenderer<? super T> renderer) {
        super(id, model);
        this.choices = choices;
        this.renderer = renderer;
        this.template = this.newTemplate();
    }

    protected CharSequence getCallbackUrl() {
        return this.choiceModelBehavior.getCallbackUrl();
    }

    public String getTemplateToken() {
        if (this.templateBehavior != null) {
            return this.templateBehavior.getToken();
        }
        return null;
    }

    public int getListWidth() {
        return this.width;
    }

    public ComboBox<?> setListWidth(int width) {
        this.width = width;
        return this;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.choiceModelBehavior = this.newChoiceModelBehavior();
        this.add(new Behavior[]{this.choiceModelBehavior});
        this.widgetBehavior = (ComboBoxBehavior)IJQueryWidget.JQueryWidget.newWidgetBehavior((Component)this);
        this.add(new Behavior[]{this.widgetBehavior});
        if (this.template != null) {
            this.templateBehavior = new KendoTemplateBehavior(this.template);
            this.add(new Behavior[]{this.templateBehavior});
        }
    }

    public void onConfigure(JQueryBehavior behavior) {
        behavior.setOption("dataTextField", (Object)Options.asString((String)this.renderer.getTextField()));
        behavior.setOption("dataValueField", (Object)Options.asString((String)this.renderer.getValueField()));
        if (this.templateBehavior != null) {
            behavior.setOption("template", (Object)String.format("jQuery('#%s').html()", this.getTemplateToken()));
        }
        if (this.getListWidth() > 0) {
            behavior.setOption("open", (Object)String.format("function(e) { e.sender.list.width(%d); }", this.getListWidth()));
        }
    }

    public void onBeforeRender(JQueryBehavior behavior) {
    }

    public JQueryBehavior newWidgetBehavior(String selector) {
        return new ComboBoxBehavior(selector, (ISelectionChangedListener)new SelectionChangedAdapter()){
            private static final long serialVersionUID = 1L;

            @Override
            protected CharSequence getDataSourceUrl() {
                return ComboBox.this.getCallbackUrl();
            }
        };
    }

    protected IJQueryTemplate newTemplate() {
        return null;
    }

    protected ChoiceModelBehavior<T> newChoiceModelBehavior() {
        return new ChoiceModelBehavior<T>((ITextRenderer)this.renderer, this.template){
            private static final long serialVersionUID = 1L;

            public List<T> getChoices() {
                return (List)ComboBox.this.choices.getObject();
            }
        };
    }
}

