/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.schema;

import org.ldaptive.ConnectionFactory;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResponse;

public final class SchemaUtils {
    private SchemaUtils() {
    }

    public static String[] parseDescriptors(String descrs) {
        if (descrs.contains("'")) {
            String[] quotedDescr = descrs.split(" ");
            String[] s = new String[quotedDescr.length];
            for (int i = 0; i < s.length; ++i) {
                s[i] = quotedDescr[i].substring(1, quotedDescr[i].length() - 1).trim();
            }
            return s;
        }
        return new String[]{descrs};
    }

    public static String[] parseOIDs(String oids) {
        if (oids.contains("$")) {
            String[] s = oids.split("\\$");
            for (int i = 0; i < s.length; ++i) {
                s[i] = s[i].trim();
            }
            return s;
        }
        return new String[]{oids};
    }

    public static int[] parseNumbers(String numbers) {
        String[] s = numbers.split(" ");
        int[] i = new int[s.length];
        for (int j = 0; j < i.length; ++j) {
            i[j] = Integer.parseInt(s[j].trim());
        }
        return i;
    }

    public static String formatDescriptors(String ... descrs) {
        StringBuilder sb = new StringBuilder();
        if (descrs.length == 1) {
            sb.append("'").append(descrs[0].replace("'", "\\27")).append("' ");
        } else {
            sb.append("( ");
            for (String descr : descrs) {
                sb.append("'").append(descr.replace("'", "\\27")).append("' ");
            }
            sb.append(") ");
        }
        return sb.toString();
    }

    public static String formatOids(String ... oids) {
        StringBuilder sb = new StringBuilder();
        if (oids.length == 1) {
            sb.append(oids[0]).append(" ");
        } else {
            sb.append("( ");
            for (int i = 0; i < oids.length; ++i) {
                sb.append(oids[i]);
                if (i < oids.length - 1) {
                    sb.append(" $ ");
                    continue;
                }
                sb.append(" ");
            }
            sb.append(") ");
        }
        return sb.toString();
    }

    public static String formatNumbers(int ... numbers) {
        StringBuilder sb = new StringBuilder();
        if (numbers.length == 1) {
            sb.append(numbers[0]).append(" ");
        } else {
            sb.append("( ");
            for (int number : numbers) {
                sb.append(number).append(" ");
            }
            sb.append(") ");
        }
        return sb.toString();
    }

    public static LdapEntry getLdapEntry(ConnectionFactory factory, String dn, String filter, String ... retAttrs) throws LdapException {
        SearchOperation search = new SearchOperation(factory);
        SearchResponse result = search.execute(SearchRequest.objectScopeSearchRequest(dn, retAttrs, filter));
        if (!result.isSuccess()) {
            throw new LdapException("Unsuccessful search for schema: " + String.valueOf(result));
        }
        return result.getEntry();
    }
}

