/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.commons.SortableDataProviderComparator;
import org.apache.syncope.client.console.layout.UserFormLayoutInfo;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.rest.AnyTypeRestClient;
import org.apache.syncope.client.console.rest.ImplementationRestClient;
import org.apache.syncope.client.console.rest.OIDCProviderRestClient;
import org.apache.syncope.client.console.rest.UserRestClient;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.KeyPropertyColumn;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLinksTogglePanel;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wizards.OIDCProviderWizardBuilder;
import org.apache.syncope.client.console.wizards.WizardMgtPanel;
import org.apache.syncope.client.console.wizards.any.UserTemplateWizardBuilder;
import org.apache.syncope.client.ui.commons.panels.ModalPanel;
import org.apache.syncope.client.ui.commons.panels.WizardModalPanel;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.client.ui.commons.wizards.ModalPanelBuilder;
import org.apache.syncope.client.ui.commons.wizards.any.AnyWrapper;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.OIDCC4UIProviderTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class OIDCProvidersDirectoryPanel
extends DirectoryPanel<OIDCC4UIProviderTO, OIDCC4UIProviderTO, OIDCProvidersProvider, OIDCProviderRestClient> {
    private static final long serialVersionUID = -1356497878858616714L;
    protected static final String PREF_OIDC_PROVIDERS_PAGINATOR_ROWS = "oidc.providers.paginator.rows";
    @SpringBean
    protected AnyTypeRestClient anyTypeRestClient;
    @SpringBean
    protected UserRestClient userRestClient;
    @SpringBean
    protected ImplementationRestClient implementationRestClient;
    private final BaseModal<Serializable> templateModal;

    public OIDCProvidersDirectoryPanel(String id, OIDCProviderRestClient restClient, PageReference pageRef) {
        super(id, new DirectoryPanel.Builder<OIDCC4UIProviderTO, OIDCC4UIProviderTO, OIDCProviderRestClient>(restClient, pageRef){
            private static final long serialVersionUID = -5542535388772406165L;

            protected WizardMgtPanel<OIDCC4UIProviderTO> newInstance(String id, boolean wizardInModal) {
                throw new UnsupportedOperationException();
            }
        }.disableCheckBoxes());
        this.addNewItemPanelBuilder((ModalPanelBuilder)new OIDCProviderWizardBuilder(this, new OIDCC4UIProviderTO(), this.implementationRestClient, restClient, pageRef), true);
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.addAjaxLink, (Action)RENDER, (String)"OP_CREATE");
        this.modal.size(Modal.Size.Large);
        this.templateModal = new BaseModal<Serializable>("outer"){
            private static final long serialVersionUID = 5787433530654262016L;

            protected void onConfigure() {
                super.onConfigure();
                this.setFooterVisible(false);
            }
        };
        this.setWindowClosedReloadCallback(this.templateModal);
        this.templateModal.size(Modal.Size.Large);
        this.addOuterObject(new Component[]{this.templateModal});
        this.initResultTable();
    }

    protected OIDCProvidersProvider dataProvider() {
        return new OIDCProvidersProvider(this.rows);
    }

    protected ActionLinksTogglePanel<OIDCC4UIProviderTO> actionTogglePanel() {
        return new ActionLinksTogglePanel<OIDCC4UIProviderTO>("outer", this.pageRef){
            private static final long serialVersionUID = -7688359318035249200L;

            public void updateHeader(AjaxRequestTarget target, Serializable object) {
                if (object instanceof OIDCC4UIProviderTO) {
                    OIDCC4UIProviderTO provider = (OIDCC4UIProviderTO)object;
                    this.setHeader(target, StringUtils.abbreviate((String)provider.getName(), (int)25));
                } else {
                    super.updateHeader(target, object);
                }
            }
        };
    }

    protected String paginatorRowsKey() {
        return PREF_OIDC_PROVIDERS_PAGINATOR_ROWS;
    }

    protected List<IColumn<OIDCC4UIProviderTO, String>> getColumns() {
        ArrayList<IColumn<OIDCC4UIProviderTO, String>> columns = new ArrayList<IColumn<OIDCC4UIProviderTO, String>>();
        columns.add((IColumn<OIDCC4UIProviderTO, String>)new KeyPropertyColumn((IModel)new ResourceModel("key"), "key", "key"));
        columns.add((IColumn<OIDCC4UIProviderTO, String>)new PropertyColumn((IModel)new ResourceModel("name"), (Object)"name", "name"));
        columns.add((IColumn<OIDCC4UIProviderTO, String>)new PropertyColumn((IModel)new ResourceModel("issuer"), (Object)"issuer", "issuer"));
        columns.add((IColumn<OIDCC4UIProviderTO, String>)new PropertyColumn((IModel)new ResourceModel("clientID"), (Object)"clientID", "clientID"));
        return columns;
    }

    protected Collection<ActionLink.ActionType> getBatches() {
        return List.of();
    }

    public ActionsPanel<OIDCC4UIProviderTO> getActions(final IModel<OIDCC4UIProviderTO> model) {
        ActionsPanel panel = super.getActions(model);
        panel.add((ActionLink)new ActionLink<OIDCC4UIProviderTO>(this){
            private static final long serialVersionUID = -3722207913631435501L;
            final /* synthetic */ OIDCProvidersDirectoryPanel this$0;
            {
                this.this$0 = this$0;
            }

            public void onClick(AjaxRequestTarget target, OIDCC4UIProviderTO ignore) {
                OIDCC4UIProviderTO object = ((OIDCProviderRestClient)this.this$0.restClient).read(((OIDCC4UIProviderTO)model.getObject()).getKey());
                this.this$0.send((IEventSink)this.this$0, Broadcast.EXACT, new AjaxWizard.EditItemActionEvent((Serializable)object, target));
                this.this$0.modal.header((IModel)Model.of((Serializable)((Object)StringUtils.capitalize((String)("Edit " + object.getName())))));
            }
        }, ActionLink.ActionType.EDIT, "OP_UPDATE");
        panel.add((ActionLink)new ActionLink<OIDCC4UIProviderTO>(this){
            private static final long serialVersionUID = 8557679125857348178L;
            final /* synthetic */ OIDCProvidersDirectoryPanel this$0;
            {
                this.this$0 = this$0;
            }

            public void onClick(AjaxRequestTarget target, OIDCC4UIProviderTO ignore) {
                final OIDCC4UIProviderTO object = ((OIDCProviderRestClient)this.this$0.restClient).read(((OIDCC4UIProviderTO)model.getObject()).getKey());
                UserTemplateWizardBuilder builder = new UserTemplateWizardBuilder(this, object.getUserTemplate(), this.this$0.anyTypeRestClient.read(AnyTypeKind.USER.name()).getClasses(), new UserFormLayoutInfo(), this.this$0.userRestClient, this.this$0.pageRef){
                    private static final long serialVersionUID = -7978723352517770634L;
                    final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = this$1;
                        super(template, anyTypeClasses, formLayoutInfo, userRestClient, pageRef);
                    }

                    protected Serializable onApplyInternal(AnyWrapper<UserTO> modelObject) {
                        object.setUserTemplate((UserTO)modelObject.getInnerObject());
                        ((OIDCProviderRestClient)this.this$1.this$0.restClient).update(object);
                        return modelObject;
                    }
                };
                this.this$0.templateModal.header((IModel)Model.of((Serializable)((Object)StringUtils.capitalize((String)new StringResourceModel("template.title", (Component)this.this$0).getString()))));
                this.this$0.templateModal.setContent((ModalPanel)builder.build("content"));
                this.this$0.templateModal.show(true);
                target.add(new Component[]{this.this$0.templateModal});
            }
        }, ActionLink.ActionType.TEMPLATE, "OP_UPDATE");
        panel.add((ActionLink)new ActionLink<OIDCC4UIProviderTO>(this){
            private static final long serialVersionUID = -5467832321897812767L;
            final /* synthetic */ OIDCProvidersDirectoryPanel this$0;
            {
                this.this$0 = this$0;
            }

            public void onClick(AjaxRequestTarget target, OIDCC4UIProviderTO ignore) {
                try {
                    ((OIDCProviderRestClient)this.this$0.restClient).delete(((OIDCC4UIProviderTO)model.getObject()).getKey());
                    SyncopeConsoleSession.get().success((Serializable)((Object)this.this$0.getString("operation_succeeded")));
                    target.add(new Component[]{this.this$0.container});
                }
                catch (SyncopeClientException e) {
                    DirectoryPanel.LOG.error("While deleting object {}", (Object)((OIDCC4UIProviderTO)model.getObject()).getKey(), (Object)e);
                    SyncopeConsoleSession.get().onException((Exception)((Object)e));
                }
                ((BasePage)this.this$0.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, "OP_DELETE", true);
        return panel;
    }

    public void onEvent(IEvent<?> event) {
        super.onEvent(event);
        Object object = event.getPayload();
        if (object instanceof AjaxWizard.NewItemEvent) {
            AjaxWizard.NewItemEvent newItemEvent = (AjaxWizard.NewItemEvent)object;
            WizardModalPanel modalPanel = newItemEvent.getModalPanel();
            if (newItemEvent instanceof AjaxWizard.NewItemActionEvent && modalPanel != null) {
                CompoundPropertyModel model = new CompoundPropertyModel((Object)modalPanel.getItem());
                this.templateModal.setFormModel((IModel)model);
                this.templateModal.header(newItemEvent.getTitleModel());
                newItemEvent.getTarget().ifPresent(target -> target.add(new Component[]{this.templateModal.setContent((ModalPanel)modalPanel)}));
                this.templateModal.show(true);
            } else if (newItemEvent instanceof AjaxWizard.NewItemCancelEvent) {
                newItemEvent.getTarget().ifPresent(arg_0 -> this.templateModal.close(arg_0));
            } else if (newItemEvent instanceof AjaxWizard.NewItemFinishEvent) {
                newItemEvent.getTarget().ifPresent(arg_0 -> this.templateModal.close(arg_0));
            }
        }
    }

    protected final class OIDCProvidersProvider
    extends DirectoryDataProvider<OIDCC4UIProviderTO> {
        private static final long serialVersionUID = -2865055116864423761L;
        private final SortableDataProviderComparator<OIDCC4UIProviderTO> comparator;

        public OIDCProvidersProvider(int paginatorRows) {
            super(paginatorRows);
            this.setSort("name", SortOrder.ASCENDING);
            this.comparator = new SortableDataProviderComparator((SortableDataProvider)this);
        }

        public Iterator<OIDCC4UIProviderTO> iterator(long first, long count) {
            List<OIDCC4UIProviderTO> list = ((OIDCProviderRestClient)OIDCProvidersDirectoryPanel.this.restClient).list();
            list.sort((Comparator<OIDCC4UIProviderTO>)this.comparator);
            return list.subList((int)first, (int)first + (int)count).iterator();
        }

        public long size() {
            return ((OIDCProviderRestClient)OIDCProvidersDirectoryPanel.this.restClient).list().size();
        }

        public IModel<OIDCC4UIProviderTO> model(OIDCC4UIProviderTO object) {
            return new CompoundPropertyModel((Object)object);
        }
    }
}

