/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.tasks;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeWebApplication;
import org.apache.syncope.client.console.commons.RealmsUtils;
import org.apache.syncope.client.console.rest.RealmRestClient;
import org.apache.syncope.client.console.rest.TaskRestClient;
import org.apache.syncope.client.console.tasks.CrontabPanel;
import org.apache.syncope.client.console.tasks.PushTaskFilters;
import org.apache.syncope.client.console.tasks.PushTaskWrapper;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxSearchFieldPanel;
import org.apache.syncope.client.console.wizards.BaseAjaxWizardBuilder;
import org.apache.syncope.client.ui.commons.ajax.form.IndicatorAjaxFormComponentUpdatingBehavior;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxNumberFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxPalettePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.FieldPanel;
import org.apache.syncope.common.lib.to.InboundTaskTO;
import org.apache.syncope.common.lib.to.LiveSyncTaskTO;
import org.apache.syncope.common.lib.to.MacroTaskTO;
import org.apache.syncope.common.lib.to.ProvisioningTaskTO;
import org.apache.syncope.common.lib.to.PullTaskTO;
import org.apache.syncope.common.lib.to.PushTaskTO;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.common.lib.to.SchedTaskTO;
import org.apache.syncope.common.lib.types.MatchingRule;
import org.apache.syncope.common.lib.types.PullMode;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.common.lib.types.ThreadPoolSettings;
import org.apache.syncope.common.lib.types.UnmatchingRule;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteSettings;
import org.apache.wicket.extensions.wizard.IWizardStep;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.util.ListModel;
import org.springframework.beans.PropertyAccessorFactory;

public class SchedTaskWizardBuilder<T extends SchedTaskTO>
extends BaseAjaxWizardBuilder<T> {
    private static final long serialVersionUID = 5945391813567245081L;
    protected final TaskType type;
    protected final RealmRestClient realmRestClient;
    protected final TaskRestClient taskRestClient;
    protected PushTaskWrapper wrapper;
    protected CrontabPanel crontabPanel;
    protected final boolean fullRealmsTree;

    public SchedTaskWizardBuilder(TaskType type, T taskTO, RealmRestClient realmRestClient, TaskRestClient taskRestClient, PageReference pageRef) {
        super(taskTO, pageRef);
        this.type = type;
        this.realmRestClient = realmRestClient;
        this.taskRestClient = taskRestClient;
        this.fullRealmsTree = SyncopeWebApplication.get().fullRealmsTree(realmRestClient);
    }

    protected Serializable onApplyInternal(SchedTaskTO modelObject) {
        if (modelObject instanceof PushTaskTO && this.wrapper != null) {
            this.wrapper.fillFilterConditions();
        }
        Optional.ofNullable(this.crontabPanel).ifPresent(cp -> modelObject.setCronExpression(cp.getCronExpression()));
        if (modelObject.getKey() == null) {
            this.taskRestClient.create(this.type, modelObject);
        } else {
            this.taskRestClient.update(this.type, modelObject);
        }
        return modelObject;
    }

    protected WizardModel buildModelSteps(SchedTaskTO modelObject, WizardModel wizardModel) {
        wizardModel.add((IWizardStep)new Profile(modelObject));
        if (modelObject instanceof PushTaskTO) {
            PushTaskTO pushTask = (PushTaskTO)modelObject;
            this.wrapper = new PushTaskWrapper(pushTask);
            wizardModel.add((IWizardStep)new PushTaskFilters(this.wrapper, this.pageRef));
        }
        if (!(modelObject instanceof LiveSyncTaskTO)) {
            wizardModel.add((IWizardStep)new Schedule(modelObject));
        }
        return wizardModel;
    }

    protected List<String> searchRealms(String realmQuery) {
        return this.realmRestClient.search(this.fullRealmsTree ? RealmsUtils.buildBaseQuery() : RealmsUtils.buildKeywordQuery(realmQuery)).getResult().stream().map(RealmTO::getFullPath).collect(Collectors.toList());
    }

    protected class Profile
    extends WizardStep {
        private static final long serialVersionUID = -3043839139187792810L;
        protected final IModel<List<String>> taskJobDelegates = SyncopeWebApplication.get().getImplementationInfoProvider().getTaskJobDelegates();
        protected final IModel<List<String>> reconFilterBuilders = SyncopeWebApplication.get().getImplementationInfoProvider().getReconFilterBuilders();
        protected final IModel<List<String>> liveSyncDeltaMappers = SyncopeWebApplication.get().getImplementationInfoProvider().getLiveSyncDeltaMappers();
        protected final IModel<List<String>> macroActions = SyncopeWebApplication.get().getImplementationInfoProvider().getMacroActions();
        protected final IModel<List<String>> inboundActions = SyncopeWebApplication.get().getImplementationInfoProvider().getInboundActions();
        protected final IModel<List<String>> pushActions = SyncopeWebApplication.get().getImplementationInfoProvider().getPushActions();

        protected Profile(SchedTaskTO taskTO) {
            AjaxTextFieldPanel name = new AjaxTextFieldPanel("name", "name", (IModel)new PropertyModel((Object)taskTO, "name"), false);
            name.addRequiredLabel();
            name.setEnabled(true);
            this.add(new Component[]{name});
            AjaxTextFieldPanel description = new AjaxTextFieldPanel("description", "description", (IModel)new PropertyModel((Object)taskTO, "description"), false);
            description.setEnabled(true);
            this.add(new Component[]{description});
            AjaxCheckBoxPanel active = new AjaxCheckBoxPanel("active", "active", (IModel)new PropertyModel((Object)taskTO, "active"), false);
            this.add(new Component[]{active});
            AjaxDropDownChoicePanel jobDelegate = new AjaxDropDownChoicePanel("jobDelegate", "jobDelegate", (IModel)new PropertyModel((Object)taskTO, "jobDelegate"), false);
            jobDelegate.setChoices((List)this.taskJobDelegates.getObject());
            jobDelegate.addRequiredLabel();
            jobDelegate.setEnabled(taskTO.getKey() == null);
            this.add(new Component[]{jobDelegate});
            AutoCompleteSettings settings = new AutoCompleteSettings();
            settings.setShowCompleteListOnFocusGain(SchedTaskWizardBuilder.this.fullRealmsTree);
            settings.setShowListOnEmptyInput(SchedTaskWizardBuilder.this.fullRealmsTree);
            WebMarkupContainer macroTaskSpecifics = new WebMarkupContainer("macroTaskSpecifics");
            this.add(new Component[]{macroTaskSpecifics.setRenderBodyOnly(true)});
            AjaxSearchFieldPanel realm = new AjaxSearchFieldPanel("realm", "realm", (IModel)new PropertyModel((Object)taskTO, "realm"), settings){
                private static final long serialVersionUID = -6390474600233486704L;

                @Override
                protected Iterator<String> getChoices(String input) {
                    return (RealmsUtils.checkInput(input) ? SchedTaskWizardBuilder.this.searchRealms(input) : List.of()).iterator();
                }
            };
            if (taskTO instanceof MacroTaskTO) {
                MacroTaskTO macroTask = (MacroTaskTO)taskTO;
                realm.addRequiredLabel();
                if (StringUtils.isBlank((CharSequence)macroTask.getRealm())) {
                    realm.setModelObject((Serializable)((Object)"/"));
                }
            }
            macroTaskSpecifics.add(new Component[]{realm});
            macroTaskSpecifics.add(new Component[]{new AjaxDropDownChoicePanel("macroActions", "macroActions", (IModel)new PropertyModel((Object)taskTO, "macroActions"), false).setChoices(this.macroActions)});
            AjaxCheckBoxPanel continueOnError = new AjaxCheckBoxPanel("continueOnError", "continueOnError", (IModel)new PropertyModel((Object)taskTO, "continueOnError"), false);
            macroTaskSpecifics.add(new Component[]{continueOnError});
            AjaxCheckBoxPanel saveExecs = new AjaxCheckBoxPanel("saveExecs", "saveExecs", (IModel)new PropertyModel((Object)taskTO, "saveExecs"), false);
            macroTaskSpecifics.add(new Component[]{saveExecs});
            WebMarkupContainer liveSyncTaskSpecifics = new WebMarkupContainer("liveSyncTaskSpecifics");
            this.add(new Component[]{liveSyncTaskSpecifics.setRenderBodyOnly(true)});
            boolean isMapped = false;
            if (taskTO instanceof LiveSyncTaskTO) {
                isMapped = true;
            } else {
                liveSyncTaskSpecifics.setEnabled(false).setVisible(false);
            }
            liveSyncTaskSpecifics.add(new Component[]{this.destinationRealm("liveSyncDestinationRealm", taskTO, settings)});
            liveSyncTaskSpecifics.add(new Component[]{this.remediation("liveSyncRemediation", taskTO)});
            liveSyncTaskSpecifics.add(new Component[]{new AjaxNumberFieldPanel.Builder().min((Number)1).build("liveSyncDelaySecondsAcrossInvocations", "liveSyncDelaySecondsAcrossInvocations", Integer.class, (IModel)new PropertyModel((Object)taskTO, "delaySecondsAcrossInvocations"))});
            AjaxDropDownChoicePanel liveSyncDeltaMapper = new AjaxDropDownChoicePanel("liveSyncDeltaMapper", "liveSyncDeltaMapper", (IModel)new PropertyModel((Object)taskTO, "liveSyncDeltaMapper"), false);
            liveSyncDeltaMapper.setChoices((List)this.liveSyncDeltaMappers.getObject());
            liveSyncDeltaMapper.setEnabled(isMapped);
            liveSyncDeltaMapper.setRequired(isMapped);
            liveSyncTaskSpecifics.add(new Component[]{liveSyncDeltaMapper});
            WebMarkupContainer pullTaskSpecifics = new WebMarkupContainer("pullTaskSpecifics");
            this.add(new Component[]{pullTaskSpecifics.setRenderBodyOnly(true)});
            boolean isFiltered = false;
            if (taskTO instanceof PullTaskTO) {
                PullTaskTO pullTask = (PullTaskTO)taskTO;
                isFiltered = pullTask.getPullMode() == PullMode.FILTERED_RECONCILIATION;
            } else {
                pullTaskSpecifics.setEnabled(false).setVisible(false);
            }
            final AjaxDropDownChoicePanel pullMode = new AjaxDropDownChoicePanel("pullMode", "pullMode", (IModel)new PropertyModel((Object)taskTO, "pullMode"), false);
            pullMode.setChoices(List.of(PullMode.values()));
            if (taskTO instanceof PullTaskTO) {
                pullMode.addRequiredLabel();
            }
            pullMode.setNullValid(!(taskTO instanceof PullTaskTO));
            pullTaskSpecifics.add(new Component[]{pullMode});
            final AjaxDropDownChoicePanel reconFilterBuilder = new AjaxDropDownChoicePanel("reconFilterBuilder", "reconFilterBuilder", (IModel)new PropertyModel((Object)taskTO, "reconFilterBuilder"), false);
            reconFilterBuilder.setChoices((List)this.reconFilterBuilders.getObject());
            reconFilterBuilder.setEnabled(isFiltered);
            reconFilterBuilder.setRequired(isFiltered);
            pullTaskSpecifics.add(new Component[]{reconFilterBuilder});
            pullMode.getField().add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior(this, "change"){
                private static final long serialVersionUID = -1107858522700306810L;
                final /* synthetic */ Profile this$1;
                {
                    this.this$1 = this$1;
                    super(event);
                }

                protected void onUpdate(AjaxRequestTarget target) {
                    reconFilterBuilder.setEnabled(pullMode.getModelObject() == PullMode.FILTERED_RECONCILIATION);
                    reconFilterBuilder.setRequired(pullMode.getModelObject() == PullMode.FILTERED_RECONCILIATION);
                    target.add(new Component[]{reconFilterBuilder});
                }
            }});
            pullTaskSpecifics.add(new Component[]{this.destinationRealm("pullDestinationRealm", taskTO, settings)});
            pullTaskSpecifics.add(new Component[]{this.remediation("pullRemediation", taskTO)});
            WebMarkupContainer pushTaskSpecifics = new WebMarkupContainer("pushTaskSpecifics");
            this.add(new Component[]{pushTaskSpecifics.setRenderBodyOnly(true)});
            if (!(taskTO instanceof PushTaskTO)) {
                pushTaskSpecifics.setEnabled(false).setVisible(false);
            }
            AjaxSearchFieldPanel sourceRealm = new AjaxSearchFieldPanel("sourceRealm", "sourceRealm", (IModel)new PropertyModel((Object)taskTO, "sourceRealm"), settings){
                private static final long serialVersionUID = -6390474600233486704L;

                @Override
                protected Iterator<String> getChoices(String input) {
                    return (RealmsUtils.checkInput(input) ? SchedTaskWizardBuilder.this.searchRealms(input) : List.of()).iterator();
                }
            };
            if (taskTO instanceof PushTaskTO) {
                sourceRealm.addRequiredLabel();
            }
            pushTaskSpecifics.add(new Component[]{sourceRealm});
            final WebMarkupContainer provisioningTaskSpecifics = new WebMarkupContainer("provisioningTaskSpecifics");
            this.add(new Component[]{provisioningTaskSpecifics.setOutputMarkupId(true)});
            if (taskTO instanceof ProvisioningTaskTO) {
                jobDelegate.setEnabled(false).setVisible(false);
                macroTaskSpecifics.setEnabled(false).setVisible(false);
            } else if (taskTO instanceof MacroTaskTO) {
                jobDelegate.setEnabled(false).setVisible(false);
                provisioningTaskSpecifics.setEnabled(false).setVisible(false);
            } else {
                provisioningTaskSpecifics.setEnabled(false).setVisible(false);
                macroTaskSpecifics.setEnabled(false).setVisible(false);
            }
            AjaxPalettePanel actions = new AjaxPalettePanel.Builder().setAllowMoveAll(true).setAllowOrder(true).build("actions", (IModel)new PropertyModel((Object)taskTO, "actions"), (IModel)new ListModel(taskTO instanceof PushTaskTO ? (List)this.pushActions.getObject() : (List)this.inboundActions.getObject()));
            provisioningTaskSpecifics.add(new Component[]{actions.setOutputMarkupId(true)});
            AjaxDropDownChoicePanel matchingRule = new AjaxDropDownChoicePanel("matchingRule", "matchingRule", (IModel)new PropertyModel((Object)taskTO, "matchingRule"), false);
            matchingRule.setChoices(List.of(MatchingRule.values()));
            provisioningTaskSpecifics.add(new Component[]{matchingRule});
            AjaxDropDownChoicePanel unmatchingRule = new AjaxDropDownChoicePanel("unmatchingRule", "unmatchingRule", (IModel)new PropertyModel((Object)taskTO, "unmatchingRule"), false);
            unmatchingRule.setChoices(List.of(UnmatchingRule.values()));
            provisioningTaskSpecifics.add(new Component[]{unmatchingRule});
            AjaxCheckBoxPanel performCreate = new AjaxCheckBoxPanel("performCreate", "performCreate", (IModel)new PropertyModel((Object)taskTO, "performCreate"), false);
            provisioningTaskSpecifics.add(new Component[]{performCreate});
            AjaxCheckBoxPanel performUpdate = new AjaxCheckBoxPanel("performUpdate", "performUpdate", (IModel)new PropertyModel((Object)taskTO, "performUpdate"), false);
            provisioningTaskSpecifics.add(new Component[]{performUpdate});
            AjaxCheckBoxPanel performDelete = new AjaxCheckBoxPanel("performDelete", "performDelete", (IModel)new PropertyModel((Object)taskTO, "performDelete"), false);
            provisioningTaskSpecifics.add(new Component[]{performDelete});
            AjaxCheckBoxPanel syncStatus = new AjaxCheckBoxPanel("syncStatus", "syncStatus", (IModel)new PropertyModel((Object)taskTO, "syncStatus"), false);
            provisioningTaskSpecifics.add(new Component[]{syncStatus});
            final PropertyModel concurrentSettingsModel = new PropertyModel((Object)taskTO, "concurrentSettings");
            AjaxCheckBoxPanel enableConcurrentSettings = new AjaxCheckBoxPanel("enableConcurrentSettings", "enableConcurrentSettings", (IModel)new IModel<Boolean>(){
                private static final long serialVersionUID = -7126718045816207110L;
                final /* synthetic */ Profile this$1;
                {
                    this.this$1 = this$1;
                }

                public Boolean getObject() {
                    return concurrentSettingsModel.getObject() != null;
                }

                public void setObject(Boolean object) {
                }
            });
            provisioningTaskSpecifics.add(new Component[]{enableConcurrentSettings.setVisible(taskTO instanceof ProvisioningTaskTO).setOutputMarkupId(true)});
            final FieldPanel poolSize = new AjaxNumberFieldPanel.Builder().min((Number)1).build("poolSize", "poolSize", Integer.class, (IModel)new ConcurrentSettingsValueModel((PropertyModel<ThreadPoolSettings>)concurrentSettingsModel, "poolSize")).setRequired(true);
            poolSize.setOutputMarkupPlaceholderTag(true).setOutputMarkupId(true);
            poolSize.setVisible(taskTO instanceof ProvisioningTaskTO ? concurrentSettingsModel.getObject() != null : false);
            provisioningTaskSpecifics.add(new Component[]{poolSize});
            enableConcurrentSettings.getField().add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior(this, "change"){
                private static final long serialVersionUID = -1107858522700306810L;
                final /* synthetic */ Profile this$1;
                {
                    this.this$1 = this$1;
                    super(event);
                }

                protected void onUpdate(AjaxRequestTarget target) {
                    if (concurrentSettingsModel.getObject() == null) {
                        concurrentSettingsModel.setObject((Object)new ThreadPoolSettings());
                    } else {
                        concurrentSettingsModel.setObject(null);
                    }
                    poolSize.setVisible(concurrentSettingsModel.getObject() != null);
                    target.add(new Component[]{provisioningTaskSpecifics});
                }
            }});
        }

        private AjaxSearchFieldPanel destinationRealm(String id, SchedTaskTO taskTO, AutoCompleteSettings settings) {
            AjaxSearchFieldPanel destinationRealm = new AjaxSearchFieldPanel(id, "destinationRealm", (IModel)new PropertyModel((Object)taskTO, "destinationRealm"), settings){
                private static final long serialVersionUID = -6390474600233486704L;

                @Override
                protected Iterator<String> getChoices(String input) {
                    return (RealmsUtils.checkInput(input) ? SchedTaskWizardBuilder.this.searchRealms(input) : List.of()).iterator();
                }
            };
            if (taskTO instanceof InboundTaskTO) {
                InboundTaskTO inboundTask = (InboundTaskTO)taskTO;
                destinationRealm.addRequiredLabel();
                if (StringUtils.isBlank((CharSequence)inboundTask.getDestinationRealm())) {
                    destinationRealm.setModelObject((Serializable)((Object)"/"));
                }
            }
            return destinationRealm;
        }

        private AjaxCheckBoxPanel remediation(String id, SchedTaskTO taskTO) {
            return new AjaxCheckBoxPanel(id, "remediation", (IModel)new PropertyModel((Object)taskTO, "remediation"), false);
        }
    }

    protected class Schedule
    extends WizardStep {
        private static final long serialVersionUID = -785981096328637758L;

        protected Schedule(SchedTaskTO taskTO) {
            SchedTaskWizardBuilder.this.crontabPanel = new CrontabPanel("schedule", (PropertyModel<String>)new PropertyModel((Object)taskTO, "cronExpression"), taskTO.getCronExpression());
            this.add(new Component[]{SchedTaskWizardBuilder.this.crontabPanel});
        }
    }

    protected static class ConcurrentSettingsValueModel
    implements IModel<Integer> {
        private static final long serialVersionUID = 8869612332790116116L;
        private final PropertyModel<ThreadPoolSettings> concurrentSettingsModel;
        private final String property;

        public ConcurrentSettingsValueModel(PropertyModel<ThreadPoolSettings> concurrentSettingsModel, String property) {
            this.concurrentSettingsModel = concurrentSettingsModel;
            this.property = property;
        }

        public Integer getObject() {
            return Optional.ofNullable((ThreadPoolSettings)this.concurrentSettingsModel.getObject()).map(s -> (Integer)PropertyAccessorFactory.forBeanPropertyAccess((Object)s).getPropertyValue(this.property)).orElse(null);
        }

        public void setObject(Integer object) {
            Optional.ofNullable((ThreadPoolSettings)this.concurrentSettingsModel.getObject()).ifPresent(s -> PropertyAccessorFactory.forBeanPropertyAccess((Object)s).setPropertyValue(this.property, (Object)object));
        }
    }
}

